/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map.texture.osm.primitives;

import de.nx42.maps4cim.config.texture.ColorDef;
import de.nx42.maps4cim.config.texture.NodeDef;
import de.nx42.maps4cim.map.texture.osm.primitives.RenderPrimitive;
import de.nx42.maps4cim.util.gis.Coordinate;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;

public class Point
extends RenderPrimitive {
    protected final Coordinate coord;
    protected double radius;

    public Point(Coordinate coord) {
        this.coord = coord;
        this.radius = 1.0;
    }

    public Point(NodeDef def, Node node) {
        this.coord = new Coordinate(node);
        this.radius = def.getRadius();
    }

    public Point(NodeDef def, Node node, ColorDef color) {
        super(color);
        this.coord = new Coordinate(node);
        this.radius = def.getRadius();
    }

    public Point(NodeDef def, Node node, Collection<ColorDef> colors) {
        super(colors, def);
        this.coord = new Coordinate(node);
        this.radius = def.getRadius();
    }

    public Point(Coordinate coord, int color, double radius) {
        super(color);
        this.coord = coord;
        this.radius = radius;
    }

    public Point(Coordinate coord, int color) {
        this(coord, color, 1.0);
    }

    public Point(Coordinate coord, ColorDef color) {
        super(color);
        this.coord = coord;
        this.radius = 1.0;
    }

    public Point(Coordinate coord, Collection<ColorDef> colors, NodeDef def) {
        super(colors, def);
        this.coord = coord;
        this.radius = def.getRadius();
    }

    public Coordinate getCoord() {
        return this.coord;
    }

    public double getRadius() {
        return this.radius;
    }

    public static List<Point> getPoints(NodeDef def, Collection<Node> xmlNodes) {
        LinkedList<Point> points = new LinkedList<Point>();
        for (Node node : xmlNodes) {
            points.add(new Point(def, node));
        }
        return points;
    }
}

