/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map.texture.osm;

import de.nx42.maps4cim.map.texture.osm.RenderContainer;
import de.nx42.maps4cim.map.texture.osm.primitives.Point;
import de.nx42.maps4cim.map.texture.osm.primitives.Polygon;
import de.nx42.maps4cim.map.texture.osm.primitives.Polyline;
import de.nx42.maps4cim.map.texture.osm.primitives.RenderPrimitive;
import de.nx42.maps4cim.util.gis.Area;
import de.nx42.maps4cim.util.gis.Coordinate;
import de.nx42.maps4cim.util.java2d.Polygon2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;

public class TileRenderer {
    public static final int CiM2MapSize = 2048;
    protected final int width;
    protected final int height;
    protected Area area;
    protected BufferedImage bi;
    protected Graphics2D g2;

    public TileRenderer(Area area) {
        this(2048, 2048, area);
    }

    public TileRenderer(int width, int height, Area area) {
        this.width = width;
        this.height = height;
        this.area = area;
        this.bi = new BufferedImage(width, height, 2);
        this.g2 = this.bi.createGraphics();
        TileRenderer.setHighQuality(this.g2);
    }

    public void draw(Polyline way) {
        List<Coordinate> coords = way.getNodes();
        if (coords.size() < 2) {
            return;
        }
        Iterator<Coordinate> it = coords.iterator();
        Coordinate c1 = it.next();
        Coordinate.RelativeCoord rc1 = c1.relativeWithinArea(this.area);
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(rc1.x * (double)this.width, rc1.y * (double)this.height);
        while (it.hasNext()) {
            Coordinate c = it.next();
            Coordinate.RelativeCoord rc = c.relativeWithinArea(this.area);
            ((Path2D)path).lineTo(rc.x * (double)this.width, rc.y * (double)this.height);
        }
        this.g2.setPaint(new Color(way.getColor(), false));
        this.g2.setStroke(new BasicStroke((float)way.getStrokeWidth()));
        this.g2.draw(path);
    }

    public void draw(Polygon polygon) {
        List<Coordinate> coords = polygon.getNodes();
        if (coords.size() < 2) {
            return;
        }
        Polygon2D poly = new Polygon2D();
        for (Coordinate c : coords) {
            Coordinate.RelativeCoord rc = c.relativeWithinArea(this.area);
            poly.addPoint((float)(rc.x * (double)this.width), (float)(rc.y * (double)this.height));
        }
        this.g2.setPaint(new Color(polygon.getColor(), false));
        this.g2.fill(poly);
        this.g2.draw(poly);
    }

    public void draw(Point point) {
        Coordinate coord = point.getCoord();
        Coordinate.RelativeCoord rc = coord.relativeWithinArea(this.area);
        double centerX = rc.x * (double)this.width;
        double centerY = rc.y * (double)this.height;
        double cornerX = centerX - point.getRadius();
        double cornerY = centerY - point.getRadius();
        Ellipse2D.Double circle = new Ellipse2D.Double();
        circle.setFrameFromCenter(centerX, centerY, cornerX, cornerY);
        this.g2.setPaint(new Color(point.getColor(), false));
        this.g2.fill(circle);
    }

    public void draw(RenderContainer rc) {
        switch (rc.type) {
            case POINT: {
                Collection<? extends RenderPrimitive> points = rc.getPrimitives();
                for (Point point : points) {
                    this.draw(point);
                }
                break;
            }
            case POLYGON: {
                Collection<? extends RenderPrimitive> collection = rc.getPrimitives();
                for (Polygon polygon : collection) {
                    this.draw(polygon);
                }
                break;
            }
            case POLYLINE: {
                Collection<? extends RenderPrimitive> collection = rc.getPrimitives();
                for (Polyline polyline : collection) {
                    this.draw(polyline);
                }
                break;
            }
            default: {
                throw new RuntimeException(String.format("Type %s not recognized", new Object[]{rc.type}));
            }
        }
    }

    public void printResult() {
        try {
            ImageIO.write((RenderedImage)this.bi, "PNG", new File("target/image.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Raster getRaster() {
        return this.bi.getRaster();
    }

    public static void setHighQuality(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }
}

