/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map.texture.osm;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.XmlReader;

public class SimpleOsmDump
implements Sink {
    protected final List<Node> nodes = new LinkedList<Node>();
    protected final List<Way> ways = new LinkedList<Way>();
    protected final List<Relation> relations = new LinkedList<Relation>();
    protected Map<Long, Node> nodeById = new HashMap<Long, Node>();

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Way> getWays() {
        return this.ways;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public Node getNodeById(long id) {
        return this.nodeById.get(id);
    }

    public Node getNodeById(WayNode wayNode) {
        return this.nodeById.get(wayNode.getNodeId());
    }

    public List<Node> getNodesById(Way way) {
        ArrayList<Node> wayNodes = new ArrayList<Node>(way.getWayNodes().size());
        for (WayNode wn : way.getWayNodes()) {
            wayNodes.add(this.getNodeById(wn));
        }
        return wayNodes;
    }

    @Override
    public void process(EntityContainer entityContainer) {
        Entity entity = entityContainer.getEntity();
        if (entity instanceof Node) {
            Node node = (Node)entity;
            this.nodes.add(node);
            this.nodeById.put(node.getId(), node);
        } else if (entity instanceof Way) {
            Way way = (Way)entity;
            this.ways.add(way);
        } else if (entity instanceof Relation) {
            Relation rel = (Relation)entity;
            this.relations.add(rel);
        }
    }

    protected void processRelations() {
        for (Relation rel : this.relations) {
            List<RelationMember> members = rel.getMembers();
            members.get(0).getMemberId();
        }
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
    }

    @Override
    public void complete() {
    }

    @Override
    public void release() {
    }

    public static SimpleOsmDump readOsmXml(File osmxml) {
        SimpleOsmDump sink = new SimpleOsmDump();
        CompressionMethod compression = CompressionMethod.None;
        if (osmxml.getName().endsWith(".gz")) {
            compression = CompressionMethod.GZip;
        } else if (osmxml.getName().endsWith(".bz2")) {
            compression = CompressionMethod.BZip2;
        }
        XmlReader reader = new XmlReader(osmxml, false, compression);
        reader.setSink(sink);
        Thread readerThread = new Thread(reader);
        readerThread.start();
        while (readerThread.isAlive()) {
            try {
                readerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return sink;
    }

    public static void print(Node node) {
        System.out.format("%s: %10s (%-10s, %-10s), version %2s by %s\n", "Node", node.getId(), node.getLatitude(), node.getLongitude(), String.valueOf(node.getVersion()), node.getUser().getName());
        SimpleOsmDump.printTags(node.getTags());
    }

    public static void print(Way way) {
        System.out.format("%s: %10s, version %2s by %s with %s waypoints\n", "Way", way.getId(), way.getVersion(), way.getUser().getName(), way.getWayNodes().size());
        SimpleOsmDump.printTags(way.getTags());
    }

    public static void printTags(Collection<Tag> tags) {
        if (tags.size() > 0) {
            System.out.format("\tTags: %s\n", SimpleOsmDump.formatTags(tags));
        }
    }

    public static String formatTags(Collection<Tag> tags) {
        StringBuilder sb = new StringBuilder(tags.size() * 20);
        for (Tag tag : tags) {
            sb.append(", ");
            sb.append(tag.getKey());
            sb.append('=');
            sb.append(tag.getValue());
        }
        if (sb.length() > 2) {
            sb.delete(0, 2);
        }
        return sb.toString();
    }
}

