/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map.texture.osm;

import de.nx42.maps4cim.map.texture.osm.primitives.Point;
import de.nx42.maps4cim.map.texture.osm.primitives.Polygon;
import de.nx42.maps4cim.map.texture.osm.primitives.Polyline;
import de.nx42.maps4cim.map.texture.osm.primitives.RenderPrimitive;
import java.util.Collection;

public class RenderContainer {
    protected Collection<? extends RenderPrimitive> primitives;
    protected ElementType type;

    public RenderContainer(Collection<RenderPrimitive> primitives) {
        this.primitives = primitives;
        this.type = ElementType.of(primitives.iterator().next());
    }

    public Collection<? extends RenderPrimitive> getPrimitives() {
        return this.primitives;
    }

    public ElementType getType() {
        return this.type;
    }

    public static enum ElementType {
        POINT,
        POLYGON,
        POLYLINE;


        public static ElementType of(RenderPrimitive rp) {
            if (rp instanceof Polyline) {
                return POLYLINE;
            }
            if (rp instanceof Polygon) {
                return POLYGON;
            }
            if (rp instanceof Point) {
                return POINT;
            }
            throw new RuntimeException("RenderPrimitive Implementation not recognized!");
        }
    }
}

