/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map.texture.osm;

import de.nx42.maps4cim.config.texture.EntityDef;
import de.nx42.maps4cim.config.texture.NodeDef;
import de.nx42.maps4cim.config.texture.PolygonDef;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;

public class OverpassTagMatcher {
    protected EntityType type;
    protected String key;
    protected Value value;

    public OverpassTagMatcher(EntityDef def) {
        this.type = this.inferType(def);
        this.key = def.key;
        this.value = Value.of(def);
    }

    public OverpassTagMatcher(EntityType type, String key, String value, boolean regexValue) {
        this.type = type;
        this.key = key;
        this.value = Value.of(value, regexValue);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value.getValue();
    }

    public boolean matches(Entity entity) {
        if (entity.getType() != this.type) {
            return false;
        }
        Collection<Tag> tags = entity.getTags();
        for (Tag tag : tags) {
            if (!this.key.equals(tag.getKey()) || !this.value.matches(tag.getValue())) continue;
            return true;
        }
        return false;
    }

    protected EntityType inferType(EntityDef def) {
        if (def instanceof NodeDef) {
            return EntityType.Node;
        }
        if (def instanceof PolygonDef) {
            return EntityType.Way;
        }
        throw new RuntimeException("Unexpected input type. Must be one of Node, Polygon or Way.");
    }

    protected static abstract class Value {
        protected Value() {
        }

        public abstract boolean matches(String var1);

        public abstract String getValue();

        public static Value of(EntityDef def) {
            if (def.allowsAnyValue()) {
                return new Any();
            }
            if (def.hasExactValue()) {
                return new Exact(def.value);
            }
            return new Regex(Pattern.compile(def.rvalue).matcher(""));
        }

        public static Value of(String value, boolean regex) {
            if (value == null || value.trim().isEmpty() || value.trim().equals("*")) {
                return new Any();
            }
            if (regex) {
                return new Regex(Pattern.compile(value).matcher(""));
            }
            return new Exact(value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return this.getClass() == obj.getClass();
        }

        protected static class Any
        extends Value {
            protected Any() {
            }

            @Override
            public boolean matches(String s) {
                return true;
            }

            @Override
            public String getValue() {
                return null;
            }
        }

        protected static class Exact
        extends Value {
            protected final String exactMatch;

            public Exact(String exactMatch) {
                this.exactMatch = exactMatch;
            }

            @Override
            public boolean matches(String s) {
                return this.exactMatch.equals(s);
            }

            @Override
            public String getValue() {
                return this.exactMatch;
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!super.equals(obj)) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Exact other = (Exact)obj;
                return !(this.exactMatch == null ? other.exactMatch != null : !this.exactMatch.equals(other.exactMatch));
            }
        }

        protected static class Regex
        extends Value {
            protected final Matcher regexMatch;

            public Regex(Matcher regexMatch) {
                this.regexMatch = regexMatch;
            }

            @Override
            public boolean matches(String s) {
                return this.regexMatch.reset(s).find();
            }

            @Override
            public String getValue() {
                return this.regexMatch.pattern().pattern();
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!super.equals(obj)) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Regex other = (Regex)obj;
                return !(this.regexMatch == null ? other.regexMatch != null : !this.regexMatch.pattern().pattern().equals(other.regexMatch.pattern().pattern()));
            }
        }
    }
}

