/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map.texture.osm;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import de.nx42.maps4cim.config.Config;
import de.nx42.maps4cim.config.texture.EntityDef;
import de.nx42.maps4cim.map.Cache;
import de.nx42.maps4cim.map.ex.TextureProcessingException;
import de.nx42.maps4cim.util.Compression;
import de.nx42.maps4cim.util.gis.Area;
import de.nx42.maps4cim.util.xml.Network;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverpassBridge {
    private static final Logger log = LoggerFactory.getLogger(OverpassBridge.class);
    protected static final String[] servers = new String[]{"http://overpass.osm.rambler.ru/cgi/interpreter?data=", "http://overpass-api.de/api/interpreter?data=", "http://api.openstreetmap.fr/oapi/interpreter?data="};
    protected static final String queryBegin = "(";
    protected static final String queryEnd = ");(._;>;);out meta;";
    protected static final ImmutableMap<Character, String> escapeChars = ImmutableMap.builder().put(Character.valueOf('\n'), "\\n").put(Character.valueOf('\t'), "\\t").put(Character.valueOf('\"'), "\\\"").put(Character.valueOf('\''), "\\'").put(Character.valueOf('\\'), "\\\\").build();
    protected Area bounds;
    protected List<EntityDef> entities;
    protected Cache cache = new Cache();
    protected boolean caching = true;

    public OverpassBridge(Config conf) {
        this.bounds = Area.of(conf.bounds);
        this.entities = conf.texture.entities;
    }

    public File getResult() throws TextureProcessingException {
        String hash = this.getQueryHash();
        if (this.isCached(hash)) {
            log.debug("Retrieving Overpass query result from cache.");
            try {
                return this.getCached(hash);
            }
            catch (IOException e) {
                log.error("Error retrieving the OpenStreetMap-Result from cache.", e);
                throw new RuntimeException("Error reading Overpass-Result from cache", e);
            }
        }
        log.debug("Downloading OpenStreetMap data from the Overpass servers. This might take a few minutes...");
        return this.downloadAndCache(hash);
    }

    protected File downloadAndCache(String hash) throws TextureProcessingException {
        IOException inner = null;
        String[] stringArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            try {
                Stopwatch stopwatch = new Stopwatch();
                stopwatch.start();
                URL query = this.buildURL(server);
                File dest = Cache.temporaray(OverpassBridge.getXmlFileName(hash));
                this.downloadQueryResult(query, dest);
                if (this.caching) {
                    this.storeInCache(dest, hash);
                }
                stopwatch.stop();
                log.debug("Download from server {} finished in {}", (Object)query.getHost(), (Object)stopwatch.toString());
                return dest;
            }
            catch (UnknownHostException e) {
                inner = e;
                log.error("The URL of Overpass-Server {} could not be resolved. Are you connected to the internet?", (Object)e.getMessage());
            }
            catch (SocketTimeoutException e) {
                inner = e;
                log.error("Error getting data from Overpass Server " + server + "\nTrying next ...", e);
            }
            catch (IOException e) {
                inner = e;
                log.error("I/O Exception while processing OpenStreetMap source data.", e);
            }
            ++n2;
        }
        throw new TextureProcessingException("OpenStreetMap source data could not be retrieved via Overpass API.", inner);
    }

    public File downloadQueryResult(URL query, File dest) throws SocketTimeoutException, IOException {
        Network.downloadToFile(query, dest, 5.0, 90.0);
        return dest;
    }

    protected URL buildURL(String server) {
        try {
            return new URL(String.valueOf(server) + URLEncoder.encode(this.buildQuery(), "UTF-8"));
        }
        catch (Exception e) {
            String error = "Creating of Overpass-Query URL failed";
            log.error(error, e);
            throw new RuntimeException(error, e);
        }
    }

    public String buildQuery() {
        StringBuilder sb = new StringBuilder(64 * this.entities.size());
        sb.append(queryBegin);
        for (EntityDef entity : this.entities) {
            this.buildSingleEntityQuery(entity, sb);
        }
        sb.append(queryEnd);
        return sb.toString();
    }

    protected StringBuilder buildSingleEntityQuery(EntityDef entity, StringBuilder sb) {
        sb.append(entity.getType());
        sb.append("[\"");
        sb.append(OverpassBridge.escapeOverpassQuery(entity.key));
        sb.append('\"');
        if (!entity.allowsAnyValue()) {
            if (entity.hasRegexValue()) {
                sb.append('~');
            } else {
                sb.append('=');
            }
            sb.append('\"');
            sb.append(OverpassBridge.escapeOverpassQuery(entity.getValue()));
            sb.append('\"');
        }
        sb.append(']');
        sb.append(this.bounds.getStringOverpassBounds());
        sb.append(';');
        return sb;
    }

    protected static String escapeOverpassQuery(String query) {
        StringBuilder sb = new StringBuilder((int)((double)query.length() * 1.3));
        int i = 0;
        while (i < query.length()) {
            char c = query.charAt(i);
            if (escapeChars.containsKey(Character.valueOf(c))) {
                sb.append(escapeChars.get(Character.valueOf(c)));
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    protected String getQueryHash() {
        HashFunction hf = Hashing.md5();
        Hasher h = hf.newHasher();
        h.putInt((int)(this.bounds.getMinLat() * 10000.0)).putInt((int)(this.bounds.getMaxLat() * 10000.0)).putInt((int)(this.bounds.getMinLon() * 10000.0)).putInt((int)(this.bounds.getMaxLon() * 10000.0));
        for (EntityDef def : this.entities) {
            h.putInt(def.hashCode());
        }
        return String.valueOf(Math.abs(h.hash().asLong()));
    }

    protected boolean isCached(String hash) {
        return this.cache.has(OverpassBridge.getCacheFileName(hash));
    }

    protected File getCached(String hash) throws IOException {
        File zipped = this.cache.get(OverpassBridge.getCacheFileName(hash));
        File unzipped = Cache.temporaray(OverpassBridge.getXmlFileName(hash));
        return Compression.readFirstZipEntry(zipped, unzipped);
    }

    protected void storeInCache(File xml, String hash) throws IOException {
        File zip = this.cache.allocate(OverpassBridge.getCacheFileName(hash));
        Compression.storeAsZip(xml, zip);
    }

    protected static String getXmlFileName(String hash) {
        return "osm-" + hash + ".xml";
    }

    protected static String getCacheFileName(String hash) {
        return "osm-" + hash + ".xml.zip";
    }
}

