/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map.texture.osm;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.nx42.maps4cim.config.Config;
import de.nx42.maps4cim.config.texture.ColorDef;
import de.nx42.maps4cim.config.texture.EntityDef;
import de.nx42.maps4cim.config.texture.NodeDef;
import de.nx42.maps4cim.config.texture.PolygonDef;
import de.nx42.maps4cim.config.texture.WayDef;
import de.nx42.maps4cim.map.texture.osm.OverpassTagMatcher;
import de.nx42.maps4cim.map.texture.osm.RenderContainer;
import de.nx42.maps4cim.map.texture.osm.SimpleOsmDump;
import de.nx42.maps4cim.map.texture.osm.primitives.Point;
import de.nx42.maps4cim.map.texture.osm.primitives.Polygon;
import de.nx42.maps4cim.map.texture.osm.primitives.Polyline;
import de.nx42.maps4cim.map.texture.osm.primitives.RenderPrimitive;
import de.nx42.maps4cim.util.gis.Coordinate;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityConverter {
    private static Logger log = LoggerFactory.getLogger(EntityConverter.class);
    protected Config config;
    protected List<EntityDef> defs;
    protected Collection<ColorDef> colors;
    protected SimpleOsmDump sink;
    List<OverpassTagMatcher> filters = new LinkedList<OverpassTagMatcher>();
    protected Map<OverpassTagMatcher, EntityDef> filterMap = new HashMap<OverpassTagMatcher, EntityDef>();
    protected Multimap<EntityDef, Entity> defToEntities;

    public EntityConverter(Config config, SimpleOsmDump sink) {
        this.config = config;
        this.defs = config.texture.entities;
        this.colors = config.texture.colors;
        this.sink = sink;
        this.createFilters();
    }

    protected void createFilters() {
        for (EntityDef def : this.defs) {
            OverpassTagMatcher matcher = new OverpassTagMatcher(def);
            this.filters.add(matcher);
            this.filterMap.put(matcher, def);
        }
    }

    public List<RenderContainer> buildRenderContainers() {
        this.matchAll();
        LinkedList<RenderContainer> rc = new LinkedList<RenderContainer>();
        for (EntityDef def : this.defs) {
            Collection<Entity> osmEntities;
            Collection<RenderPrimitive> primitives = this.getRenderPrimitives(def, osmEntities = this.defToEntities.get(def));
            if (primitives.size() <= 0) continue;
            rc.add(new RenderContainer(primitives));
        }
        return rc;
    }

    protected void matchAll() {
        List<Node> nodes = this.sink.getNodes();
        List<Way> ways = this.sink.getWays();
        this.defToEntities = HashMultimap.create(this.filters.size(), (nodes.size() + ways.size()) / this.filters.size());
        this.matchAll(nodes);
        this.matchAll(ways);
    }

    protected void matchAll(List<? extends Entity> entities) {
        for (Entity entity : entities) {
            for (OverpassTagMatcher filter : this.filters) {
                if (!filter.matches(entity)) continue;
                this.defToEntities.put(this.filterMap.get(filter), entity);
            }
        }
    }

    protected Collection<RenderPrimitive> getRenderPrimitives(EntityDef def, Collection<Entity> osmEntities) {
        LinkedList<RenderPrimitive> primitives = new LinkedList<RenderPrimitive>();
        for (Entity entitiy : osmEntities) {
            primitives.add(this.getRenderPrimitive(def, entitiy));
        }
        return primitives;
    }

    protected RenderPrimitive getRenderPrimitive(EntityDef def, Entity osmEntity) {
        if (def instanceof WayDef) {
            if (osmEntity instanceof Way) {
                List<Node> wayNodes = this.sink.getNodesById((Way)osmEntity);
                return new Polyline(Coordinate.convert(wayNodes), this.colors, (WayDef)def);
            }
            throw new RuntimeException("Unexpected OSM Entity Type.");
        }
        if (def instanceof PolygonDef) {
            if (osmEntity instanceof Way) {
                List<Node> wayNodes = this.sink.getNodesById((Way)osmEntity);
                return new Polygon(Coordinate.convert(wayNodes), this.colors, (PolygonDef)def);
            }
            throw new RuntimeException("Unexpected OSM Entity Type.");
        }
        if (def instanceof NodeDef) {
            if (osmEntity instanceof Node) {
                return new Point((NodeDef)def, (Node)osmEntity, this.colors);
            }
            throw new RuntimeException("Unexpected OSM Entity Type.");
        }
        throw new RuntimeException("Unsupported Entity-Type");
    }
}

