/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map.texture;

import de.nx42.maps4cim.config.Config;
import de.nx42.maps4cim.map.TextureMap;
import de.nx42.maps4cim.map.ex.TextureProcessingException;
import de.nx42.maps4cim.map.texture.CiMTexture;
import de.nx42.maps4cim.map.texture.SingleTexture;
import de.nx42.maps4cim.map.texture.osm.EntityConverter;
import de.nx42.maps4cim.map.texture.osm.OverpassBridge;
import de.nx42.maps4cim.map.texture.osm.RenderContainer;
import de.nx42.maps4cim.map.texture.osm.SimpleOsmDump;
import de.nx42.maps4cim.map.texture.osm.TileRenderer;
import de.nx42.maps4cim.util.MathExt;
import de.nx42.maps4cim.util.gis.Area;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmTexture
extends TextureMap {
    private static final Logger log = LoggerFactory.getLogger(TextureMap.class);
    protected Config config;
    protected Area bounds;

    public OsmTexture(Config config) {
        log.debug("Using OpenStreetMap as source for the map's texture");
        this.config = config;
        this.bounds = Area.of(config.bounds);
    }

    @Override
    public int[][] generateTexture() throws TextureProcessingException {
        try {
            if (this.config.texture.entities.size() < 1) {
                return this.fallBackToGrass();
            }
        }
        catch (Exception e) {
            return this.fallBackToGrass();
        }
        log.info("The ground textures will be generated for an area of {}x{}km, with the center at ({}). Data source: OpenStreetMap via Overpass API.", MathExt.roundf(this.bounds.getWidthKm()), MathExt.roundf(this.bounds.getHeightKm()), this.bounds.getCenter().toString());
        SimpleOsmDump osm = this.retrieveOsmData();
        Raster ras = this.drawImage(osm);
        log.debug("Converting rendered image to native CiM2-Texture data");
        return OsmTexture.convertImage(ras);
    }

    protected int[][] fallBackToGrass() {
        log.info("No data has been defined for the ground texture, I'll just draw some grass...");
        SingleTexture st = new SingleTexture();
        return st.generateTexture();
    }

    protected SimpleOsmDump retrieveOsmData() throws TextureProcessingException {
        OverpassBridge ob = new OverpassBridge(this.config);
        File osmxml = ob.getResult();
        log.debug("Parsing OSM XML with a little help from Osmosis API");
        return SimpleOsmDump.readOsmXml(osmxml);
    }

    protected Raster drawImage(SimpleOsmDump osm) throws TextureProcessingException {
        log.debug("Preparing OSM data for rendering");
        EntityConverter ec = new EntityConverter(this.config, osm);
        List<RenderContainer> rcs = ec.buildRenderContainers();
        log.debug("Rendering {} layers of OSM data", (Object)rcs.size());
        TileRenderer ir = new TileRenderer(this.bounds);
        for (RenderContainer rc : rcs) {
            ir.draw(rc);
        }
        return ir.getRaster();
    }

    protected static int[][] convertImage(Raster ras) {
        int[] pixels = ((DataBufferInt)ras.getDataBuffer()).getData();
        int width = ras.getWidth();
        int height = ras.getHeight();
        int[][] result = new int[height][width];
        int y = 0;
        while (y < 2048) {
            int x = 0;
            while (x < 2048) {
                int texture;
                int argb = pixels[(2047 - x) * 2048 + y];
                int r = argb & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb >> 16 & 0xFF;
                int a = argb >> 24 & 0xFF;
                float alpha = (float)a / 255.0f;
                result[y][x] = texture = CiMTexture.draw((int)((float)r * alpha), (int)((float)g * alpha), (int)((float)b * alpha));
                ++x;
            }
            ++y;
        }
        return result;
    }
}

