/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map.texture;

import de.nx42.maps4cim.config.texture.ColorDef;

public enum CiMTexture {
    GRASS(24){

        @Override
        public int draw() {
            return -1879048192;
        }

        @Override
        public int draw(float opacity) {
            if ((double)opacity <= 0.0 || (double)opacity >= 1.0) {
                return -1879048192;
            }
            return Math.round(opacity * 65.0f) + 85 << 24;
        }
    }
    ,
    ROUGH_GRASS(0),
    DIRT(8),
    MUD(16),
    PAVEMENT(24){

        @Override
        public int draw() {
            return -16777216;
        }

        @Override
        public int draw(float opacity) {
            if ((double)opacity <= 0.0) {
                return -1879048192;
            }
            if ((double)opacity >= 1.0) {
                return -16777216;
            }
            return Math.round(opacity * 88.0f) + 167 << 24;
        }
    }
    ,
    BLACK(24){

        @Override
        public int draw() {
            return 0;
        }

        @Override
        public int draw(float opacity) {
            if ((double)opacity <= 0.0) {
                return -1879048192;
            }
            if ((double)opacity >= 1.0) {
                return 0;
            }
            return Math.round((1.0f - opacity) * 62.0f) << 24;
        }
    }
    ,
    MIX_DARK_MUD(0){

        @Override
        public int draw() {
            return 4.draw(255, 0, 255);
        }

        @Override
        public int draw(float opacity) {
            return 4.draw(opacity, 0.0f, opacity);
        }
    }
    ,
    MIX_DARK_DIRT(0){

        @Override
        public int draw() {
            return 5.draw(255, 255, 0);
        }

        @Override
        public int draw(float opacity) {
            return 5.draw(opacity, opacity, 0.0f);
        }
    }
    ,
    MIX_PINK(0){

        @Override
        public int draw() {
            return 6.draw(0, 255, 255);
        }

        @Override
        public int draw(float opacity) {
            return 6.draw(0.0f, opacity, opacity);
        }
    }
    ,
    MIX_MAGENTA(0){

        @Override
        public int draw() {
            return -1862270977;
        }

        @Override
        public int draw(float opacity) {
            return 7.draw(opacity, opacity, opacity);
        }
    };

    protected static final int base = -1879048192;
    protected int offset;

    private CiMTexture(int offset) {
        this.offset = offset;
    }

    public int draw() {
        return 0x90000000 | 255 << this.offset;
    }

    public int draw(float opacity) {
        int byteValue = CiMTexture.floatToByte(opacity);
        return 0x90000000 | byteValue << this.offset;
    }

    public static int floatToByte(float opacity) {
        int byteValue = Math.round(opacity * 255.0f);
        if (byteValue > 255) {
            return 255;
        }
        if (byteValue < 0) {
            return 0;
        }
        return byteValue;
    }

    public static int draw(int roughGrass, int mud, int dirt) {
        return roughGrass | mud << 8 | dirt << 16 | 0x90000000;
    }

    public static int draw(int base, int roughGrass, int mud, int dirt) {
        return roughGrass | mud << 8 | dirt << 16 | base << 24;
    }

    public static int draw(float roughGrass, float mud, float dirt) {
        return CiMTexture.floatToByte(roughGrass) | CiMTexture.floatToByte(mud) << 8 | CiMTexture.floatToByte(dirt) << 16 | 0x90000000;
    }

    public static int draw(float base, float roughGrass, float mud, float dirt) {
        return CiMTexture.floatToByte(roughGrass) | CiMTexture.floatToByte(mud) << 8 | CiMTexture.floatToByte(dirt) << 16 | CiMTexture.floatToByte(base) << 24;
    }

    public static int mix(int texture1, int texture2) {
        return texture1 | texture2;
    }

    public static int mix(int texture1, int texture2, int texture3) {
        return texture1 | texture2 | texture3;
    }

    public static int draw(ColorDef def, float alpha) {
        if (def == null) {
            return GRASS.draw();
        }
        if (def.black != null && def.black > 0.0) {
            return BLACK.draw(def.black.floatValue() * alpha);
        }
        if (def.pavement != null && def.pavement > 0.0) {
            return PAVEMENT.draw(def.black.floatValue() * alpha);
        }
        return CiMTexture.draw(def.getSafeRoughGrass(), def.getSafeMud(), def.getSafeDirt());
    }

    public static int draw(ColorDef def) {
        return CiMTexture.draw(def, 1.0f);
    }

    /* synthetic */ CiMTexture(String string, int n, int n2, CiMTexture ciMTexture) {
        this(n2);
    }
}

