/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map.relief;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import de.nx42.maps4cim.config.Config;
import de.nx42.maps4cim.config.ReliefDef;
import de.nx42.maps4cim.map.ReliefMap;
import de.nx42.maps4cim.map.ex.ReliefProcessingException;
import de.nx42.maps4cim.map.relief.srtm.TileDownload;
import de.nx42.maps4cim.util.Compression;
import de.nx42.maps4cim.util.MathExt;
import de.nx42.maps4cim.util.arr2d.Arrays2D;
import de.nx42.maps4cim.util.arr2d.Bicubic;
import de.nx42.maps4cim.util.arr2d.GapInterpolator;
import de.nx42.maps4cim.util.arr2d.Interpolation;
import de.nx42.maps4cim.util.gis.Area;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRTM
extends ReliefMap {
    private static Logger log = LoggerFactory.getLogger(SRTM.class);
    public static final int srtm1length = 3601;
    public static final int srtm3length = 1201;
    public static final int srtm1maxIndex = 3600;
    public static final int srtm3maxIndex = 1200;
    public static short gap = Short.MIN_VALUE;
    protected static final GapInterpolator gip = new GapInterpolator(gap);
    protected Area bounds;
    protected boolean heightOffsetAuto = true;
    protected float heightOffset = 0.0f;
    protected float heightScale = 1.0f;
    protected int srtmLength = 1201;
    protected int srtmMaxIndex = 1200;

    public SRTM(Config conf) {
        log.debug("Using SRTM as source for the map's relief");
        this.heightOffsetAuto = conf.relief.getHeightOffsetType() == ReliefDef.HeightOffset.AUTO;
        this.heightOffset = this.heightOffsetAuto ? 32767.0f : (float)conf.relief.getHeightOffset();
        this.heightScale = conf.relief.getHeightScale().floatValue();
        this.bounds = Area.of(conf.bounds);
    }

    @Override
    public float[][] generateRelief() throws ReliefProcessingException {
        try {
            return this.fromBounds();
        }
        catch (SocketTimeoutException e) {
            log.error("Could not download the required source data, the connection timed out. Usually, this is a problem with your network connection or firewall configuration.");
            throw new ReliefProcessingException(e);
        }
        catch (UnknownHostException e) {
            log.error("The URL of the SRTM-Server {} could not be resolved. Are you connected to the internet?", (Object)e.getMessage());
            throw new ReliefProcessingException(e);
        }
        catch (IOException e) {
            log.error("I/O Exception while processing the relief.", e);
            throw new ReliefProcessingException(e);
        }
    }

    protected float[][] fromBounds() throws IOException, SocketTimeoutException, UnknownHostException {
        int x;
        double worldWidthKM = this.bounds.getWidthKm();
        double worldHeightKM = this.bounds.getHeightKm();
        log.info("The relief map will be generated for an area of {}x{}km, with the center at ({}). The virtual zero height {} and all elevations are scaled {}.", MathExt.roundf(worldWidthKM), MathExt.roundf(worldHeightKM), this.bounds.getCenter().toString(), this.heightOffset == 32767.0f ? "will be set to the highest possible value" : "is set to " + this.heightOffset, (double)this.heightScale != 1.0 ? "by factor " + MathExt.roundf(this.heightScale) : "1:1");
        double widthToHeight = worldWidthKM / worldHeightKM;
        int validMapWidth = widthToHeight >= 1.0 ? 2049 : (int)Math.round(2049.0 * widthToHeight);
        int validMapHeight = widthToHeight <= 1.0 ? 2049 : (int)Math.round(2049.0 / widthToHeight);
        int minX = (2049 - validMapWidth) / 2;
        int maxX = validMapWidth + minX;
        int minY = (2049 - validMapHeight) / 2;
        int maxY = validMapHeight + minY;
        log.debug("Retrieving SRTM data.");
        short[][] srtm = this.retrieveSRTMdata(this.bounds);
        int srtmHeight = srtm.length;
        int srtmWidth = srtm[0].length;
        float[][] srtmClean = new float[srtmHeight][srtmWidth];
        int y = 0;
        while (y < srtm.length) {
            int x2 = 0;
            while (x2 < srtm[y].length) {
                float val = srtm[srtm.length - 1 - y][x2];
                if (val == (float)gap) {
                    val = gip.star(srtm, x2, srtm.length - 1 - y);
                }
                if (val == 0.0f) {
                    val = -40.0f;
                }
                srtmClean[y][x2] = val;
                ++x2;
            }
            ++y;
        }
        int srtmLatMin = (int)Math.floor(this.bounds.getMinLat());
        int srtmLatMax = (int)Math.ceil(this.bounds.getMaxLat());
        int srtmLonMin = (int)Math.floor(this.bounds.getMinLon());
        int srtmLonMax = (int)Math.ceil(this.bounds.getMaxLon());
        int srtmLatSize = srtmLatMax - srtmLatMin;
        int srtmLonSize = srtmLonMax - srtmLonMin;
        float minLat = (float)(Math.abs(this.bounds.getMinLat() - (double)srtmLatMin) / (double)srtmLatSize * (double)srtmHeight);
        float maxLat = (float)(Math.abs(this.bounds.getMaxLat() - (double)srtmLatMin) / (double)srtmLatSize * (double)srtmHeight);
        float minLon = (float)(Math.abs(this.bounds.getMinLon() - (double)srtmLonMin) / (double)srtmLonSize * (double)srtmWidth);
        float maxLon = (float)(Math.abs(this.bounds.getMaxLon() - (double)srtmLonMin) / (double)srtmLonSize * (double)srtmWidth);
        Bicubic it = new Bicubic(srtmClean);
        log.debug("SRTM data will be cropped and scaled to correct size using bicubic interpolation");
        float[][] scaled = it.cropAndResize(validMapWidth, 2049, minLon, minLat, maxLon, maxLat);
        log.debug("Final conversion and filtering of scaled SRTM data");
        float[][] heightmap = new float[2049][2049];
        int y2 = 0;
        while (y2 < scaled.length) {
            x = 0;
            while (x < scaled.length) {
                if (x >= minX && x < maxX && y2 >= minY && y2 < maxY) {
                    float val = scaled[y2 - minY][x - minX];
                    if (this.heightOffsetAuto && val >= 0.0f && val < this.heightOffset) {
                        this.heightOffset = val;
                    }
                    heightmap[y2][x] = val;
                }
                ++x;
            }
            ++y2;
        }
        if (this.heightOffsetAuto) {
            if (this.heightOffset < 1.0f) {
                this.heightOffset = 0.0f;
            }
            log.debug("The virtual zero height has been set to {}", (Object)Float.valueOf(this.heightOffset));
        }
        if ((double)this.heightOffset != 0.0 || (double)this.heightScale != 1.0) {
            y2 = 0;
            while (y2 < heightmap.length) {
                x = 0;
                while (x < heightmap.length) {
                    if (heightmap[y2][x] > 0.0f) {
                        heightmap[y2][x] = (heightmap[y2][x] - this.heightOffset) * this.heightScale;
                    }
                    ++x;
                }
                ++y2;
            }
        }
        return heightmap;
    }

    @Deprecated
    protected float[][] fromBoundsSingle() throws IOException {
        int x;
        double width = this.bounds.getWidthKm();
        double height = this.bounds.getHeightKm();
        log.info("The relief map will be generated for an area of {}x{}km, with the center at ({}). The virtual zero height {} and all elevations are scaled {}.", MathExt.roundf(width), MathExt.roundf(height), this.bounds.getCenter().toString(), this.heightOffset == 32767.0f ? "will be set to the highest possible value" : "is set to " + this.heightOffset, (double)this.heightScale != 1.0 ? "by factor " + MathExt.roundf(this.heightScale) : "1:1");
        double widthToHeight = width / height;
        int validWidth = widthToHeight >= 1.0 ? 2049 : (int)Math.round(2049.0 * widthToHeight);
        int validHeight = widthToHeight <= 1.0 ? 2049 : (int)Math.round(2049.0 / widthToHeight);
        int minX = (2049 - validWidth) / 2;
        int maxX = validWidth + minX;
        int minY = (2049 - validHeight) / 2;
        int maxY = validHeight + minY;
        log.debug("Retrieving SRTM data.");
        short[][] srtm = this.retrieveSRTMdata(this.bounds);
        float[][] srtmClean = new float[srtm.length][srtm.length];
        int y = 0;
        while (y < srtm.length) {
            int x2 = 0;
            while (x2 < srtm.length) {
                float val = srtm[this.srtmMaxIndex - y][x2];
                if (val == (float)gap) {
                    val = gip.star(srtm, x2, this.srtmMaxIndex - y);
                }
                srtmClean[y][x2] = val;
                ++x2;
            }
            ++y;
        }
        float minLon = Interpolation.getSigFig((float)this.bounds.getMinLon()) * 1200.0f;
        float minLat = Interpolation.getSigFig((float)this.bounds.getMinLat()) * 1200.0f;
        float maxLon = Interpolation.getSigFig((float)this.bounds.getMaxLon()) * 1200.0f;
        float maxLat = Interpolation.getSigFig((float)this.bounds.getMaxLat()) * 1200.0f;
        Bicubic it = new Bicubic(srtmClean);
        log.debug("SRTM data will be cropped and scaled to correct size using bicubic interpolation");
        float[][] scaled = it.cropAndResize(validWidth, 2049, minLon, minLat, maxLon, maxLat);
        log.debug("Final conversion and filtering of scaled SRTM data");
        float[][] heightmap = new float[2049][2049];
        int y2 = 0;
        while (y2 < scaled.length) {
            x = 0;
            while (x < scaled.length) {
                if (x >= minX && x < maxX && y2 >= minY && y2 < maxY) {
                    float val = scaled[y2 - minY][x - minX];
                    if (this.heightOffsetAuto && val > 0.0f && val < this.heightOffset) {
                        this.heightOffset = val;
                    }
                    heightmap[y2][x] = val;
                }
                ++x;
            }
            ++y2;
        }
        if (this.heightOffsetAuto) {
            log.debug("The virtual zero height has been set to {}", (Object)Float.valueOf(this.heightOffset));
        }
        y2 = 0;
        while (y2 < heightmap.length) {
            x = 0;
            while (x < heightmap.length) {
                heightmap[y2][x] = (heightmap[y2][x] - this.heightOffset) * this.heightScale;
                ++x;
            }
            ++y2;
        }
        return heightmap;
    }

    protected float getValue(short[][] srtm, int x, int y) {
        if (srtm[this.srtmMaxIndex - y][x] < -50) {
            return 0.0f;
        }
        return ((float)srtm[this.srtmMaxIndex - y][x] - this.heightOffset) * this.heightScale;
    }

    protected short[][] retrieveSRTMdata(Area ar) throws SocketTimeoutException, IOException, UnknownHostException {
        TileDownload td = new TileDownload();
        File[][] files = td.getTiles(ar);
        if (files.length == 1 && files[0].length == 1) {
            byte[] rawTile = SRTM.readArchiveSRTM(files[0][0]);
            return this.getNativeSRTM(rawTile);
        }
        short[][][][] source = this.unpackSRTMTiles(files);
        return Arrays2D.combine(source, 1, true);
    }

    protected short[][][][] unpackSRTMTiles(File[][] files) throws IOException {
        short[][][][] unpacked = new short[files.length][files[0].length][this.srtmLength][this.srtmLength];
        int y = 0;
        while (y < files.length) {
            int x = 0;
            while (x < files[y].length) {
                byte[] rawTile = SRTM.readArchiveSRTM(files[files.length - 1 - y][x]);
                short[][] srtm = this.getNativeSRTM(rawTile);
                unpacked[y][x] = srtm;
                ++x;
            }
            ++y;
        }
        return unpacked;
    }

    protected short[][] getNativeSRTM(File input) throws IOException {
        byte[] raw = Files.toByteArray(input);
        return this.getNativeSRTM(raw);
    }

    protected short[][] getNativeSRTM(byte[] input) throws IOException {
        if (input == null || input.length == 0) {
            return this.getEmptySRTMTile();
        }
        ByteArrayDataInput badi = ByteStreams.newDataInput(input);
        short[][] srtm = new short[this.srtmLength][this.srtmLength];
        int y = 0;
        while (y < this.srtmLength) {
            int x = 0;
            while (x < this.srtmLength) {
                srtm[y][x] = badi.readShort();
                ++x;
            }
            ++y;
        }
        return srtm;
    }

    protected static byte[] readArchiveSRTM(File zipFile) throws IOException {
        if (zipFile == null || !zipFile.exists()) {
            return null;
        }
        return Compression.readFirstZipEntry(zipFile);
    }

    protected short[][] getEmptySRTMTile() {
        short[][] srtm = new short[this.srtmLength][this.srtmLength];
        int y = 0;
        while (y < this.srtmLength) {
            int x = 0;
            while (x < this.srtmLength) {
                srtm[y][x] = 0;
                ++x;
            }
            ++y;
        }
        return srtm;
    }
}

