/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map.relief;

import de.nx42.maps4cim.map.ReliefMap;

public class MandelbrotRelief
extends ReliefMap {
    protected int iterations = 32;
    protected float zeroValue = -25.0f;
    protected float scale = 100.0f;

    public MandelbrotRelief() {
    }

    public MandelbrotRelief(int iterations, float zeroValue, float scale) {
        this.iterations = iterations;
        this.zeroValue = zeroValue;
        this.scale = scale;
    }

    @Override
    public float[][] generateRelief() {
        return this.mandelArray();
    }

    protected float[][] mandelArray() {
        float[][] mandel = new float[2049][2049];
        int y = 0;
        while (y < 2049) {
            float[] line = mandel[y];
            int x = 0;
            while (x < 2049) {
                double dx = 2.5 * (double)x / 2049.0 - 2.0;
                double dy = 1.25 - 2.5 * (double)y / 2049.0;
                int value = this.mandel(dx, dy);
                line[x] = value == 0 ? this.zeroValue : this.scale * (float)value / (float)this.iterations;
                ++x;
            }
            ++y;
        }
        return mandel;
    }

    protected int mandel(double px, double py) {
        int value = 0;
        double zx = 0.0;
        double zy = 0.0;
        double zx2 = 0.0;
        double zy2 = 0.0;
        while (value < this.iterations && zx2 + zy2 < 4.0) {
            zy = 2.0 * zx * zy + py;
            zx = zx2 - zy2 + px;
            zx2 = zx * zx;
            zy2 = zy * zy;
            ++value;
        }
        return this.iterations - value;
    }
}

