/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map;

import com.google.common.io.LittleEndianDataOutputStream;
import de.nx42.maps4cim.map.ex.MapGeneratorException;
import de.nx42.maps4cim.map.ex.TextureProcessingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TextureMap {
    private static Logger log = LoggerFactory.getLogger(TextureMap.class);
    protected static final int edgeLength = 2048;
    protected static final int byteAmount = 0x1000000;

    public abstract int[][] generateTexture() throws TextureProcessingException;

    public void writeTo(OutputStream out) throws MapGeneratorException, IOException {
        int[][] textureMap = this.generateTexture();
        log.debug("Storing texture map in native CiM2-Map format");
        this.storeByteStream(out, textureMap);
        log.debug("Texture map was written to file");
    }

    protected void storeByteStream(OutputStream out, int[][] textureMap) throws MapGeneratorException, IOException {
        ByteArrayOutputStream bos;
        if (TextureMap.isValidSize(textureMap)) {
            bos = new ByteArrayOutputStream(0x1000000);
            LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream(bos);
            int y = 0;
            while (y < 2048) {
                int x = 0;
                while (x < 2048) {
                    dos.writeInt(textureMap[x][y]);
                    ++x;
                }
                ++y;
            }
        } else {
            throw new MapGeneratorException("The size of the texture map is invalid. Only Maps with 2048 * 2048 blocks are allowed");
        }
        bos.writeTo(out);
    }

    protected static boolean isValidSize(int[][] textureMap) {
        int lenY = textureMap.length;
        int lenX = textureMap[0].length;
        if (lenX == 2048 && lenY == 2048) {
            int[][] nArray = textureMap;
            int n = textureMap.length;
            int n2 = 0;
            while (n2 < n) {
                int[] fs = nArray[n2];
                if (fs.length != 2048) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }
}

