/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map;

import com.google.common.io.LittleEndianDataOutputStream;
import de.nx42.maps4cim.map.ex.MapGeneratorException;
import de.nx42.maps4cim.map.ex.ReliefProcessingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReliefMap {
    private static Logger log = LoggerFactory.getLogger(ReliefMap.class);
    protected static final int edgeLength = 2049;
    protected static final int byteAmount = 0x1004004;
    protected static final int minVal = -1048575;
    protected static final int maxVal = 0x100000;
    protected static final float minValF = -1048.575f;
    protected static final float maxValF = 1048.576f;

    public abstract float[][] generateRelief() throws ReliefProcessingException;

    public void writeTo(OutputStream out) throws MapGeneratorException, IOException {
        float[][] reliefMap = this.generateRelief();
        log.debug("Storing relief in native CiM2-Map format");
        this.storeByteStream(out, reliefMap);
        log.debug("Relief was written to file");
    }

    protected void storeByteStream(OutputStream out, float[][] reliefMap) throws MapGeneratorException, IOException {
        ByteArrayOutputStream bos;
        if (ReliefMap.isValidSize(reliefMap)) {
            bos = new ByteArrayOutputStream(0x1004004);
            LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream(bos);
            int y = 0;
            while (y < 2049) {
                int x = 0;
                while (x < 2049) {
                    dos.writeInt((int)(reliefMap[y][x] * 1000.0f));
                    ++x;
                }
                ++y;
            }
        } else {
            throw new MapGeneratorException("The size of the relief map is invalid. Only Maps with 2049 * 2049 nodes are allowed");
        }
        bos.writeTo(out);
    }

    protected static boolean isValidSize(float[][] reliefMap) {
        int lenY = reliefMap.length;
        int lenX = reliefMap[0].length;
        if (lenX == 2049 && lenY == 2049) {
            float[][] fArray = reliefMap;
            int n = reliefMap.length;
            int n2 = 0;
            while (n2 < n) {
                float[] fs = fArray[n2];
                if (fs.length != 2049) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }
}

