/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.map;

import de.nx42.maps4cim.ResourceLoader;
import java.io.File;

public class Cache {
    protected static final File cacheDir = new File(ResourceLoader.appdata, "cache");
    protected static final File tempDir = new File(ResourceLoader.appdata, "temp");

    public Cache() {
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
    }

    public boolean has(String entry) {
        File f = new File(cacheDir, entry);
        return f.isFile();
    }

    public File get(String entry) {
        File f = new File(cacheDir, entry);
        if (f.isFile()) {
            return f;
        }
        throw new RuntimeException(String.format("The file %s could not be found in the cache", entry));
    }

    public File getUnchecked(String entry) {
        return new File(cacheDir, entry);
    }

    public File allocate(String entry) {
        File f = new File(cacheDir, entry);
        if (f.exists()) {
            throw new RuntimeException(String.format("The file %s does already exist in the cache!", entry));
        }
        return f;
    }

    public File getCacheDir() {
        return cacheDir;
    }

    public static File temporaray(String entry) {
        return new File(tempDir, entry);
    }

    public static void clearTemp() {
        Cache.deleteFolder(tempDir);
    }

    public static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    Cache.deleteFolder(f);
                } else {
                    f.delete();
                }
                ++n2;
            }
        }
        folder.delete();
    }
}

