/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.gui.action;

import de.nx42.maps4cim.util.gis.Area;
import de.nx42.maps4cim.util.gis.Coordinate;
import de.nx42.maps4cim.util.gis.UnitOfLength;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class SelectionAdapter
extends MouseAdapter {
    protected JXMapViewer jxm;
    Point2D cursor = null;
    protected double extent = 8.0;
    Area ar = null;

    public SelectionAdapter(JXMapViewer jxm) {
        this.jxm = jxm;
    }

    public void updateExtent(double extent) {
        if (extent != this.extent) {
            this.extent = extent;
            if (this.cursor != null && extent > 0.0 && extent < 2000.0) {
                this.updateArea(this.cursor.getX(), this.cursor.getY());
            }
        }
    }

    public void updateCenter(double lat, double lon) {
        double fixLat;
        double d = lat > 90.0 ? 90.0 : (fixLat = lat < -90.0 ? -90.0 : lat);
        double fixLon = lon > 180.0 ? 180.0 : (lon < -180.0 ? -180.0 : lon);
        Point2D p = this.geoToPoint(fixLat, fixLon);
        this.updateArea(p.getX(), p.getY());
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isRightMouseButton(evt)) {
            return;
        }
        this.updateArea(evt.getX(), evt.getY());
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isRightMouseButton(evt)) {
            return;
        }
        this.updateArea(evt.getX(), evt.getY());
    }

    protected void updateArea(double x, double y) {
        this.cursor = new Point2D.Double(x, y);
        GeoPosition gps = this.jxm.convertPointToGeoPosition(this.cursor);
        this.ar = new Area(new Coordinate(gps.getLatitude(), gps.getLongitude()), this.extent, UnitOfLength.KILOMETER);
        this.jxm.repaint();
    }

    public Rectangle getRectangle() {
        if (this.ar != null) {
            Point2D p1 = this.geoToPoint(this.ar.getMinLat(), this.ar.getMinLon());
            Point2D p2 = this.geoToPoint(this.ar.getMaxLat(), this.ar.getMaxLon());
            int x1 = (int)Math.min(p1.getX(), p2.getX());
            int y1 = (int)Math.min(p1.getY(), p2.getY());
            int x2 = (int)Math.max(p1.getX(), p2.getX());
            int y2 = (int)Math.max(p1.getY(), p2.getY());
            return new Rectangle(x1, y1, x2 - x1, y2 - y1);
        }
        return null;
    }

    public Collection<Line2D> getLines() {
        if (this.ar != null) {
            Point2D p1 = this.geoToPoint(this.ar.getMinLat(), this.ar.getMinLon());
            Point2D p2 = this.geoToPoint(this.ar.getMaxLat(), this.ar.getMaxLon());
            int x1 = (int)Math.min(p1.getX(), p2.getX());
            int y1 = (int)Math.min(p1.getY(), p2.getY());
            int x2 = (int)Math.max(p1.getX(), p2.getX());
            int y2 = (int)Math.max(p1.getY(), p2.getY());
            LinkedList<Line2D> lines = new LinkedList<Line2D>();
            lines.add(new Line2D.Double(x1, y1, x2, y2));
            lines.add(new Line2D.Double(x1, y2, x2, y1));
            return lines;
        }
        return null;
    }

    protected Point2D geoToPoint(double lat, double lon) {
        return this.jxm.convertGeoPositionToPoint(new GeoPosition(lat, lon));
    }
}

