/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.gui;

import de.nx42.maps4cim.Launcher;
import de.nx42.maps4cim.ResourceLoader;
import de.nx42.maps4cim.config.Config;
import de.nx42.maps4cim.util.xml.Serializer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderWindow
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(RenderWindow.class);
    private static final long serialVersionUID = -1913557466280155872L;
    private JPanel contentPane;
    private JButton btnDone;
    private JButton btnSaveLog;
    private JTextPane logView;
    private JProgressBar progressBar;
    private boolean working = false;
    protected ActionListener btnDoneAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RenderWindow.this.mapGenerator != null && RenderWindow.this.mapGenerator.isAlive()) {
                RenderWindow.this.mapGenerator.interrupt();
                if (RenderWindow.this.mapGenerator.isAlive()) {
                    RenderWindow.this.mapGenerator.stop();
                }
                RenderWindow.this.mapGenerator = null;
            }
            if (RenderWindow.this.working) {
                log.warn("Operation aborted by user request.");
                RenderWindow.this.finishWork(false);
            } else {
                RenderWindow.this.dispose();
            }
        }
    };
    protected ActionListener btnSaveLogAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            StyledDocument doc = RenderWindow.this.logView.getStyledDocument();
            try {
                String eventlog = doc.getText(0, doc.getLength());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection strSel = new StringSelection(eventlog);
                clipboard.setContents(strSel, null);
                log.debug("the log has been copied to clipboard");
            }
            catch (BadLocationException e1) {
                log.error("Could not copy log to clipboard", (Object)e);
            }
        }
    };
    Thread mapGenerator;
    private Config config = null;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    RenderWindow frame = new RenderWindow();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public RenderWindow() {
        super("Render View");
        this.setDefaultCloseOperation(2);
        this.setBounds(115, 115, 500, 400);
        this.setMinimumSize(new Dimension(400, 180));
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.progressBar = new JProgressBar(0, 100);
        this.btnDone = new JButton("Abort");
        this.btnDone.addActionListener(this.btnDoneAction);
        this.logView = new JTextPane();
        this.logView.setFont(UIManager.getFont("Button.font"));
        this.logView.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.logView);
        scrollPane.setBorder(null);
        this.btnSaveLog = new JButton("Copy to clipboard");
        this.btnSaveLog.addActionListener(this.btnSaveLogAction);
        GroupLayout gl_contentPane = new GroupLayout(this.contentPane);
        gl_contentPane.setHorizontalGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_contentPane.createSequentialGroup().addContainerGap().addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(scrollPane, GroupLayout.Alignment.LEADING, -1, 454, Short.MAX_VALUE).addComponent(this.progressBar, -1, 454, Short.MAX_VALUE).addGroup(gl_contentPane.createSequentialGroup().addComponent(this.btnSaveLog).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDone, -2, 80, -2))).addContainerGap()));
        gl_contentPane.setVerticalGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_contentPane.createSequentialGroup().addContainerGap().addComponent(scrollPane, -1, 259, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.progressBar, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnDone).addComponent(this.btnSaveLog)).addContainerGap()));
        this.contentPane.setLayout(gl_contentPane);
        this.addLogAppender();
    }

    public void runMapGenerator(final Config conf, final File dest) {
        this.config = conf;
        if (this.mapGenerator != null) {
            this.mapGenerator.interrupt();
        }
        this.mapGenerator = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean success = Launcher.runMapGenerator(conf, dest);
                RenderWindow.this.mapGeneratorFinished(success);
            }
        });
        this.mapGenerator.start();
        this.startWork();
    }

    protected void mapGeneratorFinished() {
        this.mapGeneratorFinished(true);
    }

    protected void mapGeneratorFinished(final boolean success) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RenderWindow.this.finishWork(success);
            }
        });
        this.autoSaveConfig();
    }

    protected void startWork() {
        this.working = true;
        this.progressBar.setValue(0);
        this.progressBar.setIndeterminate(true);
    }

    protected void finishWork(boolean success) {
        this.working = false;
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(success ? 100 : 0);
        this.btnDone.setText("Done");
    }

    protected void autoSaveConfig() {
        File serialized = new File(ResourceLoader.getAppDir(), "config-last.xml");
        try {
            Serializer.serialize(Config.class, this.config, serialized);
        }
        catch (JAXBException e) {
            log.error("Could not auto-save config in appdata", e);
        }
    }

    protected void addLogAppender() {
        TextAreaAppender tap = new TextAreaAppender(this.logView);
        org.apache.log4j.Logger.getRootLogger().addAppender(tap);
    }

    public class TextAreaAppender
    extends WriterAppender {
        private final JTextPane tp;
        private final StyledDocument doc;

        public TextAreaAppender(JTextPane tp) {
            this.tp = tp;
            this.doc = tp.getStyledDocument();
            this.layout = new PatternLayout("%d{HH:mm:ss,SS} - %p: %m%n");
        }

        @Override
        public void append(LoggingEvent loggingEvent) {
            final String message = this.layout.format(loggingEvent);
            final Level level = loggingEvent.getLevel();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextAreaAppender.this.append(message, level);
                }
            });
        }

        protected void append(String msg, Level lvl) {
            Color color = Color.LIGHT_GRAY;
            int level = lvl.toInt();
            if (level <= 10000) {
                color = Color.GRAY;
            } else if (level == 20000) {
                color = Color.BLACK;
            } else if (level == 30000) {
                color = new Color(255, 102, 0);
            } else if (level >= 40000) {
                color = Color.RED;
            }
            this.append(msg, color);
        }

        protected void append(String msg, Color c) {
            SimpleAttributeSet keyWord = new SimpleAttributeSet();
            StyleConstants.setForeground(keyWord, c);
            try {
                this.doc.insertString(this.doc.getLength(), msg, keyWord);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

