/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.gui;

import de.nx42.maps4cim.gui.action.SelectionAdapter;
import de.nx42.maps4cim.gui.action.SelectionPainter;
import de.nx42.maps4cim.map.Cache;
import java.io.File;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.OSMTileFactoryInfo;
import org.jdesktop.swingx.input.CenterMapListener;
import org.jdesktop.swingx.input.PanKeyListener;
import org.jdesktop.swingx.input.PanMouseInputListener;
import org.jdesktop.swingx.input.ZoomMouseWheelListenerCursor;
import org.jdesktop.swingx.mapviewer.DefaultTileFactory;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.LocalResponseCache;
import org.jdesktop.swingx.mapviewer.TileFactory;

public class MapViewerFactory {
    private JXMapViewer jxm;
    private SelectionAdapter selection;

    public MapViewerFactory() {
        TileFactory tf = this.getCachedTileFactory();
        this.jxm = this.getMapViewer(tf);
        this.addActionListeners(this.jxm);
        this.addSelectionPainters(this.jxm);
    }

    public JXMapViewer getMapViewer() {
        return this.jxm;
    }

    public SelectionAdapter getSelectionAdapter() {
        return this.selection;
    }

    public void setLocation(GeoPosition gps) {
        this.jxm.setAddressLocation(gps);
    }

    public static JXMapViewer build() {
        MapViewerFactory mvf = new MapViewerFactory();
        return mvf.getMapViewer();
    }

    public static JXMapViewer build(GeoPosition gps) {
        MapViewerFactory mvf = new MapViewerFactory();
        mvf.setLocation(gps);
        return mvf.getMapViewer();
    }

    protected TileFactory getCachedTileFactory() {
        OSMTileFactoryInfo info = new OSMTileFactoryInfo();
        DefaultTileFactory tileFactory = new DefaultTileFactory(info);
        tileFactory.setThreadPoolSize(8);
        File cache = new Cache().getCacheDir();
        LocalResponseCache.installResponseCache(info.getBaseURL(), cache, false);
        return tileFactory;
    }

    protected JXMapViewer getMapViewer(TileFactory tf) {
        GeoPosition freising = new GeoPosition(48.401, 11.744);
        return this.getMapViewer(tf, freising);
    }

    protected JXMapViewer getMapViewer(TileFactory tf, GeoPosition gps) {
        JXMapViewer jxm = new JXMapViewer();
        jxm.setTileFactory(tf);
        jxm.setZoom(10);
        jxm.setAddressLocation(gps);
        return jxm;
    }

    protected void addActionListeners(JXMapViewer jxm) {
        PanMouseInputListener mia = new PanMouseInputListener(jxm);
        jxm.addMouseListener(mia);
        jxm.addMouseMotionListener(mia);
        jxm.addMouseListener(new CenterMapListener(jxm));
        jxm.addMouseWheelListener(new ZoomMouseWheelListenerCursor(jxm));
        jxm.addKeyListener(new PanKeyListener(jxm));
    }

    protected void addSelectionPainters(JXMapViewer jxm) {
        SelectionAdapter sa = new SelectionAdapter(jxm);
        SelectionPainter sp = new SelectionPainter(sa);
        jxm.addMouseListener(sa);
        jxm.addMouseMotionListener(sa);
        jxm.setOverlayPainter(sp);
        this.selection = sa;
    }
}

