/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.gui;

import de.nx42.maps4cim.Launcher;
import de.nx42.maps4cim.ResourceLoader;
import de.nx42.maps4cim.config.Config;
import de.nx42.maps4cim.config.ReliefDef;
import de.nx42.maps4cim.config.bounds.CenterDef;
import de.nx42.maps4cim.gui.AboutWindow;
import de.nx42.maps4cim.gui.ConfigPresets;
import de.nx42.maps4cim.gui.MapViewerFactory;
import de.nx42.maps4cim.gui.RenderWindow;
import de.nx42.maps4cim.gui.action.CenterOnClickListener;
import de.nx42.maps4cim.gui.action.SelectionAdapter;
import de.nx42.maps4cim.util.gis.Area;
import de.nx42.maps4cim.util.gis.Coordinate;
import de.nx42.maps4cim.util.xml.Serializer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.bind.JAXBException;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainWindow
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(MainWindow.class);
    private static final long serialVersionUID = -5741327205041428356L;
    private JTabbedPane tabs;
    private JTextField inputLat;
    private JTextField inputLon;
    private JSlider sliderExt;
    private JTextField inputExtent;
    private JButton btnResetExtent;
    private JCheckBox chckbxHeightOffsetAuto;
    private JTextField inputHeightOffset;
    private JTextField inputHeightScale;
    private JComboBox comboTextureDetail;
    private JEditorPane xmlEditor;
    private JCheckBox chckbxReliefEnabled;
    private JCheckBox chckbxTextureEnabled;
    private final JXMapViewer jxm;
    private boolean reliefEnabled = true;
    private boolean textureEnabled = true;
    private boolean heightOffsetAuto = true;
    protected Config config = null;
    protected SelectionAdapter selection;
    protected Tab currentTab = Tab.Settings;
    protected ActionListener menuExitAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.exit();
        }
    };
    protected ActionListener menuSaveAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.safeConfig();
        }
    };
    protected ActionListener menuOpenAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.openConfig();
        }
    };
    protected ActionListener menuAboutAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutWindow aw = new AboutWindow();
            aw.setVisible(true);
        }
    };
    protected ActionListener btnRenderAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainWindow.this.validateInput()) {
                MainWindow.this.updateConfig();
                MainWindow.this.openRenderWindow(MainWindow.this.config);
            }
        }
    };
    protected ChangeListener extSliderChange = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            String inputVal;
            String sliderVal = String.valueOf(MainWindow.this.sliderExt.getValue());
            if (!sliderVal.equals(inputVal = MainWindow.this.inputExtent.getText())) {
                MainWindow.this.inputExtent.setText(sliderVal);
            }
        }
    };
    protected ActionListener btnResetExtentAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!MainWindow.this.inputExtent.getText().equals("8.0")) {
                MainWindow.this.inputExtent.setText("8.0");
            }
        }
    };
    protected ActionListener heightOffsetCheckBoxAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.heightOffsetAuto = MainWindow.this.chckbxHeightOffsetAuto.isSelected();
            MainWindow.this.inputHeightOffset.setEnabled(!MainWindow.this.heightOffsetAuto);
        }
    };
    protected ActionListener chckbxReliefEnabledAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.reliefEnabled = MainWindow.this.chckbxReliefEnabled.isSelected();
            MainWindow.this.inputHeightOffset.setEnabled(MainWindow.this.reliefEnabled);
            MainWindow.this.inputHeightScale.setEnabled(MainWindow.this.reliefEnabled);
            MainWindow.this.chckbxHeightOffsetAuto.setEnabled(MainWindow.this.reliefEnabled);
            if (MainWindow.this.reliefEnabled) {
                MainWindow.this.inputHeightOffset.setEnabled(!MainWindow.this.heightOffsetAuto);
            }
        }
    };
    protected ActionListener chckbxTextureEnabledAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.textureEnabled = MainWindow.this.chckbxTextureEnabled.isSelected();
            MainWindow.this.comboTextureDetail.setEnabled(MainWindow.this.textureEnabled);
        }
    };
    protected DocumentListener inputExtentListener = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            String input = MainWindow.this.inputExtent.getText();
            try {
                final int val = (int)Math.round(Double.parseDouble(input));
                if (val != MainWindow.this.sliderExt.getValue()) {
                    if (val < 32) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MainWindow.this.sliderExt.setValue(val);
                            }
                        });
                    } else if (val > 32 && MainWindow.this.sliderExt.getValue() < 32) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MainWindow.this.sliderExt.setValue(32);
                                MainWindow.this.inputExtent.setText(String.valueOf(val));
                            }
                        });
                    }
                }
                MainWindow.this.selection.updateExtent(val);
            }
            catch (NumberFormatException ex) {
                log.debug("Cannot parse \"{}\" as decimal number", (Object)input);
            }
        }
    };
    protected DocumentListener latUpdate = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            MainWindow.this.updateCenter();
        }
    };
    protected DocumentListener lonUpdate = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            MainWindow.this.updateCenter();
        }
    };
    private boolean invalidate = false;
    protected ComponentAdapter xmlTabOpened = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent e) {
            if (MainWindow.this.invalidate) {
                MainWindow.this.invalidate = false;
                return;
            }
            if (MainWindow.this.validateFormInput()) {
                MainWindow.this.updateConfig();
                MainWindow.this.updateViewXml();
                MainWindow.this.currentTab = Tab.XML;
            } else {
                MainWindow.this.invalidate = true;
                MainWindow.this.tabs.setSelectedIndex(Tab.Settings.index);
            }
        }
    };
    protected ComponentAdapter formTabOpened = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent e) {
            if (MainWindow.this.invalidate) {
                MainWindow.this.invalidate = false;
                return;
            }
            if (MainWindow.this.validateXmlInput()) {
                MainWindow.this.updateConfig();
                MainWindow.this.updateViewForm();
                MainWindow.this.currentTab = Tab.Settings;
            } else {
                MainWindow.this.invalidate = true;
                MainWindow.this.tabs.setSelectedIndex(Tab.XML.index);
            }
        }
    };
    private JFileChooser saveConfig;
    private JFileChooser loadConfig;
    private JFileChooser saveMap;
    protected static final DecimalFormat df = MainWindow.getDecimalFormat(4);

    public static void main(String[] args) {
        Launcher.initLogger();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MainWindow frame = new MainWindow();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    log.error("Uncaught exeption", e);
                }
            }
        });
    }

    public MainWindow() {
        super("maps4cim - a real-world map generator for CiM 2");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            log.error("Could not set look and feel to preferred value...");
        }
        this.setDefaultCloseOperation(3);
        this.setSize();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        menuBar.add(mnFile);
        JMenuItem mntmOpenConfiguration = new JMenuItem("Open Configuration...");
        mntmOpenConfiguration.addActionListener(this.menuOpenAction);
        mnFile.add(mntmOpenConfiguration);
        JMenuItem mntmSaveConfiguration = new JMenuItem("Save Configuration...");
        mntmSaveConfiguration.addActionListener(this.menuSaveAction);
        mnFile.add(mntmSaveConfiguration);
        JSeparator separator = new JSeparator();
        mnFile.add(separator);
        JMenuItem mntmExit = new JMenuItem("Exit");
        mntmExit.addActionListener(this.menuExitAction);
        mnFile.add(mntmExit);
        JMenu mnHelp = new JMenu("Help");
        menuBar.add(mnHelp);
        JMenuItem mntmAbout = new JMenuItem("About");
        mntmAbout.addActionListener(this.menuAboutAction);
        mnHelp.add(mntmAbout);
        this.getContentPane().setLayout(new GridLayout(1, 0, 0, 0));
        JPanel wrapper = new JPanel();
        this.getContentPane().add(wrapper);
        MapViewerFactory fact = new MapViewerFactory();
        this.jxm = fact.getMapViewer();
        this.selection = fact.getSelectionAdapter();
        this.jxm.addMouseListener(new CenterOnClickListener(this, this.jxm));
        JXMapViewer map = this.jxm;
        this.tabs = new JTabbedPane(1);
        JButton btnRender = new JButton("Render");
        btnRender.addActionListener(this.btnRenderAction);
        GroupLayout gl_wrapper = new GroupLayout(wrapper);
        gl_wrapper.setHorizontalGroup(gl_wrapper.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_wrapper.createSequentialGroup().addComponent(map, -1, 664, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gl_wrapper.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(btnRender, -1, -1, Short.MAX_VALUE).addComponent(this.tabs, -1, 260, Short.MAX_VALUE)).addContainerGap()));
        gl_wrapper.setVerticalGroup(gl_wrapper.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_wrapper.createSequentialGroup().addContainerGap().addComponent(this.tabs, -1, 531, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnRender).addContainerGap()).addComponent(map, GroupLayout.Alignment.LEADING, -1, 589, Short.MAX_VALUE));
        JPanel tabSettings = new JPanel();
        tabSettings.setBorder(null);
        JScrollPane tabSettingsScroller = new JScrollPane(tabSettings);
        tabSettingsScroller.setVerticalScrollBarPolicy(20);
        tabSettingsScroller.setHorizontalScrollBarPolicy(30);
        tabSettingsScroller.setBorder(null);
        this.tabs.addTab(Tab.Settings.name, null, tabSettingsScroller, null);
        this.sliderExt = new JSlider(0, 0, 32, 8);
        this.sliderExt.setToolTipText("select the extent of your map (best results are achieved by selecting 8km)");
        this.sliderExt.addChangeListener(this.extSliderChange);
        this.sliderExt.setSnapToTicks(true);
        this.sliderExt.setPaintLabels(true);
        this.sliderExt.setPaintTicks(true);
        this.sliderExt.setMinorTickSpacing(1);
        this.sliderExt.setMajorTickSpacing(4);
        JPanel center = new JPanel();
        FlowLayout fl_center = (FlowLayout)center.getLayout();
        fl_center.setAlignment(3);
        JLabel lblCenter = new JLabel("Center:");
        center.add(lblCenter);
        this.inputLat = new JTextField();
        this.inputLat.setToolTipText("latitude (decimal degrees)");
        this.inputLat.setText("48.0");
        this.inputLat.setColumns(6);
        this.inputLat.getDocument().addDocumentListener(this.latUpdate);
        center.add(this.inputLat);
        JPanel panel_relief = new JPanel();
        panel_relief.setBorder(new TitledBorder(null, "Relief", 4, 2, null, null));
        JPanel panel_texture = new JPanel();
        panel_texture.setBorder(new TitledBorder(null, "Texture", 4, 2, null, null));
        JPanel panel_hints = new JPanel();
        panel_hints.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Hints", 4, 2, null, null));
        JPanel extent = new JPanel();
        FlowLayout fl_extent = (FlowLayout)extent.getLayout();
        fl_extent.setAlignment(3);
        JLabel lblExtent = new JLabel("Extent:");
        extent.add(lblExtent);
        this.inputExtent = new JTextField();
        this.inputExtent.setToolTipText("The edge length of the map.");
        this.inputExtent.setHorizontalAlignment(11);
        this.inputExtent.setText("8");
        this.inputExtent.setColumns(4);
        this.inputExtent.getDocument().addDocumentListener(this.inputExtentListener);
        extent.add(this.inputExtent);
        JLabel lblKm = new JLabel("km");
        extent.add(lblKm);
        GroupLayout gl_tabSettings = new GroupLayout(tabSettings);
        gl_tabSettings.setHorizontalGroup(gl_tabSettings.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_tabSettings.createSequentialGroup().addContainerGap().addGroup(gl_tabSettings.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(panel_hints, GroupLayout.Alignment.LEADING, -1, 235, Short.MAX_VALUE).addComponent(this.sliderExt, GroupLayout.Alignment.LEADING, -1, 235, Short.MAX_VALUE).addComponent(center, GroupLayout.Alignment.LEADING, -1, 235, Short.MAX_VALUE).addComponent(extent, GroupLayout.Alignment.LEADING, -1, 235, Short.MAX_VALUE).addComponent(panel_relief, GroupLayout.Alignment.LEADING, -1, 235, Short.MAX_VALUE).addComponent(panel_texture, GroupLayout.Alignment.LEADING, -1, 235, Short.MAX_VALUE)).addContainerGap()));
        gl_tabSettings.setVerticalGroup(gl_tabSettings.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_tabSettings.createSequentialGroup().addContainerGap().addComponent(center, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sliderExt, -2, -1, -2).addComponent(extent, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(panel_relief, -2, 121, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(panel_texture, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(panel_hints, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)));
        this.btnResetExtent = new JButton("reset");
        this.btnResetExtent.setToolTipText("<html>Resets the extent of the map to the ingame size of 8x8 km.<br>Note that true to scale results can only be achieved for maps of 8km size.</html>");
        this.btnResetExtent.addActionListener(this.btnResetExtentAction);
        extent.add(this.btnResetExtent);
        JTextPane textPaneHints = new JTextPane();
        textPaneHints.setText("Use the right mouse button to define the center of your map.\nClick and hold the left mouse button on the map to drag your current view.\nUse the mouse wheel to scroll.\nAdjust your map settings using the form above or the XML tab.\nSwitch to the XML tab to review or to copy & share your current settings.\nHave fun :)");
        textPaneHints.setFont(new Font("Dialog", 0, 11));
        textPaneHints.setEditable(false);
        textPaneHints.setBackground(SystemColor.menu);
        GroupLayout gl_panel_hints = new GroupLayout(panel_hints);
        gl_panel_hints.setHorizontalGroup(gl_panel_hints.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(textPaneHints, -1, 223, Short.MAX_VALUE));
        gl_panel_hints.setVerticalGroup(gl_panel_hints.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(textPaneHints, -1, 213, Short.MAX_VALUE));
        panel_hints.setLayout(gl_panel_hints);
        this.chckbxTextureEnabled = new JCheckBox("Enabled");
        this.chckbxTextureEnabled.setSelected(true);
        this.chckbxTextureEnabled.addActionListener(this.chckbxTextureEnabledAction);
        JPanel panel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panel.getLayout();
        flowLayout.setAlignment(3);
        JLabel lblTextureDetail = new JLabel("Texture detail:");
        panel.add(lblTextureDetail);
        this.comboTextureDetail = new JComboBox();
        this.comboTextureDetail.setToolTipText("The amount of detail that shall be drawn on the ground.");
        this.comboTextureDetail.setModel(new DefaultComboBoxModel<TextureDetail>(TextureDetail.values()));
        this.comboTextureDetail.setSelectedIndex(TextureDetail.values().length - 1);
        panel.add(this.comboTextureDetail);
        GroupLayout gl_panel_texture = new GroupLayout(panel_texture);
        gl_panel_texture.setHorizontalGroup(gl_panel_texture.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_texture.createSequentialGroup().addContainerGap().addGroup(gl_panel_texture.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(panel, -1, 203, Short.MAX_VALUE).addComponent(this.chckbxTextureEnabled, -2, 63, -2)).addContainerGap()));
        gl_panel_texture.setVerticalGroup(gl_panel_texture.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_texture.createSequentialGroup().addComponent(this.chckbxTextureEnabled).addComponent(panel, -2, -1, -2)));
        panel_texture.setLayout(gl_panel_texture);
        JPanel heightOffset = new JPanel();
        FlowLayout fl_heightOffset = (FlowLayout)heightOffset.getLayout();
        fl_heightOffset.setAlignment(3);
        JLabel lblHeightOffset = new JLabel("Height offset:");
        heightOffset.add(lblHeightOffset);
        this.inputHeightOffset = new JTextField();
        this.inputHeightOffset.setToolTipText("custom height offset. The overall map height will be decreased by this value.");
        this.inputHeightOffset.setText("0");
        this.inputHeightOffset.setHorizontalAlignment(11);
        this.inputHeightOffset.setEnabled(false);
        heightOffset.add(this.inputHeightOffset);
        this.inputHeightOffset.setColumns(4);
        JLabel lblMeter = new JLabel("m");
        heightOffset.add(lblMeter);
        this.chckbxHeightOffsetAuto = new JCheckBox("auto");
        this.chckbxHeightOffsetAuto.setToolTipText("Automatic height offset. Sets the lowest point of the map as new virtual zero height. Highly recommended.");
        this.chckbxHeightOffsetAuto.addActionListener(this.heightOffsetCheckBoxAction);
        this.chckbxHeightOffsetAuto.setSelected(true);
        heightOffset.add(this.chckbxHeightOffsetAuto);
        this.chckbxReliefEnabled = new JCheckBox("Enabled");
        this.chckbxReliefEnabled.setSelected(true);
        this.chckbxReliefEnabled.addActionListener(this.chckbxReliefEnabledAction);
        JPanel heightScale = new JPanel();
        FlowLayout fl_heightScale = (FlowLayout)heightScale.getLayout();
        fl_heightScale.setAlignment(3);
        JLabel lblHeightScale = new JLabel("Height scale:");
        heightScale.add(lblHeightScale);
        this.inputHeightScale = new JTextField();
        this.inputHeightScale.setToolTipText("Scaling of height differences. For values below 100, hills will be flatter, for high values, hills will be exaggerated.");
        this.inputHeightScale.setHorizontalAlignment(11);
        this.inputHeightScale.setText("100");
        this.inputHeightScale.setColumns(4);
        heightScale.add(this.inputHeightScale);
        JLabel lblPercent = new JLabel("%");
        heightScale.add(lblPercent);
        GroupLayout gl_panel_relief = new GroupLayout(panel_relief);
        gl_panel_relief.setHorizontalGroup(gl_panel_relief.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_relief.createSequentialGroup().addContainerGap().addGroup(gl_panel_relief.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chckbxReliefEnabled).addComponent(heightOffset, -1, 203, Short.MAX_VALUE).addComponent(heightScale, -1, 203, Short.MAX_VALUE)).addContainerGap()));
        gl_panel_relief.setVerticalGroup(gl_panel_relief.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_relief.createSequentialGroup().addComponent(this.chckbxReliefEnabled).addComponent(heightOffset, -2, -1, -2).addComponent(heightScale, -2, -1, -2)));
        panel_relief.setLayout(gl_panel_relief);
        JLabel lblComma = new JLabel(",");
        center.add(lblComma);
        this.inputLon = new JTextField();
        this.inputLon.setToolTipText("longitude (decimal degrees)");
        this.inputLon.setText("11.0");
        this.inputLon.setColumns(6);
        this.inputLon.getDocument().addDocumentListener(this.lonUpdate);
        center.add(this.inputLon);
        tabSettings.setLayout(gl_tabSettings);
        JPanel tabXML = new JPanel();
        this.tabs.addTab(Tab.XML.name, null, tabXML, null);
        tabXML.setLayout(new BorderLayout(0, 0));
        this.xmlEditor = new JEditorPane();
        this.xmlEditor.setFont(new Font("Courier New", 0, 11));
        this.xmlEditor.setText("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        JScrollPane scrollPane = new JScrollPane(this.xmlEditor);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setBorder(null);
        tabXML.add((Component)scrollPane, "Center");
        wrapper.setLayout(gl_wrapper);
        tabSettingsScroller.addComponentListener(this.formTabOpened);
        tabXML.addComponentListener(this.xmlTabOpened);
        this.initFileChoosers();
        this.loadLastConfig();
    }

    protected void setSize() {
        int height;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)screen.getWidth();
        if (width / (height = (int)screen.getHeight()) > 2) {
            width = (int)((double)height * 1.8);
        } else if ((double)(width / height) < 0.7) {
            height = width;
            width = (int)((double)width * 1.5);
        }
        this.setBounds(100, 100, (int)((double)width * 0.5), (int)((double)height * 0.6));
        this.setMinimumSize(new Dimension(350, 200));
    }

    protected void updateView() {
        if (this.currentTab == Tab.Settings) {
            this.updateViewForm();
        } else {
            this.updateViewXml();
        }
    }

    protected void updateViewXml() {
        try {
            String xml = Serializer.serializeToString(Config.class, this.config);
            this.xmlEditor.setText(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void updateViewForm() {
        if (this.config.bounds instanceof CenterDef) {
            CenterDef bounds = (CenterDef)this.config.bounds;
            this.inputLat.setText(String.valueOf(bounds.centerLat));
            this.inputLon.setText(String.valueOf(bounds.centerLon));
            this.inputExtent.setText(String.valueOf(bounds.extent));
            this.comboTextureDetail.setSelectedItem((Object)TextureDetail.highestForExtent(bounds.extent));
        }
        boolean hoAuto = this.config.relief.isHeightOffsetAuto();
        this.setHeightOffsetState(hoAuto);
        if (!hoAuto) {
            this.inputHeightOffset.setText(this.config.relief.heightOffset);
        }
        double scalePercent = this.config.relief.heightScale == null ? 100.0 : this.config.relief.heightScale * 100.0;
        this.inputHeightScale.setText(String.valueOf((int)Math.round(scalePercent)));
    }

    protected void setHeightOffsetState(boolean auto) {
        this.chckbxHeightOffsetAuto.setSelected(auto);
        this.inputHeightOffset.setEnabled(!auto);
    }

    protected void updateCenter() {
        try {
            double lat = Double.parseDouble(this.inputLat.getText());
            double lon = Double.parseDouble(this.inputLon.getText());
            this.selection.updateCenter(lat, lon);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void exit() {
        this.dispose();
        System.exit(0);
    }

    protected void initFileChoosers() {
        FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("XML", "xml");
        FileNameExtensionFilter mapFilter = new FileNameExtensionFilter("CiM 2 Map", "map");
        this.saveConfig = MainWindow.setupFileChooser("Save configuration", 1, xmlFilter, new File("config.xml"));
        this.loadConfig = MainWindow.setupFileChooser("Load configuration", 0, xmlFilter, new File("config.xml"));
        this.saveMap = MainWindow.setupFileChooser("Save generated map", 1, mapFilter, new File("maps4cim.map"));
        if (System.getProperty("os.name").startsWith("Windows")) {
            File mapDir = new File(ResourceLoader.appdata.getParentFile().getParentFile(), "LocalLow/Colossal Order/Cities in Motion 2/Maps");
            this.saveMap = MainWindow.setupFileChooser("Save generated map", 1, mapFilter, new File(mapDir, "maps4cim.map"));
        } else {
            this.saveMap = MainWindow.setupFileChooser("Save generated map", 1, mapFilter, new File("maps4cim.map"));
        }
    }

    protected static JFileChooser setupFileChooser(String title, int type, FileFilter filter, File selected) {
        JFileChooser choose = new JFileChooser();
        choose.setDialogTitle(title);
        choose.setDialogType(type);
        choose.setFileFilter(filter);
        choose.setSelectedFile(selected);
        choose.setFileSelectionMode(0);
        choose.setMultiSelectionEnabled(false);
        return choose;
    }

    protected void safeConfig() {
        if (this.validateInput()) {
            this.updateConfig();
            if (this.saveConfig.showSaveDialog(this) == 0) {
                File f = this.saveConfig.getSelectedFile();
                try {
                    Serializer.serialize(Config.class, this.config, f);
                }
                catch (JAXBException e) {
                    log.error("Could not serialize config to file", e);
                    Throwable linked = e.getLinkedException();
                    this.errorPopup("Could not save the current configuration:<br>" + linked.getMessage());
                }
            }
        }
    }

    protected void openConfig() {
        if (this.loadConfig.showOpenDialog(this) == 0) {
            File f = this.loadConfig.getSelectedFile();
            try {
                this.config = Serializer.deserialize(Config.class, f, true);
                this.updateViewForm();
                this.updateViewXml();
            }
            catch (JAXBException e) {
                Throwable linked = e.getLinkedException();
                log.error("Could not open config", e);
                this.errorPopup("Could not open config:<br>" + linked.getMessage());
            }
            catch (Exception e) {
                log.error("Could not open config", e);
                this.errorPopup("Could not open config:<br>" + e.getMessage());
            }
        }
    }

    protected void openRenderWindow(final Config conf) {
        if (this.validateInput()) {
            this.updateConfig();
            if (this.saveMap.showSaveDialog(this) == 0) {
                final File file = this.saveMap.getSelectedFile();
                try {
                    file.createNewFile();
                    if (file.exists() && file.canWrite()) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    RenderWindow frame = new RenderWindow();
                                    frame.setVisible(true);
                                    frame.runMapGenerator(conf, file);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                }
                catch (IOException e) {
                    log.error("Cannot write the resulting map to the specified file", e);
                    this.errorPopup("Cannot write the resulting map to " + file.toString() + "<br>" + e.getMessage());
                }
            }
        }
    }

    protected static DecimalFormat getDecimalFormat(int fractionDigits) {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(fractionDigits);
        return (DecimalFormat)nf;
    }

    public void setCenter(final double lat, final double lon) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.inputLat.setText(df.format(lat));
                MainWindow.this.inputLon.setText(df.format(lon));
            }
        });
    }

    protected boolean validateInput() {
        if (this.currentTab == Tab.Settings) {
            return this.validateFormInput();
        }
        return this.validateXmlInput();
    }

    protected boolean validateFormInput() {
        try {
            double lat = this.parseText(this.inputLat, "latitude (center)");
            double lon = this.parseText(this.inputLon, "longitude (center)");
            double extent = this.parseText(this.inputExtent, "extent");
            double heightOffset = 0.0;
            double heightScale = 100.0;
            if (this.reliefEnabled) {
                if (!this.heightOffsetAuto) {
                    heightOffset = Math.abs(this.parseText(this.inputHeightOffset, "height offset"));
                }
                heightScale = this.parseText(this.inputHeightScale, "height scale");
            }
            TextureDetail td = TextureDetail.off;
            if (this.textureEnabled) {
                td = TextureDetail.byIndex(this.comboTextureDetail.getSelectedIndex());
            }
            return this.validateInput(lat, lon, extent, this.heightOffsetAuto, heightOffset, heightScale, td);
        }
        catch (Exception e) {
            log.error("An error occured while parsing form details", e);
            return false;
        }
    }

    protected boolean validateXmlInput() {
        try {
            Config conf = Serializer.deserializeFromString(Config.class, this.xmlEditor.getText());
            return this.validateInput(conf);
        }
        catch (JAXBException e) {
            log.error("The user defined XML seems to be invalid", e);
            Throwable linked = e.getLinkedException();
            this.errorPopup("Your XML seems to be invalid: " + linked.getMessage());
            return false;
        }
    }

    protected boolean validateInput(Config conf) {
        if (conf.bounds instanceof CenterDef) {
            CenterDef bounds = (CenterDef)conf.bounds;
            return this.validateInput(bounds.centerLat, bounds.centerLon, bounds.extent, conf.relief.isHeightOffsetAuto(), conf.relief.getHeightOffset(), conf.relief.heightScale, TextureDetail.off);
        }
        return true;
    }

    protected boolean validateInput(double lat, double lon, double extent, boolean hoAuto, double ho, double hs, TextureDetail td) {
        if (lat > 90.0 || lat < -90.0) {
            return this.errorPopup("Latitude", "must be between -90 and 90 degrees");
        }
        if (lon > 180.0 || lon < -180.0) {
            return this.errorPopup("Longitude", "must be between -180 and 180 degrees");
        }
        if (extent < 1.0) {
            return this.errorPopup("Extent", "the smallest allowed map size is 1 km.<br>Please note that only 8 km maps allow 1:1 scale of ingame objects");
        }
        if (extent > 250.0) {
            return this.errorPopup("Extent", "the largest allowed map size is 250 km.<br>Please note that only 8 km maps allow 1:1 scale of ingame objects");
        }
        if (!hoAuto && ho > 9000.0) {
            return this.errorPopup("Height offset", "You have entered a very high height offset value.<br>Please note that the height offset is measured in meters and that there is<br>no elevation on earth higher than 9000 m above sea level.<br><br>If you have no idea, what this message is about, please enable the checkbox labeled \"auto\"<br>next to the height offset and I will figure out the best value myself.");
        }
        if (hs < 0.0 || hs > 2000.0) {
            return this.errorPopup("Height scale", "the height scale must be between<br>0% (no elevation data) and 2.000% (which would already render pretty insane hills).<br>Why don't you leave it somewhere around 50 to 150% (which would be reasonable)?");
        }
        if (!td.isSizeAllowed(extent)) {
            TextureDetail tdAllowed = TextureDetail.highestForExtent(extent);
            return this.errorPopup("Texture Detail", String.format("I'm sorry, but your selected texture detail \"%s\"<br>is not available for a map of %s km. Decrease the texture detail to \"%s\"<br>or decrease the size of your map to %s km or less.<br><br>Please be aware that retrieving the data for high detail maps of this size<br>requires enormous server capacities. These limits were introduced for a good reason.", new Object[]{td, extent, tdAllowed, td.maxAllowedSize}));
        }
        return true;
    }

    protected void updateConfig() {
        if (this.currentTab == Tab.Settings) {
            this.config = this.getConfigFromForm();
        } else {
            try {
                this.config = this.getConfigFromXML();
            }
            catch (JAXBException e) {
                log.error("Unecpected exception while updating configuration", e);
            }
        }
    }

    protected Config getConfigFromForm() {
        ReliefDef relief;
        double lat = Double.parseDouble(this.inputLat.getText());
        double lon = Double.parseDouble(this.inputLon.getText());
        double extent = Double.parseDouble(this.inputExtent.getText());
        CenterDef bounds = CenterDef.of(lat, lon, extent, CenterDef.Unit.KM);
        if (this.reliefEnabled) {
            double heightOffset = 0.0;
            if (!this.heightOffsetAuto) {
                heightOffset = Math.abs(Double.parseDouble(this.inputHeightOffset.getText()));
            }
            double heightScale = Double.parseDouble(this.inputHeightScale.getText()) / 100.0;
            relief = ReliefDef.srtm(heightOffset, this.heightOffsetAuto, heightScale);
        } else {
            relief = ReliefDef.none();
        }
        TextureDetail td = this.textureEnabled ? TextureDetail.byIndex(this.comboTextureDetail.getSelectedIndex()) : TextureDetail.off;
        Config c = new Config();
        c.bounds = bounds;
        c.relief = relief;
        c.texture = ConfigPresets.get(td);
        return c;
    }

    protected Config getConfigFromXML() throws JAXBException {
        return Serializer.deserializeFromString(Config.class, this.xmlEditor.getText());
    }

    protected void loadLastConfig() {
        File last = new File(ResourceLoader.getAppDir(), "config-last.xml");
        if (last.exists()) {
            try {
                Config conf = Serializer.deserialize(Config.class, last, true);
                if (this.validateInput(conf)) {
                    this.config = conf;
                    this.updateViewForm();
                    this.updateViewXml();
                    this.updateCenterInMap(conf);
                    log.debug("The last used config has been successfully loaded");
                } else {
                    this.errorPopup("You got this message because your last used config was messed up<br>Loading a fresh config. Have fun!");
                    log.warn("Last used config contained errors...");
                }
            }
            catch (Exception e) {
                log.error("Could not open last used config", e);
            }
        }
    }

    protected void updateCenterInMap(final Config conf) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Area ar = Area.of(conf.bounds);
                Coordinate center = ar.getCenter();
                MainWindow.this.selection.updateCenter(center.getLatitude(), center.getLongitude());
                MainWindow.this.jxm.setCenterPosition(new GeoPosition(center.getLatitude(), center.getLongitude()));
            }
        });
    }

    public double getExtent() {
        try {
            return Double.parseDouble(this.inputExtent.getText());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    protected double parseText(JTextField field, String fieldName) {
        String value = field.getText();
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, String.format("<html><center>Your input \"%s\" from field %s is not a well-formatted decimal number.<br>Please enter something like 42 or 13.37</center></html>", value, fieldName), "Error", 0);
            throw e;
        }
    }

    protected boolean errorPopup(String field, String error) {
        JOptionPane.showMessageDialog(this, String.format("<html><center>%s has an invalid value: %s</center></html>", field, error), "Error", 0);
        return false;
    }

    protected void errorPopup(String message) {
        JOptionPane.showMessageDialog(this, String.format("<html><center>%s</center></html>", message), "Error", 0);
    }

    protected static enum Tab {
        Settings("Settings", 0),
        XML("XML", 1);

        public final String name;
        public final int index;

        private Tab(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static Tab byIndex(int index) {
            return Tab.values()[index];
        }
    }

    public static enum TextureDetail {
        off("off", Integer.MAX_VALUE),
        min("lowest (150)", 150),
        low("low (100)", 100),
        med("medium (60)", 60),
        high("high (35)", 35),
        vhigh("very high (20)", 20),
        ultra("ultra (10)", 10);

        public final double maxAllowedSize;
        public final String display;

        private TextureDetail(String s, int size) {
            this.display = s;
            this.maxAllowedSize = size;
        }

        public String toString() {
            return this.display;
        }

        public boolean isSizeAllowed(double size) {
            return size <= this.maxAllowedSize;
        }

        public static TextureDetail byIndex(int i) {
            return TextureDetail.values()[i];
        }

        public static TextureDetail highestForExtent(double extent) {
            TextureDetail[] values = TextureDetail.values();
            int i = values.length - 1;
            while (i >= 0) {
                if (values[i].isSizeAllowed(extent)) {
                    return values[i];
                }
                --i;
            }
            return off;
        }
    }
}

