/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.gui;

import de.nx42.maps4cim.config.TextureDef;
import de.nx42.maps4cim.config.texture.ColorDef;
import de.nx42.maps4cim.config.texture.EntityDef;
import de.nx42.maps4cim.config.texture.NodeDef;
import de.nx42.maps4cim.config.texture.PolygonDef;
import de.nx42.maps4cim.config.texture.WayDef;
import de.nx42.maps4cim.gui.MainWindow;
import java.util.LinkedList;
import java.util.List;

public class ConfigPresets {
    public static TextureDef get(MainWindow.TextureDetail td) {
        switch (td) {
            case off: {
                return new TextureDef(){
                    {
                        this.source = TextureDef.TextureSource.none;
                    }
                };
            }
            case min: {
                return ConfigPresets.getTextureConfig(ConfigPresets.getAllColors(), ConfigPresets.getEntitiesLowest());
            }
            case low: {
                return ConfigPresets.getTextureConfig(ConfigPresets.getAllColors(), ConfigPresets.getEntitiesLow());
            }
            case med: {
                return ConfigPresets.getTextureConfig(ConfigPresets.getAllColors(), ConfigPresets.getEntitiesMed());
            }
            case high: {
                return ConfigPresets.getTextureConfig(ConfigPresets.getAllColors(), ConfigPresets.getEntitiesHigh());
            }
            case vhigh: {
                return ConfigPresets.getTextureConfig(ConfigPresets.getAllColors(), ConfigPresets.getEntitiesVHigh());
            }
            case ultra: {
                return ConfigPresets.getTextureConfig(ConfigPresets.getAllColors(), ConfigPresets.getEntitiesUltra());
            }
        }
        return null;
    }

    protected static TextureDef getTextureConfig(List<ColorDef> aColors, List<EntityDef> aEntities) {
        return new TextureDef(aColors, aEntities){
            {
                this.source = TextureDef.TextureSource.osm;
                this.colors = list;
                this.entities = list2;
            }
        };
    }

    protected static List<ColorDef> getAllColors() {
        LinkedList<ColorDef> colors = new LinkedList<ColorDef>();
        colors.add(new ColorDef(){
            {
                this.name = "wood";
                this.roughGrass = 0.4;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "sand";
                this.dirt = 0.6;
                this.mud = 0.1;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "green";
                this.roughGrass = 0.08;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "farm";
                this.roughGrass = 0.15;
                this.dirt = 0.3;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "gravel";
                this.dirt = 0.2;
                this.mud = 0.3;
                this.roughGrass = 0.3;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "garden";
                this.roughGrass = 0.15;
                this.dirt = 0.1;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "leisure";
                this.roughGrass = 0.2;
                this.mud = 0.1;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "building";
                this.mud = 0.3;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "road";
                this.dirt = 0.6;
                this.mud = 0.4;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "town";
                this.dirt = 0.1;
                this.mud = 0.1;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "military";
                this.dirt = 0.2;
                this.mud = 0.1;
                this.roughGrass = 0.2;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "water";
                this.dirt = 0.5;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "railway";
                this.mud = 0.8;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "aerialway";
                this.dirt = 0.4;
                this.mud = 0.25;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "aeroway";
                this.dirt = 0.5;
                this.mud = 0.3;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "aeroway2";
                this.dirt = 0.5;
                this.mud = 0.1;
                this.roughGrass = 0.2;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "barrier";
                this.mud = 0.8;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "oneway";
                this.roughGrass = 0.5;
                this.mud = 0.4;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "bridge";
                this.roughGrass = 0.8;
            }
        });
        return colors;
    }

    protected static List<EntityDef> getEntitiesLowest() {
        LinkedList<EntityDef> entities = new LinkedList<EntityDef>();
        entities.add(new WayDef(){
            {
                this.key = "railway";
                this.value = "rail";
                this.color = "railway";
                this.strokeWidth = 0.6;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "primary";
                this.color = "road";
                this.strokeWidth = 1.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "trunk";
                this.color = "road";
                this.strokeWidth = 1.3;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "motorway";
                this.color = "road";
                this.strokeWidth = 1.5;
            }
        });
        return entities;
    }

    protected static List<EntityDef> getEntitiesLow() {
        LinkedList<EntityDef> entities = new LinkedList<EntityDef>();
        entities.add(new PolygonDef(){
            {
                this.key = "waterway";
                this.value = "riverbank";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.value = "water";
                this.color = "water";
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "railway";
                this.value = "rail";
                this.color = "railway";
                this.strokeWidth = 0.6;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "secondary";
                this.color = "road";
                this.strokeWidth = 0.8;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "primary";
                this.color = "road";
                this.strokeWidth = 1.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "motorway_link|trunk_link";
                this.color = "road";
                this.strokeWidth = 0.8;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "trunk";
                this.color = "road";
                this.strokeWidth = 1.3;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "motorway";
                this.color = "road";
                this.strokeWidth = 1.5;
            }
        });
        return entities;
    }

    protected static List<EntityDef> getEntitiesMed() {
        LinkedList<EntityDef> entities = new LinkedList<EntityDef>();
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.value = "forest";
                this.color = "wood";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.value = "wood";
                this.color = "wood";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "farm|farmland";
                this.color = "farm";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "commercial|industrial|residential|retail";
                this.color = "town";
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "waterway";
                this.color = "water";
                this.strokeWidth = 1.0;
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "waterway";
                this.value = "riverbank";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.value = "water";
                this.color = "water";
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "railway";
                this.value = "rail";
                this.color = "railway";
                this.strokeWidth = 0.6;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "unclassified";
                this.color = "road";
                this.strokeWidth = 0.4;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "tertiary";
                this.color = "road";
                this.strokeWidth = 0.6;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "secondary";
                this.color = "road";
                this.strokeWidth = 0.9;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "primary";
                this.color = "road";
                this.strokeWidth = 1.2;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "motorway_link|trunk_link";
                this.color = "road";
                this.strokeWidth = 1.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "trunk";
                this.color = "road";
                this.strokeWidth = 1.5;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "motorway";
                this.color = "road";
                this.strokeWidth = 1.8;
            }
        });
        return entities;
    }

    protected static List<EntityDef> getEntitiesHigh() {
        LinkedList<EntityDef> entities = new LinkedList<EntityDef>();
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.value = "forest";
                this.color = "wood";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.value = "wood";
                this.color = "wood";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "farm|farmland";
                this.color = "farm";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "commercial|construction|industrial|residential|retail";
                this.color = "town";
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "waterway";
                this.color = "water";
                this.strokeWidth = 1.0;
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "waterway";
                this.value = "riverbank";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.value = "water";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "aeroway";
                this.color = "aeroway";
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "aeroway";
                this.color = "aeroway";
                this.strokeWidth = 3.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "residential";
                this.color = "road";
                this.strokeWidth = 0.8;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "railway";
                this.value = "rail";
                this.color = "railway";
                this.strokeWidth = 0.8;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "unclassified";
                this.color = "road";
                this.strokeWidth = 1.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "_link";
                this.color = "road";
                this.strokeWidth = 0.9;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "tertiary";
                this.color = "road";
                this.strokeWidth = 1.2;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "secondary";
                this.color = "road";
                this.strokeWidth = 1.6;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "primary";
                this.color = "road";
                this.strokeWidth = 2.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "motorway_link|trunk_link";
                this.color = "road";
                this.strokeWidth = 1.3;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "trunk";
                this.color = "road";
                this.strokeWidth = 2.5;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "motorway";
                this.color = "road";
                this.strokeWidth = 3.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "bridge";
                this.value = "yes";
                this.color = "bridge";
                this.strokeWidth = 0.4;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "oneway";
                this.value = "yes";
                this.color = "oneway";
                this.strokeWidth = 0.2;
            }
        });
        return entities;
    }

    protected static List<EntityDef> getEntitiesVHigh() {
        LinkedList<EntityDef> entities = new LinkedList<EntityDef>();
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.value = "forest";
                this.color = "wood";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.value = "wood";
                this.color = "wood";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.rvalue = "sand|beach|coastline";
                this.color = "sand";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "farm|farmland|orchard|vineyard";
                this.color = "farm";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "grass|meadow";
                this.color = "green";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "commercial|construction|industrial|residential|retail";
                this.color = "town";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "allotments|cemetery|village_green|recreation_ground";
                this.color = "garden";
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "waterway";
                this.color = "water";
                this.strokeWidth = 1.0;
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "waterway";
                this.value = "riverbank";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.value = "water";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.value = "reservoir";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "building";
                this.color = "building";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "barrier";
                this.rvalue = "ditch";
                this.color = "sand";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "aeroway";
                this.color = "aeroway";
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "aeroway";
                this.color = "aeroway";
                this.strokeWidth = 3.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "service";
                this.color = "road";
                this.strokeWidth = 0.6;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "living_street|pedestrian";
                this.color = "road";
                this.strokeWidth = 0.65;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "residential";
                this.color = "road";
                this.strokeWidth = 0.8;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "railway";
                this.value = "rail";
                this.color = "railway";
                this.strokeWidth = 0.8;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "unclassified";
                this.color = "road";
                this.strokeWidth = 1.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "_link";
                this.color = "road";
                this.strokeWidth = 0.9;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "tertiary";
                this.color = "road";
                this.strokeWidth = 1.2;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "secondary";
                this.color = "road";
                this.strokeWidth = 1.6;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "primary";
                this.color = "road";
                this.strokeWidth = 2.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "motorway_link|trunk_link";
                this.color = "road";
                this.strokeWidth = 1.3;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "trunk";
                this.color = "road";
                this.strokeWidth = 2.5;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "motorway";
                this.color = "road";
                this.strokeWidth = 3.0;
            }
        });
        entities.add(new NodeDef(){
            {
                this.key = "barrier";
                this.rvalue = "block|bollard|lift_gate";
                this.color = "barrier";
                this.radius = 1.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "bridge";
                this.value = "yes";
                this.color = "bridge";
                this.strokeWidth = 0.4;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "oneway";
                this.value = "yes";
                this.color = "oneway";
                this.strokeWidth = 0.2;
            }
        });
        return entities;
    }

    protected static List<EntityDef> getEntitiesUltra() {
        LinkedList<EntityDef> entities = new LinkedList<EntityDef>();
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.value = "forest";
                this.color = "wood";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.value = "wood";
                this.color = "wood";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.rvalue = "sand|beach|coastline";
                this.color = "sand";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "farm|farmland|orchard|vineyard";
                this.color = "farm";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "grass|meadow";
                this.color = "green";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.value = "quarry";
                this.color = "gravel";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "commercial|construction|industrial|residential|retail";
                this.color = "town";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "allotments|cemetery|village_green|recreation_ground";
                this.color = "garden";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.value = "military";
                this.color = "military";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "leisure";
                this.color = "leisure";
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "waterway";
                this.color = "water";
                this.strokeWidth = 0.5;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "waterway";
                this.rvalue = "river|canal";
                this.color = "water";
                this.strokeWidth = 1.5;
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "waterway";
                this.value = "riverbank";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.value = "water";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.value = "reservoir";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "leisure";
                this.rvalue = "fishing|swimming_pool";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "building";
                this.color = "building";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "barrier";
                this.rvalue = "ditch";
                this.color = "sand";
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "barrier";
                this.rvalue = "city_wall|ditch|retaining_wall";
                this.color = "barrier";
                this.strokeWidth = 0.5;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "aerialway";
                this.color = "aerialway";
                this.strokeWidth = 0.5;
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "aeroway";
                this.rvalue = "apron|helipad|runway";
                this.color = "aeroway";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "aeroway";
                this.rvalue = "hangar|terminal";
                this.color = "aeroway2";
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "aeroway";
                this.color = "aeroway";
                this.strokeWidth = 3.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.color = "road";
                this.strokeWidth = 0.3;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "track";
                this.color = "road";
                this.strokeWidth = 0.45;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "service";
                this.color = "road";
                this.strokeWidth = 0.6;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "living_street|pedestrian";
                this.color = "road";
                this.strokeWidth = 0.65;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "residential";
                this.color = "road";
                this.strokeWidth = 0.8;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "railway";
                this.color = "railway";
                this.strokeWidth = 0.2;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "railway";
                this.value = "rail";
                this.color = "railway";
                this.strokeWidth = 0.8;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "unclassified";
                this.color = "road";
                this.strokeWidth = 1.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "_link";
                this.color = "road";
                this.strokeWidth = 0.9;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "tertiary";
                this.color = "road";
                this.strokeWidth = 1.2;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "secondary";
                this.color = "road";
                this.strokeWidth = 1.6;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "primary";
                this.color = "road";
                this.strokeWidth = 2.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "motorway_link|trunk_link";
                this.color = "road";
                this.strokeWidth = 1.3;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "trunk";
                this.color = "road";
                this.strokeWidth = 2.5;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "motorway";
                this.color = "road";
                this.strokeWidth = 3.0;
            }
        });
        entities.add(new NodeDef(){
            {
                this.key = "barrier";
                this.rvalue = "block|bollard|lift_gate";
                this.color = "barrier";
                this.radius = 1.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "bridge";
                this.value = "yes";
                this.color = "bridge";
                this.strokeWidth = 0.6;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "oneway";
                this.value = "yes";
                this.color = "oneway";
                this.strokeWidth = 0.5;
            }
        });
        return entities;
    }
}

