/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutWindow
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(AboutWindow.class);
    private static final long serialVersionUID = 5583448871617188269L;
    private final JPanel contentPanel = new JPanel();

    public AboutWindow() {
        this.setTitle("About maps4cim");
        this.setBounds(200, 200, 540, 340);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JLabel lblTitle = new JLabel("maps4cim");
        lblTitle.setFont(new Font("Tahoma", 1, 14));
        lblTitle.setHorizontalAlignment(0);
        JEditorPane editorPaneAboutText = new JEditorPane();
        editorPaneAboutText.setContentType("text/html");
        editorPaneAboutText.setEditable(false);
        editorPaneAboutText.setText("<html>\r\n<p>maps4cim, version 0.9 (2013-06-24)<br />\r\ndeveloped by Sebastian Straub &lt;<a href=\"mailto:sebastian-straub@gmx.net\">sebastian-straub@gmx.net</a>&gt;</p>\r\n<p>maps4cim is a real-world map generator for the traffic simulation game <a href=\"http://www.citiesinmotion2.com/\" title=\"Cities in Motion 2\">Cities in Motion 2</a>, which relies on free geospatial data from the <a href=\"http://www2.jpl.nasa.gov/srtm/\">SRTM</a> and <a href=\"http://www.openstreetmap.org/\">OpenStreetMap</a>.</p>\r\n<p>For updates, visit the <a href=\"http://nx42.de/projects/maps4cim/\">project homepage</a>.\r\n<p>Please be aware that this is a beta release. It may contain serious bugs, so use it at your own risk. Watch for updates on the project homepage or in the forums.</p>\r\n</html>");
        editorPaneAboutText.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutWindow.this.jEditorPaneAboutTextHyperlinkUpdate(evt);
            }
        });
        JScrollPane scrollPane1 = new JScrollPane(editorPaneAboutText);
        scrollPane1.setVerticalScrollBarPolicy(20);
        scrollPane1.setHorizontalScrollBarPolicy(31);
        scrollPane1.setBorder(null);
        final JScrollBar vScroll = scrollPane1.getVerticalScrollBar();
        vScroll.setValue(vScroll.getMinimum());
        GroupLayout gl_contentPanel = new GroupLayout(this.contentPanel);
        gl_contentPanel.setHorizontalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addGap(10).addComponent(lblTitle, -1, 304, Short.MAX_VALUE).addContainerGap()).addComponent(scrollPane1, -1, 324, Short.MAX_VALUE));
        gl_contentPanel.setVerticalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addContainerGap().addComponent(lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(scrollPane1, -1, 83, Short.MAX_VALUE)));
        this.contentPanel.setLayout(gl_contentPanel);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("Close");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutWindow.this.dispose();
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                vScroll.setValue(vScroll.getMinimum());
            }
        });
    }

    private void jEditorPaneAboutTextHyperlinkUpdate(HyperlinkEvent evt) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(evt.getEventType())) {
            try {
                AboutWindow.openWeb(evt.getURL().toURI());
            }
            catch (URISyntaxException ex) {
                log.error("Could not open URL", ex);
            }
        }
    }

    private static void openWeb(URI uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
            }
            catch (IOException ex) {
                log.error("", ex);
            }
        } else {
            JOptionPane.showMessageDialog(null, String.format("Your java runtime does not seem to support the opening of weblinks.\nYou can open the link manually though:\n%s", uri.toString()), "Unable to open weblink", 0);
        }
    }

    private static void openWeb(URL url) {
        try {
            AboutWindow.openWeb(url.toURI());
        }
        catch (URISyntaxException ex) {
            log.error("", ex);
        }
    }

    private static void openWeb(String uri) {
        try {
            AboutWindow.openWeb(new URI(uri));
        }
        catch (URISyntaxException ex) {
            log.error("", ex);
        }
    }
}

