/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.config.texture;

import de.nx42.maps4cim.config.texture.PolygonDef;
import de.nx42.maps4cim.config.texture.WayDef;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlTransient
@XmlType(propOrder={"key", "value", "rvalue", "color"})
public abstract class EntityDef {
    @XmlAttribute(name="key", required=true)
    public String key;
    @XmlAttribute(name="value")
    public String value;
    @XmlAttribute(name="rvalue")
    public String rvalue;
    @XmlAttribute(name="color", required=true)
    public String color;

    public static List<EntityDef> getDefaults() {
        LinkedList<EntityDef> entities = new LinkedList<EntityDef>();
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "forest|wood";
                this.color = "wood";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.rvalue = "forest|wood";
                this.color = "wood";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "farm|farmland|orchard|vineyard";
                this.color = "farm";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "grass|meadow";
                this.color = "green";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "commercial|construction|industrial|residential|retail";
                this.color = "town";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "landuse";
                this.rvalue = "allotments|cemetery|village_green";
                this.color = "garden";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "leisure";
                this.value = "*";
                this.color = "leisure";
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "waterway";
                this.color = "water";
                this.strokeWidth = 1.0;
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "waterway";
                this.value = "riverbank";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "natural";
                this.value = "water";
                this.color = "water";
            }
        });
        entities.add(new PolygonDef(){
            {
                this.key = "building";
                this.color = "building";
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.color = "road";
                this.strokeWidth = 0.3;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "track";
                this.color = "road";
                this.strokeWidth = 0.45;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "service";
                this.color = "road";
                this.strokeWidth = 0.6;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "living_street|pedestrian";
                this.color = "road";
                this.strokeWidth = 0.65;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "residential";
                this.color = "road";
                this.strokeWidth = 0.8;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "railway";
                this.color = "railway";
                this.strokeWidth = 0.9;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "unclassified";
                this.color = "road";
                this.strokeWidth = 1.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "_link";
                this.color = "road";
                this.strokeWidth = 0.9;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "tertiary";
                this.color = "road";
                this.strokeWidth = 1.2;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "secondary";
                this.color = "road";
                this.strokeWidth = 1.6;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "primary";
                this.color = "road";
                this.strokeWidth = 2.0;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.rvalue = "motorway_link|trunk_link";
                this.color = "road";
                this.strokeWidth = 1.5;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "trunk";
                this.color = "road";
                this.strokeWidth = 2.5;
            }
        });
        entities.add(new WayDef(){
            {
                this.key = "highway";
                this.value = "motorway";
                this.color = "road";
                this.strokeWidth = 3.0;
            }
        });
        return entities;
    }

    public abstract String getType();

    public boolean allowsAnyValue() {
        if (this.value != null) {
            return this.value.trim().equals("*");
        }
        return this.rvalue == null;
    }

    public boolean hasExactValue() {
        return this.value != null;
    }

    public boolean hasRegexValue() {
        return this.rvalue != null;
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.rvalue;
    }

    public String toString() {
        if (this.value == null && this.rvalue == null) {
            return String.format("Entity with [\"%s\"] (any value)", this.key);
        }
        if (this.rvalue == null) {
            return String.format("Entity with [\"%s\"=\"%s\"] (exact match)", this.key, this.value);
        }
        return String.format("Entity with [\"%s\"~\"%s\"] (regex match)", this.key, this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.rvalue == null ? 0 : this.rvalue.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }
}

