/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.config.texture;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="color")
public class ColorDef {
    @XmlAttribute(name="name", required=true)
    public String name;
    @XmlAttribute(name="grass")
    public Double grass;
    @XmlAttribute(name="rough-grass")
    public Double roughGrass;
    @XmlAttribute(name="mud")
    public Double mud;
    @XmlAttribute(name="dirt")
    public Double dirt;
    @XmlAttribute(name="pavement")
    public Double pavement;
    @XmlAttribute(name="black")
    public Double black;

    public float getSafeGrass() {
        return this.grass != null ? this.grass.floatValue() : 0.0f;
    }

    public float getSafeRoughGrass() {
        return this.roughGrass != null ? this.roughGrass.floatValue() : 0.0f;
    }

    public float getSafeMud() {
        return this.mud != null ? this.mud.floatValue() : 0.0f;
    }

    public float getSafeDirt() {
        return this.dirt != null ? this.dirt.floatValue() : 0.0f;
    }

    public float getSafePavement() {
        return this.pavement != null ? this.pavement.floatValue() : 0.0f;
    }

    public float getSafeBlack() {
        return this.black != null ? this.black.floatValue() : 0.0f;
    }

    public static ColorDef getColorByName(Collection<ColorDef> colors, String name) {
        for (ColorDef colorDef : colors) {
            if (!colorDef.name.equals(name)) continue;
            return colorDef;
        }
        return null;
    }

    public static List<ColorDef> getDefaults() {
        LinkedList<ColorDef> colors = new LinkedList<ColorDef>();
        colors.add(new ColorDef(){
            {
                this.name = "wood";
                this.roughGrass = 0.4;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "green";
                this.roughGrass = 0.2;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "farm";
                this.roughGrass = 0.15;
                this.dirt = 0.3;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "garden";
                this.roughGrass = 0.15;
                this.dirt = 0.1;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "leisure";
                this.roughGrass = 0.2;
                this.mud = 0.1;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "building";
                this.mud = 0.6;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "road";
                this.dirt = 0.6;
                this.mud = 0.4;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "town";
                this.dirt = 0.1;
                this.mud = 0.1;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "water";
                this.dirt = 0.5;
            }
        });
        colors.add(new ColorDef(){
            {
                this.name = "railway";
                this.mud = 0.8;
            }
        });
        return colors;
    }
}

