/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim.config;

import com.google.common.base.Strings;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="relief")
public class ReliefDef {
    @XmlAttribute(name="source")
    public ReliefSource source;
    @XmlAttribute(name="height-offset")
    public String heightOffset;
    @XmlAttribute(name="height-scale")
    public Double heightScale;

    public ReliefSource getSource() {
        if (this.source == null) {
            return ReliefSource.srtm;
        }
        return this.source;
    }

    public HeightOffset getHeightOffsetType() {
        return HeightOffset.parse(this.heightOffset);
    }

    public boolean isHeightOffsetAuto() {
        return HeightOffset.parse(this.heightOffset) == HeightOffset.AUTO;
    }

    public double getHeightOffset() {
        if (Strings.isNullOrEmpty(this.heightOffset)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.heightOffset);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public Double getHeightScale() {
        return this.heightScale <= 0.01 ? 1.0 : this.heightScale;
    }

    public static ReliefDef none() {
        return new ReliefDef(){
            {
                this.source = ReliefSource.none;
            }
        };
    }

    public static ReliefDef srtm(double ho, boolean hoAuto, double hs) {
        return new ReliefDef(hoAuto, ho, hs){
            {
                this.source = ReliefSource.srtm;
                this.heightOffset = bl ? "auto" : String.valueOf(d);
                this.heightScale = d2;
            }
        };
    }

    public static enum HeightOffset {
        NONE,
        AUTO,
        CUSTOM;


        public static HeightOffset parse(String value) {
            String val = value.toLowerCase().trim();
            if ("none".equals(val)) {
                return NONE;
            }
            if ("auto".equals(val)) {
                return AUTO;
            }
            return CUSTOM;
        }
    }

    public static enum ReliefSource {
        none,
        srtm,
        mandelbrot;

    }
}

