/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim;

import java.util.LinkedList;
import java.util.List;

public class Result {
    protected String task;
    protected List<String> messages = new LinkedList<String>();
    protected Boolean success;

    public Result(String task) {
        this.task = task;
    }

    public Result(String task, boolean success) {
        this.task = task;
        this.success = success;
    }

    public Result success() {
        this.success = true;
        return this;
    }

    public Result failure(String message) {
        this.success = false;
        this.messages.add(message);
        return this;
    }

    public boolean isSuccess() {
        return this.success != null && this.success != false;
    }

    public boolean isFailure() {
        return this.success == null || this.success == false;
    }

    public String getReport() {
        if (this.success == null) {
            return String.format("The result of task \"%s\" is not yet decided", this.task);
        }
        if (this.success.booleanValue()) {
            return String.format("The task \"%s\" was successfully completed", this.task);
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("The task \"");
        sb.append(this.task);
        sb.append("\" finished with errors:");
        for (String message : this.messages) {
            sb.append('\n');
            sb.append(message);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getReport();
    }
}

