/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class ResourceLoader {
    public static final File appdata = ResourceLoader.locateAppDir();
    public static final String appdataDirName = "maps4cim";
    protected static String path_cim2 = "cim2/";
    protected static String path_srtm = "srtm/";

    public static InputStream get(String res) {
        return ResourceLoader.class.getClassLoader().getResourceAsStream(res);
    }

    public static byte[] getStaticMapHeader() throws IOException {
        return ResourceLoader.readBase64Resource(String.valueOf(path_cim2) + "prefix.base64");
    }

    public static byte[] getStaticMapFooter() throws IOException {
        return ResourceLoader.readBase64Resource(String.valueOf(path_cim2) + "postfix.base64");
    }

    public static InputStream getMappingSRTM() {
        return ResourceLoader.get("srtm/srtm-mapping.obj");
    }

    public static byte[] readBase64Resource(String path) throws IOException {
        String base64 = Resources.toString(Resources.getResource(path), Charsets.UTF_8);
        String trimmed = CharMatcher.WHITESPACE.removeFrom(base64);
        return BaseEncoding.base64().decode(trimmed);
    }

    public static <T> T deserializeObject(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        return ResourceLoader.deserializeObject(new FileInputStream(file));
    }

    public static <T> T deserializeObject(InputStream is) throws ClassNotFoundException, IOException {
        ObjectInputStream ois = new ObjectInputStream(is);
        Object object = ois.readObject();
        ois.close();
        return (T)object;
    }

    public static File getAppDir() {
        if (!appdata.exists()) {
            appdata.mkdirs();
        }
        return appdata;
    }

    private static final File locateAppDir() {
        File appdir;
        if (System.getProperty("os.name").startsWith("Windows")) {
            String apps = System.getenv("APPDATA");
            appdir = new File(apps, appdataDirName);
        } else {
            String home = System.getProperty("user.home");
            appdir = new File(home, ".maps4cim");
        }
        return appdir;
    }
}

