/*
 * Decompiled with CFR 0.152.
 */
package de.nx42.maps4cim;

import de.nx42.maps4cim.Result;
import de.nx42.maps4cim.config.Config;
import de.nx42.maps4cim.header.Header;
import de.nx42.maps4cim.header.StaticHeader;
import de.nx42.maps4cim.map.Cache;
import de.nx42.maps4cim.map.ReliefMap;
import de.nx42.maps4cim.map.TextureMap;
import de.nx42.maps4cim.map.ex.MapGeneratorException;
import de.nx42.maps4cim.map.relief.PlanarRelief;
import de.nx42.maps4cim.map.texture.SingleTexture;
import de.nx42.maps4cim.objects.GameObjects;
import de.nx42.maps4cim.objects.StaticGameObjects;
import java.io.File;
import java.io.FileOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapGenerator {
    private static final Logger log = LoggerFactory.getLogger(MapGenerator.class);
    protected Config config;
    protected Header he;
    protected ReliefMap rm;
    protected TextureMap tm;
    protected GameObjects go;

    public MapGenerator(Config config, ReliefMap rm, TextureMap tm) {
        log.debug("Initializing the Map Generator...");
        this.config = config;
        this.he = new StaticHeader();
        this.rm = rm;
        this.tm = tm;
        this.go = new StaticGameObjects();
    }

    public MapGenerator(Config config) {
        this(config, new PlanarRelief(), new SingleTexture());
    }

    public Result generateMap(File output) throws MapGeneratorException {
        Result res = new Result("generating map", true);
        try {
            FileOutputStream fos = new FileOutputStream(output);
            log.info("Writing resulting map to file {}", (Object)output.toString());
            this.he.writeTo(fos);
            try {
                this.rm.writeTo(fos);
            }
            catch (MapGeneratorException e) {
                log.error("Error while processing the relief map, falling back to a simple planar relief.", e);
                res.failure("the intended relief map could not be generated");
                PlanarRelief planar = new PlanarRelief();
                planar.writeTo(fos);
            }
            try {
                this.tm.writeTo(fos);
            }
            catch (MapGeneratorException e) {
                log.error("Error while processing the texture map, falling back to a simple grass texture.");
                res.failure("the intended texture map could not be generated");
                SingleTexture simple = new SingleTexture();
                simple.writeTo(fos);
            }
            this.go.writeTo(fos);
            fos.flush();
            fos.close();
            Result result = res;
            return result;
        }
        catch (Exception e) {
            log.error("Error generating map", e);
            throw new MapGeneratorException(e);
        }
        finally {
            Cache.clearTemp();
        }
    }

    public static String cleanFileName(String name) {
        return name.replaceAll("\\W+", "");
    }
}

