void _fragVSBase(float4 pos : POSITION, out float4 vOutPos : POSITION)
{
	vOutPos = mul(pos, matWorld);
}

void _fragColor(float4 cColor : r_cColor, out float4 outColor : COLOR)
{
	outColor = cColor;
};

#define TEXCOORDTOREGISTER(fragname, inRegister) \
void _frag##fragname(float2 inTexCoord : inRegister, out float2 registerCoord : r_vTexCoordReg)\
{\
	registerCoord = inTexCoord;\
};

TEXCOORDTOREGISTER(RegTexCoord0, TEXCOORD0);
TEXCOORDTOREGISTER(RegTexCoord1, TEXCOORD1);
TEXCOORDTOREGISTER(RegTexCoord2, TEXCOORD2);
TEXCOORDTOREGISTER(RegTexCoord3, TEXCOORD3);
TEXCOORDTOREGISTER(RegTexCoord4, TEXCOORD4);
TEXCOORDTOREGISTER(RegTexCoord5, TEXCOORD5);
TEXCOORDTOREGISTER(RegTexCoord6, TEXCOORD6);
TEXCOORDTOREGISTER(RegTexCoord7, TEXCOORD7);

#define TEXCOORDOUT(fragname, outregister) \
void _frag##fragname(float2 texCoord : r_vTexCoordReg, out float2 outTex : outregister)\
{\
	outTex = texCoord;\
};

TEXCOORDOUT(OutTexCoord0, TEXCOORD0);
TEXCOORDOUT(OutTexCoord1, TEXCOORD1);
TEXCOORDOUT(OutTexCoord2, TEXCOORD2);
TEXCOORDOUT(OutTexCoord3, TEXCOORD3);
TEXCOORDOUT(OutTexCoord4, TEXCOORD4);
TEXCOORDOUT(OutTexCoord5, TEXCOORD5);
TEXCOORDOUT(OutTexCoord6, TEXCOORD6);
TEXCOORDOUT(OutTexCoord7, TEXCOORD7);

#define TRANSFORMTEXREGBYMAT(fragname, matrix) \
void _frag##fragname(inout float2 texCoord : r_vTexCoordReg)\
{\
	texCoord.xy = mul(float3(texCoord.xy, 1.0f), matrix);\
};

TRANSFORMTEXREGBYMAT(TexCoordTransMat3x40, mat3x4TexGen0);
TRANSFORMTEXREGBYMAT(TexCoordTransMat3x41, mat3x4TexGen1);
TRANSFORMTEXREGBYMAT(TexCoordTransMat3x42, mat3x4TexGen2);
TRANSFORMTEXREGBYMAT(TexCoordTransMat3x43, mat3x4TexGen3);
TRANSFORMTEXREGBYMAT(TexCoordTransMat3x44, mat3x4TexGen4);
TRANSFORMTEXREGBYMAT(TexCoordTransMat3x45, mat3x4TexGen5);
TRANSFORMTEXREGBYMAT(TexCoordTransMat3x46, mat3x4TexGen6);
TRANSFORMTEXREGBYMAT(TexCoordTransMat3x47, mat3x4TexGen7);

TRANSFORMTEXREGBYMAT(TexCoordTransMat2x40, mat2x4TexGen0);
TRANSFORMTEXREGBYMAT(TexCoordTransMat2x41, mat2x4TexGen1);
TRANSFORMTEXREGBYMAT(TexCoordTransMat2x42, mat2x4TexGen2);
TRANSFORMTEXREGBYMAT(TexCoordTransMat2x43, mat2x4TexGen3);
TRANSFORMTEXREGBYMAT(TexCoordTransMat2x44, mat2x4TexGen4);
TRANSFORMTEXREGBYMAT(TexCoordTransMat2x45, mat2x4TexGen5);
TRANSFORMTEXREGBYMAT(TexCoordTransMat2x46, mat2x4TexGen6);
TRANSFORMTEXREGBYMAT(TexCoordTransMat2x47, mat2x4TexGen7);