  //8REGRES_2.CPP
  //ԪԻع
  #include  <iostream>
  #include  <iomanip>
  #include  <fstream>
  #include  <cmath>
  using namespace std;
  class  regres_2
  {
  private: 
	       int m, n, nn;
		   double  **x, *y, *a;
		   double  q, s, r, *v, u;
		   double  **b;
  public:
	       regres_2 (int mm, int nnn)
		   {
			   int i;
			   m = mm; n = nnn;
	           nn = m + 1;
               x = new double*[m];    //̬ڴ
	           for (i=0; i<m; i++)  x[i] = new double[n];
	           y = new double[n];
	           a = new double[m+1];
	           v = new double[m];
	           b = new double*[m+1];
	           for (i=0; i<=m; i++) b[i] = new double[m+1];
		   }
	       void  input (); //ļnmԱֵX,n۲ֵy
		   void analysis ();    //ִжԪԻع
           void chol ();       //ִCholeskyֽⷨ
           void output ();  //عϵaԼͳļʾ
		   ~regres_2 ()
		   {
			   int i;
			   for (i=0; i<m; i++) { delete [] x[i]; }
			   delete [] x;
			   for (i=0; i<=m; i++) { delete [] b[i]; }
			   delete [] b;
			   delete [] y, a, v; 
		   }
  };

  void regres_2::input ()//ļnmԱֵX,n۲ֵy
  {
	  int  i, j;
	  char str1[20];
	  cout <<"\nļ:  ";
	  cin >>str1;
	  ifstream  fin (str1);
	  if (!fin)
	  { cout <<"\nܴļ " <<str1 <<endl; exit(1); }
      for (i=0; i<m; i++)  //nmԱֵX
      for (j=0; j<n; j++)  fin >>x[i][j];
      for (i=0; i<n; i++)  fin >>y[i]; //n۲ֵ
	  fin.close ();
  }

  void regres_2::analysis() //ִжԪԻع
  { 
	  int i,j,k;
      double e,p,yy,pp;
      b[nn-1][nn-1] = n;
      for (j=0; j<=m-1; j++)
      { 
		  p=0.0;
          for (i=0; i<=n-1; i++) p=p+x[j][i];
          b[m][j]=p;
          b[j][m]=p;
      }
      for (i=0; i<=m-1; i++)
      for (j=i; j<=m-1; j++)
      { 
		  p=0.0;
          for (k=0; k<=n-1; k++)  p=p+x[i][k]*x[j][k];
          b[j][i]=p;
          b[i][j]=p;
      }
      a[m]=0.0;
      for (i=0; i<=n-1; i++) a[m]=a[m]+y[i];
      for (i=0; i<=m-1; i++)
      { 
		  a[i]=0.0;
          for (j=0; j<=n-1; j++)  a[i]=a[i]+x[i][j]*y[j];
      }
      chol();
      yy=0.0;
      for (i=0; i<=n-1; i++)  yy=yy+y[i]/n;
      q=0.0; e=0.0; u=0.0;
      for (i=0; i<=n-1; i++)
      { 
		  p=a[m];
          for (j=0; j<=m-1; j++) p=p+a[j]*x[j][i];
          q=q+(y[i]-p)*(y[i]-p);
          e=e+(y[i]-yy)*(y[i]-yy);
          u=u+(yy-p)*(yy-p);
      }
      s=sqrt(q/n);
      r=sqrt(1.0-q/e);
      for (j=0; j<=m-1; j++)
      { 
		  p=0.0;
          for (i=0; i<=n-1; i++)
          { 
			  pp=a[m];
              for (k=0; k<=m-1; k++)
                  if (k!=j) pp=pp+a[k]*x[k][i];
              p=p+(y[i]-pp)*(y[i]-pp);
          }
          v[j]=sqrt(1.0-q/p);
      }
  }

  void regres_2::chol ()       //ִCholeskyֽⷨ
  { 
	  int i,j,k;
      b[0][0]=sqrt(b[0][0]);
      for (j=1; j<=nn-1; j++)  b[0][j]=b[0][j]/b[0][0];
      for (i=1; i<=nn-1; i++)
      { 
          for (j=1; j<=i; j++)
          { 
              b[i][i]=b[i][i]-b[j-1][i]*b[j-1][i];
          }
          b[i][i]=sqrt(b[i][i]);
          if (i!=(nn-1))
          { 
			  for (j=i+1; j<=nn-1; j++)
              { 
                  for (k=1; k<=i; k++)
                      b[i][j]=b[i][j]-b[k-1][i]*b[k-1][j];
                  b[i][j]=b[i][j]/b[i][i];
              }
          }
      } 
      a[0]=a[0]/b[0][0];
      for (i=1; i<=nn-1; i++)
      { 
          for (k=1; k<=i; k++)
              a[i]=a[i]-b[k-1][i]*a[k-1];
          a[i]=a[i]/b[i][i];
      } 
      a[nn-1]=a[nn-1]/b[nn-1][nn-1];
      for (k=nn-1; k>=1; k--)
      { 
          for (i=k; i<=nn-1; i++)
              a[k-1]=a[k-1]-b[k-1][i]*a[i];
          a[k-1]=a[k-1]/b[k-1][k-1];
      }
  }

  void regres_2::output () //عϵaԼͳļʾ
  {
	  int i;
	  char str2[20];
	  cout <<"\nļ:  ";
	  cin >>str2;
	  ofstream fout (str2);
	  if (!fout)
	  { cout <<"\nܴļ " <<str2 <<endl; exit(1); }
	  for (i=0; i<=m; i++)
	  {
		  fout <<a[i] <<"    ";
		  cout <<"a(" <<i <<") = " <<a[i] <<"   ";
	  }
	  fout <<endl;  cout <<endl;
	  cout <<"ƫƽ = " <<q <<endl;    fout <<q <<endl;
	  cout <<"ƽ׼ƫ = " <<s <<endl;  fout <<s <<endl;
	  cout <<"ϵ = " <<r <<endl;    fout <<r <<endl;
	  cout <<"عƽ = " <<u <<endl;    fout <<u <<endl;
	  cout <<"mԱƫϵ:" <<endl;   fout <<endl;
	  for (i=0; i<m; i++)
	  {
		  fout <<v[i] <<"    ";
		  cout <<"v(" <<i <<") = " <<v[i] <<"   ";
	  }
	  fout <<endl;  cout <<endl;
	  fout.close ();
  }

  void main ()      //
  {
	  regres_2  s(3, 5);           //
	  s.input ();  //ļnmԱֵX,n۲ֵy
	  s.analysis ();     //ִжԪԻع
	  s.output (); //عϵaԼͳļʾ
  }

