  //5HMT.CPP
  //Hermiteֵ
  #include  <iostream>
  #include  <fstream>
  #include  <cmath>
  using namespace std;
  class  hmt
  {
  private: 
           int n;
		   double  *x, *y, *dy, t, z;
  public:
	       hmt (int nn)
		   {
			   n = nn;
               x = new double[n];    //̬ڴ
	           y = new double[n];
	           dy = new double[n];
		   }
	       void input ();          //ļnݵ(x, y)
		   double interp (double);    //ִHermiteֵ
           void output ();         //ֵtĽֵzļ
		   ~hmt ()
		   {  delete [] x, y, dy;  }
  };

  void hmt::input ()      //ļnݵ(x, y)
  {
	  int  k;
	  char str1[20];
	  cout <<"\nļ:  ";
	  cin >>str1;
	  ifstream  fin (str1);
	  if (!fin)
	  { cout <<"\nܴļ " <<str1 <<endl; exit(1); }
      for (k=0; k<n; k++)              //nݵ
	  { fin >>x[k];  fin >>y[k];  fin >>dy[k]; }
	  fin.close ();
  }

  double hmt::interp (double tt)      //ִHermiteֵ
  { 
	  int i,j;
      double p,q,s;
	  t = tt;
      z=0.0;
      for (i=1;i<=n;i++)
      { 
		  s=1.0;
          for (j=1;j<=n;j++)
              if (j!=i) s=s*(t-x[j-1])/(x[i-1]-x[j-1]);
          s=s*s;
          p=0.0;
          for (j=1;j<=n;j++)
              if (j!=i) p=p+1.0/(x[i-1]-x[j-1]);
          q=y[i-1]+(t-x[i-1])*(dy[i-1]-2.0*y[i-1]*p);
          z=z+q*s;
      }
      return z;
  }

  void hmt::output ()       //ֵtĽֵzļ
  {
	  char str2[20];
	  cout <<"\nļ:  ";
	  cin >>str2;
	  ofstream fout (str2, ios::app);
	  if (!fout)
	  { cout <<"\nܴļ " <<str2 <<endl; exit(1); }
	  fout <<endl <<t <<"   " <<z <<endl;
	  fout.close ();
  }

  void main ()      //
  {
	  hmt  solution(10); 
	  solution.input ();          //ļnݵ(x, y)
	  cout <<"z(0.356) = "<<solution.interp (0.356)<<endl;  //ִвֵ
	  solution.output ();          //ֵtĽֵzļ
  }

//z(0.356) = 0.70048
