function OnBind(self)
	local attr = self:GetAttribute()
	attr.top = 0
end

function OnInitControl(self)
	local attr = self:GetAttribute()
	local key = self:GetControlObject("key")
	local value = self:GetControlObject("value")
	key:SetText(attr.key)
	value:SetText(attr.value)
end

function SetSel(self,value)
	local bkg = self:GetControlObject("background")
	if not bkg then return end
	if value then
		bkg:SetResID("texture.tasklist.select_item.bk")
	else
		bkg:SetResID("texture.tasklist.item.bk")	
	end
end

function List_GetSel(self)
	local attr = self:GetAttribute()
	return attr.selitem
end

function List_SetSel(self,item)
	local attr = self:GetAttribute()
	if attr.selitem then
		attr.selitem:SetSel(false)
	end
	attr.selitem = item
	item:SetSel(true)
	self:FireExtEvent("OnSelectChanged")
end

function OnLButtonDown(self)
	local list = self:GetOwnerControl()
	list:SetSel(self)
end

function InsertItem(self,key,value)
	local content = self:GetControlObject("content")
	local cnt = content:GetChildCount()
	local objFactory = XLGetObject("Xunlei.UIEngine.ObjectFactory")
	local obj = objFactory:CreateUIObject("listitem."..cnt, "ListItem")
	local attr = obj:GetAttribute()
	attr.key = key
	attr.value = value
	content:AddChild(obj)
	local left,top,right,bottom = content:GetObjPos()
	obj:SetObjPos(0, cnt*22, right-left,cnt*22+22)
end

function SetAdjust(self)
	local attr = self:GetAttribute()
	local top1 = attr.top
	local content = self:GetControlObject("content")
	local left,top,right,bottom = content:GetObjPos()
	local cnt = content:GetChildCount()-1
	for i=0,cnt do
		local item = content:GetChildByIndex(i)
		item:SetObjPos(0, top1, right-left,top1+22)
		top1 = top1 + 22
	end
end

function DeleteAllItems(self)
	local content = self:GetControlObject("content")
	for i=content:GetChildCount()-1,0,-1 do
		content:RemoveChild(content:GetChildByIndex(i))
	end
end

function OnLButtonDbClick(self)
	local key = self:GetControlObject("key")
	local app = XLGetObject("SpyApp")
	app:CopyTextToClipBoard(key:GetText())
end

function OnRButtonDbClick(self)
	local value = self:GetControlObject("value")
	local app = XLGetObject("SpyApp")
	app:CopyTextToClipBoard(value:GetText())
end

function MouseWheel(self, distance)
	local content = self:GetControlObject("content")
	local left,top,right,bottom = content:GetObjPos()
	local height = bottom - top
	local attr = self:GetAttribute()
	local top1 = attr.top
	if distance > 0 then
		top1 = top1 + 22
	elseif distance < 0 then
		top1 = top1 - 22
	end
	local cnt = content:GetChildCount()
	if height - (cnt*22 + top1) < 0 then
		attr.top = top1
	else
		attr.top = height - (cnt*22 + top1) + attr.top - 22		
	end
	if attr.top > 0 then attr.top = 0 end
	self:SetAdjust()
	local vscroll = self:GetControlObject("vscroll")
	vscroll:SetScrollPos(-attr.top, true)
end

function OnMouseWheel(self, x, y, distance)
	self:GetOwnerControl():MouseWheel(distance)
end

function OnMouseWheel_Item(self, x, y, distance)
	self:GetOwnerControl():MouseWheel(distance)
end

function UpdateScroll(self)
	local content = self:GetControlObject("content")
	local left,top,right,bottom = content:GetObjPos()
	local height = bottom - top
	local vscroll = self:GetControlObject("vscroll")
	vscroll:SetPageSize(height)
	local cnt = content:GetChildCount()
	local range = cnt*22 - height
	if range < 0 then
		vscroll:SetVisible(false)
		vscroll:SetChildrenVisible(false)
		range = 0
	else
		vscroll:SetVisible(true)
		vscroll:SetChildrenVisible(true)
	end
	vscroll:SetScrollRange(0, range)
	vscroll:SetScrollPos(0, true)
end

function List_OnInitControl(self)
	
end

function OnVScroll(self, fun, type, newpos)
	local owner = self:GetOwnerControl()
	local attr = owner:GetAttribute()
	if type == 4 then
		attr.top = -newpos
		owner:SetAdjust()
	end
end

function OnPosChange(self)
	local content = self:GetControlObject("content")
	local left,top,right,bottom = content:GetObjPos()
	local height = bottom - top
	local attr = self:GetAttribute()
	local cnt = content:GetChildCount()
	if height >= cnt*22 then attr.top = 0 self:SetAdjust() end
	self:UpdateScroll()
end

function OnScrollBarMouseWheel(self,func,x,y,distance)
	self:GetOwnerControl():MouseWheel(distance)
end