function SysBtn_OnInitControl(self)
	local hostwndManager = XLGetObject("Xunlei.UIEngine.HostWndManager")
	local hostwnd = hostwndManager:GetHostWnd("BoltFox.MainFrame")
	local state = hostwnd:GetWindowState()
	if state == "max" then
		self:SetMaxState( false )
	else
		self:SetMaxState( true )
	end
end

function OnClose(self)
	local uiHelper = XLGetGlobal("BoltFox.UIHelper")
	uiHelper:QuitApp()
end

function OnMainWndSize(self, type_, width, height)

	if type_ == "min" then
		return
	elseif type_ == "max" then
		local tree = self:GetBindUIObjectTree()
		if tree ~= nil then
			local button = tree:GetUIObject( "mainwnd.sysbtn" )
			if button ~= nil then
				button:SetMaxState( false )
			end
			
			local bkg1 = tree:GetUIObject("mainwnd.bkg1")
			bkg1:SetObjPos(0, 0, width, height)
		end
	elseif type_ == "restored" then
		local tree = self:GetBindUIObjectTree()
		if tree ~= nil then
			local button = tree:GetUIObject( "mainwnd.sysbtn" )
			if button ~= nil then
				button:SetMaxState( true )
			end
			
			local bkg1 = tree:GetUIObject("mainwnd.bkg1")
			bkg1:SetObjPos2(10, 10, "father.width-20", "father.height-20")
		end
	end
	
	local objectTree = self:GetBindUIObjectTree()
	local rootObject = objectTree:GetRootObject()
	
	rootObject:SetObjPos(0, 0, width, height)
end

function OnMaxBtnClick(self)
	local hostwndManager = XLGetObject("Xunlei.UIEngine.HostWndManager")
	local hostwnd = hostwndManager:GetHostWnd("BoltFox.MainFrame")
	local state = hostwnd:GetWindowState()
	if state == "max" then
		hostwnd:Restore()
		self:SetMaxState( true )
	else
		hostwnd:Max()
		self:SetMaxState( false )
	end
end


function OnMinisize(self)
	local hostwndManager = XLGetObject("Xunlei.UIEngine.HostWndManager")
	local hostwnd = hostwndManager:GetHostWnd("BoltFox.MainFrame")
	hostwnd:Min() 
end

local SearchParam = {
	baidu = "http://www.baidu.com/s?wd=",
	google = "http://www.google.com/q=",
	soso = "http://www.soso.com/q?pid=s.idx&cid=s.idx.se&w=xxx",
	bing = "http://cn.bing.com/search?q=xxx",
}

function OnSearch(self, func, txt)
	local attr = self:GetAttribute()
	
	local searchurl = SearchParam[attr.SearchEngine]..txt
	local owner = self:GetOwner()
	XLGetGlobal("BoltFox.UIHelper"):NavigateToUrl(searchurl,false)
	--[[local webbrowser = owner:GetUIObject("Web")
	webbrowser:Navigate(searchurl)]]--
end

function OnRButtonUp(self, x, y)
	--
	XLGetGlobal("BoltFox.UIHelper"):PopupMainMenu(x, y)
end

function OnEnterAddress(self, func, address)
--[[
	local owner = self:GetOwner()
	local webbrowser = owner:GetUIObject("Web")
	webbrowser:Navigate(address)]]--
	XLGetGlobal("BoltFox.UIHelper"):NavigateToUrl(address,true)
end

function OnNavigateComplete2(self, url)
	if url == "about:blank" then
		return 
	end

	local owner = self:GetOwner()
	local address = owner:GetUIObject("AddressCtrl")
	address:SetAddress(url)
	
	-- XLMessageBox("haha")
end

function OnTitleChange(self, strtitle)
	local owner = self:GetOwner()
	
	local title = owner:GetUIObject("mainwnd.title")
	title:SetText(strtitle)
end

function OnReload(self)
	local owner = self:GetOwner()
	local webbrowser = owner:GetUIObject("Web")
	webbrowser:Refresh ()
end

function OnStop(self)
	local owner = self:GetOwner()
	local webbrowser = owner:GetUIObject("Web")
	webbrowser:Stop()
end

function OnGo(self)
	--[[
	local owner = self:GetOwner()
	local webbrowser = owner:GetUIObject("Web")
	
	webbrowser:Navigate(self:GetAddress())]]--
	XLGetGlobal("BoltFox.UIHelper"):NavigateToUrl(self:GetAddress(),true)
end

function OnBack(self)
	local owner = self:GetOwner()
	local webbrowser = owner:GetUIObject("Web")
	webbrowser:GoBack()
end

function OnForward(self)
	local owner = self:GetOwner()
	local webbrowser = owner:GetUIObject("Web")
	webbrowser:GoForward()
end

function OnNewWindow3(self, flags, urlcontext, url)
	--[[self:Navigate(url)]]--
	XLGetGlobal("BoltFox.UIHelper"):NavigateToUrl(url,true)
	return 0, self:GetRawWebBrowser(), true
end

function ShowModalDialog(wndClass, wndID, treeClass, treeID, userData, xarName)
	local templateMananger = XLGetObject("Xunlei.UIEngine.TemplateManager")
    local modalHostWndTemplate = templateMananger:GetTemplate(wndClass,"HostWndTemplate")
    if modalHostWndTemplate == nil then
		XLMessageBox("找不到"..wndClass)
        return false
    end
    local modalHostWnd = modalHostWndTemplate:CreateInstance(wndID)
    if modalHostWnd == nil then
		XLMessageBox("无法创建"..wndID)
        return false
    end
	
    local objectTreeTemplate = templateMananger:GetTemplate(treeClass,"ObjectTreeTemplate")
    if objectTreeTemplate == nil then
		XLMessageBox("找不到"..treeClass)
        return false
    end
    local uiObjectTree = objectTreeTemplate:CreateInstance(treeID, xarName)
    if uiObjectTree == nil then
		XLMessageBox("无法创建"..treeID)
        return false
    end

	modalHostWnd:SetUserData(userData)
    modalHostWnd:BindUIObjectTree(uiObjectTree)

    local hostwndManager = XLGetObject("Xunlei.UIEngine.HostWndManager")
    local hostwnd = hostwndManager:GetHostWnd("BoltFox.MainFrame")
    
    local nRes = modalHostWnd:DoModal(hostwnd:GetWndHandle())
    hostwndManager:RemoveHostWnd(modalHostWnd:GetID())
    local objtreeManager = XLGetObject("Xunlei.UIEngine.TreeManager")
    objtreeManager:DestroyTree(uiObjectTree)	

	return nRes
end

function config_OnClick(self)
	ShowModalDialog("ConfigWnd", "ConfigWnd.1", "ConfigTree", "ConfigTree.1")
end

function title_OnClick(self)
	-- local tree = self:GetOwner()
	-- local hostwnd = tree:GetBindHostWnd()
	-- local shell = XLGetObject("Xunlei.UIEngine.OSShell")
	-- local x, y = shell:GetCursorPos()
	
	-- local clientx, clienty = hostwnd:ScreenPtToClientPt(x, y)
	
	XLGetGlobal("BoltFox.UIHelper"):PopupMainMenu(21, 30)
end

function Web_OnInitControl(self)
	local shell = XLGetObject("Xunlei.UIEngine.OSShell")
	local url = shell:GetIEMainPage()
	if url then
		self:Navigate(url)
	end
end