local function ExitDialog(owner, ret)
	local tree = owner
	local wnd = tree:GetBindHostWnd()
	wnd:EndDialog(ret)
end

function ExitBtn__OnClick(self)
	local owner = self:GetOwner()
    ExitDialog(owner, 0)
end

function OnCreate(self)
	local parent = self:GetParent()
    local tree = self:GetBindUIObjectTree()
	local bkg = tree:GetUIObject("bkg")

	local left, top, right, bottom = bkg:GetObjPos()
    local width, height = right - left, bottom - top
    local hostwndManager = XLGetObject("Xunlei.UIEngine.HostWndManager")
    local hostwnd = hostwndManager:GetHostWnd("BoltFox.MainFrame")
    local mleft, mtop, mright, mbottom = hostwnd:GetWindowRect()
    local mwidth, mheight = mright - mleft, mbottom - mtop
	
	if parent==nil then
        self:Center()
    else
        local parentleft, parenttop, parentright, parentbottom = parent:GetWindowRect()
        local parentwidth, parentheight = parentright - parentleft, parentbottom - parenttop
        local selfleft, selftop, selfright, selfbottom  = self:GetWindowRect()
        local selfwidth, selfheight = selfright - selfleft, selfbottom - selftop
        self:Move((parentwidth - selfwidth) / 2 + parentleft, (parentheight - selfheight) / 2 + parenttop, selfwidth, selfheight);
    end
	
end

function Cancel_OnClick(self)
	local owner = self:GetOwner()
    ExitDialog(owner, 0)
end

function OK_OnClick(self)
	local owner = self:GetOwner()
	local edit = owner:GetUIObject("edit.main.page")
	
	local shell = XLGetObject("Xunlei.UIEngine.OSShell")
	local url = edit:GetText()
	if shell:SetIEMainPage(url) then
		local owner = self:GetOwner()
		ExitDialog(owner, 1)
	else
		XLMessageBox("设置失败")
	end
end

function OnInitControl(self)
	local owner = self:GetOwner()
	local edit = owner:GetUIObject("edit.main.page")
	
	local shell = XLGetObject("Xunlei.UIEngine.OSShell")
	local url = shell:GetIEMainPage()
	if url then
		edit:SetText(url)
	end
end

function systemsymbol_OnCheck(self)

end

function systemsymbol_OnBeforeClick(self)
	return true
end