/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Labeled;

@DefaultProperty(value="content")
public class TitledPane
extends Labeled {
    private ObjectProperty<Node> content;
    private BooleanProperty expanded = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            this.get();
            TitledPane.this.impl_pseudoClassStateChanged(TitledPane.PSEUDO_CLASS_EXPANDED);
            TitledPane.this.impl_pseudoClassStateChanged(TitledPane.PSEUDO_CLASS_COLLAPSED);
        }

        @Override
        public Object getBean() {
            return TitledPane.this;
        }

        @Override
        public String getName() {
            return TitledPane.PSEUDO_CLASS_EXPANDED;
        }
    };
    private BooleanProperty animated = new StyleableBooleanProperty(true){

        @Override
        public Object getBean() {
            return TitledPane.this;
        }

        @Override
        public String getName() {
            return "animated";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.ANIMATED;
        }
    };
    private BooleanProperty collapsible = new StyleableBooleanProperty(true){

        @Override
        public Object getBean() {
            return TitledPane.this;
        }

        @Override
        public String getName() {
            return "collapsible";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.COLLAPSIBLE;
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "titled-pane";
    private static final String PSEUDO_CLASS_EXPANDED = "expanded";
    private static final String PSEUDO_CLASS_COLLAPSED = "collapsed";
    private static final long EXPANDED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("expanded");
    private static final long COLLAPSED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("collapsed");

    public TitledPane() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public TitledPane(String string, Node node) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setText(string);
        this.setContent(node);
    }

    public final void setContent(Node node) {
        this.contentProperty().set(node);
    }

    public final Node getContent() {
        return this.content == null ? null : (Node)this.content.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        if (this.content == null) {
            this.content = new SimpleObjectProperty<Node>(this, "content");
        }
        return this.content;
    }

    public final void setExpanded(boolean bl) {
        this.expandedProperty().set(bl);
    }

    public final boolean isExpanded() {
        return this.expanded.get();
    }

    public final BooleanProperty expandedProperty() {
        return this.expanded;
    }

    public final void setAnimated(boolean bl) {
        this.animatedProperty().set(bl);
    }

    public final boolean isAnimated() {
        return this.animated.get();
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final void setCollapsible(boolean bl) {
        this.collapsibleProperty().set(bl);
    }

    public final boolean isCollapsible() {
        return this.collapsible.get();
    }

    public final BooleanProperty collapsibleProperty() {
        return this.collapsible;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return TitledPane.impl_CSS_STYLEABLES();
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        return l |= this.isExpanded() ? EXPANDED_PSEUDOCLASS_STATE : COLLAPSED_PSEUDOCLASS_STATE;
    }

    private static class StyleableProperties {
        private static final StyleableProperty<TitledPane, Boolean> COLLAPSIBLE = new StyleableProperty<TitledPane, Boolean>("-fx-collapsible", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(TitledPane titledPane) {
                return titledPane.collapsible == null || !titledPane.collapsible.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(TitledPane titledPane) {
                return titledPane.collapsibleProperty();
            }
        };
        private static final StyleableProperty<TitledPane, Boolean> ANIMATED = new StyleableProperty<TitledPane, Boolean>("-fx-animated", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(TitledPane titledPane) {
                return titledPane.animated == null || !titledPane.animated.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(TitledPane titledPane) {
                return titledPane.animatedProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Labeled.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, COLLAPSIBLE, ANIMATED);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

