/*
 * Decompiled with CFR 0.152.
 */
package javafx.event;

import com.sun.javafx.event.EventUtil;
import java.util.EventObject;
import javafx.event.EventDispatchChain;
import javafx.event.EventTarget;
import javafx.event.EventType;

public class Event
extends EventObject
implements Cloneable {
    public static final EventTarget NULL_SOURCE_TARGET = new EventTarget(){

        @Override
        public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
            return eventDispatchChain;
        }
    };
    public static final EventType<Event> ANY = EventType.ROOT;
    protected EventType<? extends Event> eventType;
    protected EventTarget target;
    protected boolean consumed;

    public Event(EventType<? extends Event> eventType) {
        this(null, null, eventType);
    }

    public Event(Object object, EventTarget eventTarget, EventType<? extends Event> eventType) {
        super(object != null ? object : NULL_SOURCE_TARGET);
        this.target = eventTarget != null ? eventTarget : NULL_SOURCE_TARGET;
        this.eventType = eventType;
    }

    public EventTarget getTarget() {
        return this.target;
    }

    public EventType<? extends Event> getEventType() {
        return this.eventType;
    }

    public Event copyFor(Object object, EventTarget eventTarget) {
        Event event = (Event)this.clone();
        event.source = object != null ? object : NULL_SOURCE_TARGET;
        event.target = eventTarget != null ? eventTarget : NULL_SOURCE_TARGET;
        event.consumed = false;
        return event;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void consume() {
        this.consumed = true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Can't clone Event");
        }
    }

    public static void fireEvent(EventTarget eventTarget, Event event) {
        if (eventTarget == null) {
            throw new NullPointerException("Event target must not be null!");
        }
        if (event == null) {
            throw new NullPointerException("Event must not be null!");
        }
        EventUtil.fireEvent(eventTarget, event);
    }
}

