/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.CSSRuleImpl;
import com.sun.webpane.webkit.dom.CSSValueImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration {
    protected final long peer;

    CSSStyleDeclarationImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static CSSStyleDeclaration create(long peer) {
        if (peer == 0L) {
            return null;
        }
        return new CSSStyleDeclarationImpl(peer);
    }

    public boolean equals(Object that) {
        return that instanceof CSSStyleDeclarationImpl && this.peer == ((CSSStyleDeclarationImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(CSSStyleDeclaration arg) {
        return arg == null ? 0L : ((CSSStyleDeclarationImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    static CSSStyleDeclaration getImpl(long peer) {
        return CSSStyleDeclarationImpl.create(peer);
    }

    @Override
    public String getCssText() {
        return CSSStyleDeclarationImpl.getCssTextImpl(this.getPeer());
    }

    static native String getCssTextImpl(long var0);

    @Override
    public void setCssText(String value) throws DOMException {
        CSSStyleDeclarationImpl.setCssTextImpl(this.getPeer(), value);
    }

    static native void setCssTextImpl(long var0, String var2);

    @Override
    public int getLength() {
        return CSSStyleDeclarationImpl.getLengthImpl(this.getPeer());
    }

    static native int getLengthImpl(long var0);

    @Override
    public CSSRule getParentRule() {
        return CSSRuleImpl.getImpl(CSSStyleDeclarationImpl.getParentRuleImpl(this.getPeer()));
    }

    static native long getParentRuleImpl(long var0);

    @Override
    public String getPropertyValue(String propertyName) {
        return CSSStyleDeclarationImpl.getPropertyValueImpl(this.getPeer(), propertyName);
    }

    static native String getPropertyValueImpl(long var0, String var2);

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        return CSSValueImpl.getImpl(CSSStyleDeclarationImpl.getPropertyCSSValueImpl(this.getPeer(), propertyName));
    }

    static native long getPropertyCSSValueImpl(long var0, String var2);

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        return CSSStyleDeclarationImpl.removePropertyImpl(this.getPeer(), propertyName);
    }

    static native String removePropertyImpl(long var0, String var2);

    @Override
    public String getPropertyPriority(String propertyName) {
        return CSSStyleDeclarationImpl.getPropertyPriorityImpl(this.getPeer(), propertyName);
    }

    static native String getPropertyPriorityImpl(long var0, String var2);

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        CSSStyleDeclarationImpl.setPropertyImpl(this.getPeer(), propertyName, value, priority);
    }

    static native void setPropertyImpl(long var0, String var2, String var3, String var4);

    @Override
    public String item(int index) {
        return CSSStyleDeclarationImpl.itemImpl(this.getPeer(), index);
    }

    static native String itemImpl(long var0, int var2);

    public String getPropertyShorthand(String propertyName) {
        return CSSStyleDeclarationImpl.getPropertyShorthandImpl(this.getPeer(), propertyName);
    }

    static native String getPropertyShorthandImpl(long var0, String var2);

    public boolean isPropertyImplicit(String propertyName) {
        return CSSStyleDeclarationImpl.isPropertyImplicitImpl(this.getPeer(), propertyName);
    }

    static native boolean isPropertyImplicitImpl(long var0, String var2);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            CSSStyleDeclarationImpl.dispose(this.peer);
        }
    }
}

