/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.web.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.web.skin.PopupButton;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class PopupButtonBehavior
extends BehaviorBase<PopupButton> {
    protected static final List<KeyBinding> POPUP_BUTTON_BINDINGS = new ArrayList<KeyBinding>();

    @Override
    protected void callAction(String string) {
        PopupButton popupButton = (PopupButton)this.getControl();
        if ("Close".equals(string)) {
            popupButton.hide();
        } else if ("Open".equals(string)) {
            if (popupButton.isShowing()) {
                popupButton.hide();
            } else {
                popupButton.show();
            }
        } else if (!popupButton.isShowing() && "TraverseDown".equals(string)) {
            popupButton.show();
        } else {
            super.callAction(string);
        }
    }

    public PopupButtonBehavior(PopupButton popupButton) {
        super(popupButton);
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return POPUP_BUTTON_BINDINGS;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        PopupButton popupButton = (PopupButton)this.getControl();
        if (!popupButton.isFocused() && popupButton.isFocusTraversable()) {
            popupButton.requestFocus();
        }
        if (popupButton.isShowing()) {
            popupButton.hide();
        } else {
            popupButton.show();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (((PopupButton)this.getControl()).isShowing() && !((PopupButton)this.getControl()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            ((PopupButton)this.getControl()).hide();
        }
    }

    static {
        POPUP_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_PRESSED, "Open"));
        POPUP_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_PRESSED, "Open"));
        POPUP_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, KeyEvent.KEY_RELEASED, "Close"));
        POPUP_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.CANCEL, KeyEvent.KEY_RELEASED, "Close"));
        POPUP_BUTTON_BINDINGS.addAll(TRAVERSAL_BINDINGS);
    }
}

