/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.scene.control.behavior.PaginationBehavior;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Pagination;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.util.Duration;

public class PaginationSkin
extends SkinBase<Pagination, PaginationBehavior> {
    private static final Duration DURATION = new Duration(125.0);
    private static final double SWIPE_THRESHOLD = 0.3;
    private static final double TOUCH_THRESHOLD = 15.0;
    private Pagination pagination;
    private StackPane currentStackPane;
    private StackPane nextStackPane;
    private Timeline timeline;
    private Rectangle clipRect;
    private NavigationControl navigation;
    private int fromIndex;
    private int previousIndex;
    private int currentIndex;
    private int toIndex;
    private int pageCount;
    private int maxPageIndicatorCount;
    private boolean animate = true;
    private double startTouchPos;
    private double lastTouchPos;
    private long startTouchTime;
    private long lastTouchTime;
    private double touchVelocity;
    private boolean touchThresholdBroken;
    private int touchEventId = -1;
    private boolean nextPageReached = false;
    private boolean setInitialDirection = false;
    private int direction;
    private static final Interpolator interpolator = Interpolator.SPLINE(0.4829, 0.5709, 0.6803, 0.9928);
    private int currentAnimatedIndex;
    private int previousAnimatedIndex;
    private boolean hasPendingAnimation = false;
    private EventHandler<ActionEvent> swipeAnimationEndEventHandler = new EventHandler<ActionEvent>(){

        @Override
        public void handle(ActionEvent actionEvent) {
            PaginationSkin.this.swapPanes();
            PaginationSkin.this.timeline = null;
            if (PaginationSkin.this.hasPendingAnimation) {
                PaginationSkin.this.animateSwitchPage();
                PaginationSkin.this.hasPendingAnimation = false;
            }
        }
    };
    private EventHandler<ActionEvent> clampAnimationEndEventHandler = new EventHandler<ActionEvent>(){

        @Override
        public void handle(ActionEvent actionEvent) {
            PaginationSkin.this.currentStackPane.setTranslateX(0.0);
            PaginationSkin.this.nextStackPane.setTranslateX(0.0);
            PaginationSkin.this.nextStackPane.setVisible(false);
            PaginationSkin.this.timeline = null;
        }
    };
    private BooleanProperty arrowsVisible;
    private BooleanProperty pageInformationVisible;
    private ObjectProperty<Side> pageInformationAlignment;
    private BooleanProperty tooltipVisible;
    private static final Boolean DEFAULT_ARROW_VISIBLE = Boolean.FALSE;
    private static final Boolean DEFAULT_PAGE_INFORMATION_VISIBLE = Boolean.FALSE;
    private static final Side DEFAULT_PAGE_INFORMATION_ALIGNMENT = Side.BOTTOM;
    private static final Boolean DEFAULT_TOOLTIP_VISIBLE = Boolean.FALSE;

    public PaginationSkin(Pagination pagination) {
        super(pagination, new PaginationBehavior(pagination));
        this.setManaged(false);
        this.clipRect = new Rectangle();
        this.setClip(this.clipRect);
        this.pagination = pagination;
        this.currentStackPane = new StackPane();
        this.currentStackPane.getStyleClass().add("page");
        this.nextStackPane = new StackPane();
        this.nextStackPane.getStyleClass().add("page");
        this.nextStackPane.setVisible(false);
        this.resetIndexes(true);
        this.navigation = new NavigationControl();
        this.getChildren().addAll((Node[])new Node[]{this.currentStackPane, this.nextStackPane, this.navigation});
        pagination.maxPageIndicatorCountProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                PaginationSkin.this.resetIndexes(false);
                PaginationSkin.this.navigation.initializePageIndicators();
                PaginationSkin.this.navigation.updatePageIndicators();
            }
        });
        this.registerChangeListener(pagination.pageCountProperty(), "PAGE_COUNT");
        this.registerChangeListener(pagination.pageFactoryProperty(), "PAGE_FACTORY");
        this.initializeSwipeAndTouchHandlers();
    }

    public void selectNext() {
        if (this.getCurrentPageIndex() < this.getPageCount() - 1) {
            this.pagination.setCurrentPageIndex(this.getCurrentPageIndex() + 1);
        }
    }

    public void selectPrevious() {
        if (this.getCurrentPageIndex() > 0) {
            this.pagination.setCurrentPageIndex(this.getCurrentPageIndex() - 1);
        }
    }

    private void initializeSwipeAndTouchHandlers() {
        this.setOnTouchPressed((EventHandler<? super TouchEvent>)new EventHandler<TouchEvent>(){

            @Override
            public void handle(TouchEvent touchEvent) {
                if (PaginationSkin.this.touchEventId == -1) {
                    PaginationSkin.this.touchEventId = touchEvent.getTouchPoint().getId();
                }
                if (PaginationSkin.this.touchEventId != touchEvent.getTouchPoint().getId()) {
                    return;
                }
                PaginationSkin.this.lastTouchPos = (PaginationSkin.this.startTouchPos = touchEvent.getTouchPoint().getX());
                PaginationSkin.this.lastTouchTime = (PaginationSkin.this.startTouchTime = System.currentTimeMillis());
                PaginationSkin.this.touchThresholdBroken = false;
                touchEvent.consume();
            }
        });
        this.setOnTouchMoved((EventHandler<? super TouchEvent>)new EventHandler<TouchEvent>(){

            @Override
            public void handle(TouchEvent touchEvent) {
                if (PaginationSkin.this.touchEventId != touchEvent.getTouchPoint().getId()) {
                    return;
                }
                double d = touchEvent.getTouchPoint().getX() - PaginationSkin.this.lastTouchPos;
                long l = System.currentTimeMillis() - PaginationSkin.this.lastTouchTime;
                PaginationSkin.this.touchVelocity = d / (double)l;
                PaginationSkin.this.lastTouchPos = touchEvent.getTouchPoint().getX();
                PaginationSkin.this.lastTouchTime = System.currentTimeMillis();
                double d2 = touchEvent.getTouchPoint().getX() - PaginationSkin.this.startTouchPos;
                if (!PaginationSkin.this.touchThresholdBroken && Math.abs(d2) > 15.0) {
                    PaginationSkin.this.touchThresholdBroken = true;
                }
                if (PaginationSkin.this.touchThresholdBroken) {
                    double d3 = PaginationSkin.this.getWidth() - (PaginationSkin.this.getInsets().getLeft() + PaginationSkin.this.getInsets().getRight());
                    if (!PaginationSkin.this.setInitialDirection) {
                        PaginationSkin.this.setInitialDirection = true;
                        PaginationSkin.this.direction = d2 < 0.0 ? 1 : -1;
                    }
                    if (d2 < 0.0) {
                        double d4;
                        double d5;
                        if (PaginationSkin.this.direction == -1) {
                            PaginationSkin.this.nextStackPane.getChildren().clear();
                            PaginationSkin.this.direction = 1;
                        }
                        if (Math.abs(d2) <= d3) {
                            d5 = d2;
                            d4 = d3 + d2;
                            PaginationSkin.this.nextPageReached = false;
                        } else {
                            d5 = -d3;
                            d4 = 0.0;
                            PaginationSkin.this.nextPageReached = true;
                        }
                        PaginationSkin.this.currentStackPane.setTranslateX(d5);
                        if (PaginationSkin.this.getCurrentPageIndex() < PaginationSkin.this.getPageCount() - 1) {
                            PaginationSkin.this.createPage(PaginationSkin.this.nextStackPane, PaginationSkin.this.currentIndex + 1);
                            PaginationSkin.this.nextStackPane.setVisible(true);
                            PaginationSkin.this.nextStackPane.setTranslateX(d4);
                        } else {
                            PaginationSkin.this.currentStackPane.setTranslateX(0.0);
                        }
                    } else {
                        double d6;
                        double d7;
                        if (PaginationSkin.this.direction == 1) {
                            PaginationSkin.this.nextStackPane.getChildren().clear();
                            PaginationSkin.this.direction = -1;
                        }
                        if (Math.abs(d2) <= d3) {
                            d7 = d2;
                            d6 = -d3 + d2;
                            PaginationSkin.this.nextPageReached = false;
                        } else {
                            d7 = d3;
                            d6 = 0.0;
                            PaginationSkin.this.nextPageReached = true;
                        }
                        PaginationSkin.this.currentStackPane.setTranslateX(d7);
                        if (PaginationSkin.this.getCurrentPageIndex() != 0) {
                            PaginationSkin.this.createPage(PaginationSkin.this.nextStackPane, PaginationSkin.this.currentIndex - 1);
                            PaginationSkin.this.nextStackPane.setVisible(true);
                            PaginationSkin.this.nextStackPane.setTranslateX(d6);
                        } else {
                            PaginationSkin.this.currentStackPane.setTranslateX(0.0);
                        }
                    }
                }
                touchEvent.consume();
            }
        });
        this.setOnTouchReleased((EventHandler<? super TouchEvent>)new EventHandler<TouchEvent>(){

            @Override
            public void handle(TouchEvent touchEvent) {
                if (PaginationSkin.this.touchEventId != touchEvent.getTouchPoint().getId()) {
                    return;
                }
                PaginationSkin.this.touchEventId = -1;
                PaginationSkin.this.setInitialDirection = false;
                if (PaginationSkin.this.touchThresholdBroken) {
                    double d = touchEvent.getTouchPoint().getX() - PaginationSkin.this.startTouchPos;
                    long l = System.currentTimeMillis() - PaginationSkin.this.startTouchTime;
                    boolean bl = l < 300L;
                    double d2 = bl ? d / (double)l : PaginationSkin.this.touchVelocity;
                    double d3 = d2 * 500.0;
                    double d4 = PaginationSkin.this.getWidth() - (PaginationSkin.this.getInsets().getLeft() + PaginationSkin.this.getInsets().getRight());
                    double d5 = Math.abs(d3 / d4);
                    double d6 = Math.abs(d / d4);
                    if (d5 > 0.3 || d6 > 0.3) {
                        if (PaginationSkin.this.startTouchPos > touchEvent.getTouchPoint().getX()) {
                            PaginationSkin.this.selectNext();
                        } else {
                            PaginationSkin.this.selectPrevious();
                        }
                    } else {
                        PaginationSkin.this.animateClamping(PaginationSkin.this.startTouchPos > touchEvent.getTouchPoint().getSceneX());
                    }
                }
                touchEvent.consume();
            }
        });
    }

    private void resetIndexes(boolean bl) {
        boolean bl2;
        this.maxPageIndicatorCount = this.getMaxPageIndicatorCount();
        this.pageCount = this.getPageCount();
        if (this.pageCount > this.maxPageIndicatorCount) {
            this.pageCount = this.maxPageIndicatorCount;
        }
        this.fromIndex = 0;
        this.previousIndex = 0;
        this.currentIndex = bl ? this.getCurrentPageIndex() : 0;
        this.toIndex = this.fromIndex + (this.pageCount - 1);
        if (this.pageCount == Integer.MAX_VALUE && this.maxPageIndicatorCount == Integer.MAX_VALUE) {
            this.toIndex = 0;
        }
        if (bl2 = this.animate) {
            this.animate = false;
        }
        this.currentStackPane.getChildren().clear();
        this.nextStackPane.getChildren().clear();
        this.pagination.setCurrentPageIndex(this.currentIndex);
        this.createPage(this.currentStackPane, this.currentIndex);
        if (bl2) {
            this.animate = true;
        }
    }

    private boolean createPage(StackPane stackPane, int n) {
        if (this.pagination.getPageFactory() != null && stackPane.getChildren().isEmpty()) {
            Node node = this.pagination.getPageFactory().call(n);
            if (node != null) {
                stackPane.getChildren().setAll((Node[])new Node[]{node});
                return true;
            }
            boolean bl = this.animate;
            if (bl) {
                this.animate = false;
            }
            if (this.pagination.getPageFactory().call(this.previousIndex) != null) {
                this.pagination.setCurrentPageIndex(this.previousIndex);
            } else {
                this.pagination.setCurrentPageIndex(0);
            }
            if (bl) {
                this.animate = true;
            }
            return false;
        }
        return false;
    }

    private int getPageCount() {
        if (((Pagination)this.getSkinnable()).getPageCount() < 1) {
            return 1;
        }
        return ((Pagination)this.getSkinnable()).getPageCount();
    }

    private int getMaxPageIndicatorCount() {
        return ((Pagination)this.getSkinnable()).getMaxPageIndicatorCount();
    }

    private int getCurrentPageIndex() {
        return ((Pagination)this.getSkinnable()).getCurrentPageIndex();
    }

    private void animateSwitchPage() {
        if (this.timeline != null) {
            this.timeline.setRate(8.0);
            this.hasPendingAnimation = true;
            return;
        }
        if (!this.nextStackPane.isVisible() && !this.createPage(this.nextStackPane, this.currentAnimatedIndex)) {
            return;
        }
        if (this.nextPageReached) {
            this.swapPanes();
            this.nextPageReached = false;
            return;
        }
        this.nextStackPane.setCache(true);
        this.currentStackPane.setCache(true);
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                boolean bl2 = bl = PaginationSkin.this.nextStackPane.getTranslateX() != 0.0;
                if (PaginationSkin.this.currentAnimatedIndex > PaginationSkin.this.previousIndex) {
                    if (!bl) {
                        PaginationSkin.this.nextStackPane.setTranslateX(PaginationSkin.this.currentStackPane.getWidth());
                    }
                    PaginationSkin.this.nextStackPane.setVisible(true);
                    PaginationSkin.this.timeline = new Timeline();
                    KeyFrame keyFrame = new KeyFrame(Duration.millis(0.0), new KeyValue(PaginationSkin.this.currentStackPane.translateXProperty(), bl ? PaginationSkin.this.currentStackPane.getTranslateX() : 0.0, interpolator), new KeyValue(PaginationSkin.this.nextStackPane.translateXProperty(), bl ? PaginationSkin.this.nextStackPane.getTranslateX() : PaginationSkin.this.currentStackPane.getWidth(), interpolator));
                    KeyFrame keyFrame2 = new KeyFrame(DURATION, PaginationSkin.this.swipeAnimationEndEventHandler, new KeyValue(PaginationSkin.this.currentStackPane.translateXProperty(), -PaginationSkin.this.currentStackPane.getWidth(), interpolator), new KeyValue(PaginationSkin.this.nextStackPane.translateXProperty(), 0, interpolator));
                    PaginationSkin.this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame, keyFrame2});
                    PaginationSkin.this.timeline.play();
                } else {
                    if (!bl) {
                        PaginationSkin.this.nextStackPane.setTranslateX(-PaginationSkin.this.currentStackPane.getWidth());
                    }
                    PaginationSkin.this.nextStackPane.setVisible(true);
                    PaginationSkin.this.timeline = new Timeline();
                    KeyFrame keyFrame = new KeyFrame(Duration.millis(0.0), new KeyValue(PaginationSkin.this.currentStackPane.translateXProperty(), bl ? PaginationSkin.this.currentStackPane.getTranslateX() : 0.0, interpolator), new KeyValue(PaginationSkin.this.nextStackPane.translateXProperty(), bl ? PaginationSkin.this.nextStackPane.getTranslateX() : -PaginationSkin.this.currentStackPane.getWidth(), interpolator));
                    KeyFrame keyFrame3 = new KeyFrame(DURATION, PaginationSkin.this.swipeAnimationEndEventHandler, new KeyValue(PaginationSkin.this.currentStackPane.translateXProperty(), PaginationSkin.this.currentStackPane.getWidth(), interpolator), new KeyValue(PaginationSkin.this.nextStackPane.translateXProperty(), 0, interpolator));
                    PaginationSkin.this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame, keyFrame3});
                    PaginationSkin.this.timeline.play();
                }
            }
        });
    }

    private void swapPanes() {
        StackPane stackPane = this.currentStackPane;
        this.currentStackPane = this.nextStackPane;
        this.nextStackPane = stackPane;
        this.currentStackPane.setTranslateX(0.0);
        this.currentStackPane.setCache(false);
        this.nextStackPane.setTranslateX(0.0);
        this.nextStackPane.setCache(false);
        this.nextStackPane.setVisible(false);
        this.nextStackPane.getChildren().clear();
    }

    private void animateClamping(boolean bl) {
        if (bl) {
            this.timeline = new Timeline();
            KeyFrame keyFrame = new KeyFrame(Duration.millis(0.0), new KeyValue(this.currentStackPane.translateXProperty(), this.currentStackPane.getTranslateX(), interpolator), new KeyValue(this.nextStackPane.translateXProperty(), this.nextStackPane.getTranslateX(), interpolator));
            KeyFrame keyFrame2 = new KeyFrame(DURATION, this.clampAnimationEndEventHandler, new KeyValue(this.currentStackPane.translateXProperty(), 0, interpolator), new KeyValue(this.nextStackPane.translateXProperty(), this.currentStackPane.getWidth(), interpolator));
            this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame, keyFrame2});
            this.timeline.play();
        } else {
            this.timeline = new Timeline();
            KeyFrame keyFrame = new KeyFrame(Duration.millis(0.0), new KeyValue(this.currentStackPane.translateXProperty(), this.currentStackPane.getTranslateX(), interpolator), new KeyValue(this.nextStackPane.translateXProperty(), this.nextStackPane.getTranslateX(), interpolator));
            KeyFrame keyFrame3 = new KeyFrame(DURATION, this.clampAnimationEndEventHandler, new KeyValue(this.currentStackPane.translateXProperty(), 0, interpolator), new KeyValue(this.nextStackPane.translateXProperty(), -this.currentStackPane.getWidth(), interpolator));
            this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame, keyFrame3});
            this.timeline.play();
        }
    }

    public final void setArrowsVisible(boolean bl) {
        this.arrowsVisibleProperty().set(bl);
    }

    public final boolean isArrowsVisible() {
        return this.arrowsVisible == null ? DEFAULT_ARROW_VISIBLE.booleanValue() : this.arrowsVisible.get();
    }

    public final BooleanProperty arrowsVisibleProperty() {
        if (this.arrowsVisible == null) {
            this.arrowsVisible = new StyleableBooleanProperty(DEFAULT_ARROW_VISIBLE){

                @Override
                protected void invalidated() {
                    PaginationSkin.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ARROWS_VISIBLE;
                }

                @Override
                public Object getBean() {
                    return PaginationSkin.this;
                }

                @Override
                public String getName() {
                    return "arrowVisible";
                }
            };
        }
        return this.arrowsVisible;
    }

    public final void setPageInformationVisible(boolean bl) {
        this.pageInformationVisibleProperty().set(bl);
    }

    public final boolean isPageInformationVisible() {
        return this.pageInformationVisible == null ? DEFAULT_PAGE_INFORMATION_VISIBLE.booleanValue() : this.pageInformationVisible.get();
    }

    public final BooleanProperty pageInformationVisibleProperty() {
        if (this.pageInformationVisible == null) {
            this.pageInformationVisible = new StyleableBooleanProperty(DEFAULT_PAGE_INFORMATION_VISIBLE){

                @Override
                protected void invalidated() {
                    PaginationSkin.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.PAGE_INFORMATION_VISIBLE;
                }

                @Override
                public Object getBean() {
                    return PaginationSkin.this;
                }

                @Override
                public String getName() {
                    return "pageInformationVisible";
                }
            };
        }
        return this.pageInformationVisible;
    }

    public final void setPageInformationAlignment(Side side) {
        this.pageInformationAlignmentProperty().set(side);
    }

    public final Side getPageInformationAlignment() {
        return this.pageInformationAlignment == null ? DEFAULT_PAGE_INFORMATION_ALIGNMENT : (Side)((Object)this.pageInformationAlignment.get());
    }

    public final ObjectProperty<Side> pageInformationAlignmentProperty() {
        if (this.pageInformationAlignment == null) {
            this.pageInformationAlignment = new StyleableObjectProperty<Side>(Side.BOTTOM){

                @Override
                protected void invalidated() {
                    PaginationSkin.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.PAGE_INFORMATION_ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return PaginationSkin.this;
                }

                @Override
                public String getName() {
                    return "pageInformationAlignment";
                }
            };
        }
        return this.pageInformationAlignment;
    }

    public final void setTooltipVisible(boolean bl) {
        this.tooltipVisibleProperty().set(bl);
    }

    public final boolean isTooltipVisible() {
        return this.tooltipVisible == null ? DEFAULT_TOOLTIP_VISIBLE.booleanValue() : this.tooltipVisible.get();
    }

    public final BooleanProperty tooltipVisibleProperty() {
        if (this.tooltipVisible == null) {
            this.tooltipVisible = new StyleableBooleanProperty(DEFAULT_TOOLTIP_VISIBLE){

                @Override
                protected void invalidated() {
                    PaginationSkin.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.TOOLTIP_VISIBLE;
                }

                @Override
                public Object getBean() {
                    return PaginationSkin.this;
                }

                @Override
                public String getName() {
                    return "tooltipVisible";
                }
            };
        }
        return this.tooltipVisible;
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "PAGE_FACTORY") {
            if (this.animate && this.timeline != null) {
                this.timeline.setRate(8.0);
                this.timeline.setOnFinished(new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent actionEvent) {
                        PaginationSkin.this.resetIndexes(false);
                        PaginationSkin.this.navigation.initializePageIndicators();
                        PaginationSkin.this.navigation.updatePageIndicators();
                    }
                });
                return;
            }
            this.resetIndexes(false);
            this.navigation.initializePageIndicators();
            this.navigation.updatePageIndicators();
        } else if (string == "PAGE_COUNT") {
            this.resetIndexes(false);
            this.navigation.initializePageIndicators();
            this.navigation.updatePageIndicators();
        }
        this.requestLayout();
    }

    @Override
    protected void setWidth(double d) {
        super.setWidth(d);
        this.clipRect.setWidth(d);
    }

    @Override
    protected void setHeight(double d) {
        super.setHeight(d);
        this.clipRect.setHeight(d);
    }

    @Override
    protected double computeMinWidth(double d) {
        double d2 = this.snapSpace(this.getInsets().getLeft());
        double d3 = this.snapSpace(this.getInsets().getRight());
        double d4 = this.navigation.isVisible() ? this.snapSize(this.navigation.minWidth(d)) : 0.0;
        return d2 + Math.max(this.currentStackPane.minWidth(d), d4) + d3;
    }

    @Override
    protected double computeMinHeight(double d) {
        double d2 = this.snapSpace(this.getInsets().getTop());
        double d3 = this.snapSpace(this.getInsets().getBottom());
        double d4 = this.navigation.isVisible() ? this.snapSize(this.navigation.minHeight(d)) : 0.0;
        return d2 + this.currentStackPane.minHeight(d) + d4 + d3;
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = this.snapSpace(this.getInsets().getLeft());
        double d3 = this.snapSpace(this.getInsets().getRight());
        double d4 = this.navigation.isVisible() ? this.snapSize(this.navigation.prefWidth(d)) : 0.0;
        return d2 + Math.max(this.currentStackPane.prefWidth(d), d4) + d3;
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = this.snapSpace(this.getInsets().getTop());
        double d3 = this.snapSpace(this.getInsets().getBottom());
        double d4 = this.navigation.isVisible() ? this.snapSize(this.navigation.prefHeight(d)) : 0.0;
        return d2 + this.currentStackPane.prefHeight(d) + d4 + d3;
    }

    @Override
    protected void layoutChildren() {
        double d = this.snapSpace(this.getInsets().getLeft());
        double d2 = this.snapSpace(this.getInsets().getRight());
        double d3 = this.snapSpace(this.getInsets().getTop());
        double d4 = this.snapSpace(this.getInsets().getBottom());
        double d5 = this.snapSize(this.getWidth() - (d + d2));
        double d6 = this.snapSize(this.getHeight() - (d3 + d4));
        double d7 = this.navigation.isVisible() ? this.snapSize(this.navigation.prefHeight(-1.0)) : 0.0;
        double d8 = this.snapSize(d6 - d7);
        this.layoutInArea(this.currentStackPane, d, d3, d5, d8, 0.0, HPos.CENTER, VPos.CENTER);
        this.layoutInArea(this.nextStackPane, d, d3, d5, d8, 0.0, HPos.CENTER, VPos.CENTER);
        this.layoutInArea(this.navigation, d, d8, d5, d7, 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return PaginationSkin.impl_CSS_STYLEABLES();
    }

    static /* synthetic */ Boolean access$4700() {
        return DEFAULT_ARROW_VISIBLE;
    }

    static /* synthetic */ Boolean access$4900() {
        return DEFAULT_PAGE_INFORMATION_VISIBLE;
    }

    static /* synthetic */ Side access$5100() {
        return DEFAULT_PAGE_INFORMATION_ALIGNMENT;
    }

    static /* synthetic */ Boolean access$5300() {
        return DEFAULT_TOOLTIP_VISIBLE;
    }

    private static class StyleableProperties {
        private static final StyleableProperty<PaginationSkin, Boolean> ARROWS_VISIBLE = new StyleableProperty<PaginationSkin, Boolean>("-fx-arrows-visible", (StyleConverter)BooleanConverter.getInstance(), PaginationSkin.access$4700()){

            @Override
            public boolean isSettable(PaginationSkin paginationSkin) {
                return paginationSkin.arrowsVisible == null || !paginationSkin.arrowsVisible.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(PaginationSkin paginationSkin) {
                return paginationSkin.arrowsVisibleProperty();
            }
        };
        private static final StyleableProperty<PaginationSkin, Boolean> PAGE_INFORMATION_VISIBLE = new StyleableProperty<PaginationSkin, Boolean>("-fx-page-information-visible", (StyleConverter)BooleanConverter.getInstance(), PaginationSkin.access$4900()){

            @Override
            public boolean isSettable(PaginationSkin paginationSkin) {
                return paginationSkin.pageInformationVisible == null || !paginationSkin.pageInformationVisible.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(PaginationSkin paginationSkin) {
                return paginationSkin.pageInformationVisibleProperty();
            }
        };
        private static final StyleableProperty<PaginationSkin, Side> PAGE_INFORMATION_ALIGNMENT = new StyleableProperty<PaginationSkin, Side>("-fx-page-information-alignment", new EnumConverter(Side.class), PaginationSkin.access$5100()){

            @Override
            public boolean isSettable(PaginationSkin paginationSkin) {
                return paginationSkin.pageInformationAlignment == null || !paginationSkin.pageInformationAlignment.isBound();
            }

            @Override
            public WritableValue<Side> getWritableValue(PaginationSkin paginationSkin) {
                return paginationSkin.pageInformationAlignmentProperty();
            }
        };
        private static final StyleableProperty<PaginationSkin, Boolean> TOOLTIP_VISIBLE = new StyleableProperty<PaginationSkin, Boolean>("-fx-tooltip-visible", (StyleConverter)BooleanConverter.getInstance(), PaginationSkin.access$5300()){

            @Override
            public boolean isSettable(PaginationSkin paginationSkin) {
                return paginationSkin.tooltipVisible == null || !paginationSkin.tooltipVisible.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(PaginationSkin paginationSkin) {
                return paginationSkin.tooltipVisibleProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(SkinBase.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ARROWS_VISIBLE, PAGE_INFORMATION_VISIBLE, PAGE_INFORMATION_ALIGNMENT, TOOLTIP_VISIBLE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    class IndicatorButton
    extends ToggleButton {
        private int pageNumber;

        public IndicatorButton(int n) {
            this.pageNumber = n;
            this.setFocusTraversable(false);
            this.setIndicatorType();
            this.setTooltipVisible(PaginationSkin.this.isTooltipVisible());
            ((Pagination)PaginationSkin.this.getSkinnable()).getStyleClass().addListener(new ListChangeListener<String>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends String> change) {
                    IndicatorButton.this.setIndicatorType();
                }
            });
            this.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    int n = PaginationSkin.this.getCurrentPageIndex();
                    if (n != IndicatorButton.this.pageNumber) {
                        PaginationSkin.this.pagination.setCurrentPageIndex(IndicatorButton.this.pageNumber);
                        IndicatorButton.this.requestLayout();
                    }
                }
            });
            PaginationSkin.this.tooltipVisibleProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    IndicatorButton.this.setTooltipVisible(bl2);
                }
            });
        }

        private void setIndicatorType() {
            if (((Pagination)PaginationSkin.this.getSkinnable()).getStyleClass().contains("bullet")) {
                this.getStyleClass().remove("number-button");
                this.getStyleClass().add("bullet-button");
                this.setText(null);
            } else {
                this.getStyleClass().remove("bullet-button");
                this.getStyleClass().add("number-button");
                this.setText(Integer.toString(this.pageNumber + 1));
            }
        }

        private void setTooltipVisible(boolean bl) {
            if (bl) {
                this.setTooltip(new Tooltip(Integer.toString(this.pageNumber + 1)));
            } else {
                this.setTooltip(null);
            }
        }

        public int getPageNumber() {
            return this.pageNumber;
        }

        @Override
        public void fire() {
            if (this.getToggleGroup() == null || !this.isSelected()) {
                super.fire();
            }
        }
    }

    class NavigationControl
    extends StackPane {
        private HBox controlBox;
        private Button leftArrowButton;
        private StackPane leftArrow;
        private Button rightArrowButton;
        private StackPane rightArrow;
        private ToggleGroup indicatorButtons;
        private Label pageInformation;
        private double previousWidth = -1.0;
        private double minButtonSize = -1.0;
        private int previousIndicatorCount = 0;

        public NavigationControl() {
            this.getStyleClass().setAll((String[])new String[]{"pagination-control"});
            this.controlBox = new HBox();
            this.controlBox.getStyleClass().add("control-box");
            this.leftArrowButton = new Button();
            this.minButtonSize = this.leftArrowButton.getFont().getSize() * 2.0;
            this.leftArrowButton.fontProperty().addListener(new ChangeListener<Font>(){

                @Override
                public void changed(ObservableValue<? extends Font> observableValue, Font font, Font font2) {
                    NavigationControl.this.minButtonSize = font2.getSize() * 2.0;
                    for (Node node : NavigationControl.this.controlBox.getChildren()) {
                        ((Control)node).setMinSize(NavigationControl.this.minButtonSize, NavigationControl.this.minButtonSize);
                    }
                    NavigationControl.this.requestLayout();
                }
            });
            this.leftArrowButton.setMinSize(this.minButtonSize, this.minButtonSize);
            this.leftArrowButton.getStyleClass().add("left-arrow-button");
            this.leftArrowButton.setFocusTraversable(false);
            HBox.setMargin(this.leftArrowButton, new Insets(0.0, 4.0, 0.0, 0.0));
            this.leftArrow = new StackPane();
            this.leftArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            this.leftArrowButton.setGraphic(this.leftArrow);
            this.leftArrow.getStyleClass().add("left-arrow");
            this.rightArrowButton = new Button();
            this.rightArrowButton.setMinSize(this.minButtonSize, this.minButtonSize);
            this.rightArrowButton.getStyleClass().add("right-arrow-button");
            this.rightArrowButton.setFocusTraversable(false);
            HBox.setMargin(this.rightArrowButton, new Insets(0.0, 0.0, 0.0, 4.0));
            this.rightArrow = new StackPane();
            this.rightArrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            this.rightArrowButton.setGraphic(this.rightArrow);
            this.rightArrow.getStyleClass().add("right-arrow");
            this.indicatorButtons = new ToggleGroup();
            this.pageInformation = new Label();
            this.pageInformation.getStyleClass().add("page-information");
            this.getChildren().addAll((Node[])new Node[]{this.controlBox, this.pageInformation});
            this.initializeNavigationHandlers();
            this.initializePageIndicators();
            this.updatePageIndex();
        }

        private void initializeNavigationHandlers() {
            this.leftArrowButton.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    PaginationSkin.this.selectPrevious();
                    NavigationControl.this.requestLayout();
                }
            });
            this.rightArrowButton.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    PaginationSkin.this.selectNext();
                    NavigationControl.this.requestLayout();
                }
            });
            PaginationSkin.this.pagination.currentPageIndexProperty().addListener(new ChangeListener<Number>(){

                @Override
                public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                    PaginationSkin.this.previousIndex = number.intValue();
                    PaginationSkin.this.currentIndex = number2.intValue();
                    NavigationControl.this.updatePageIndex();
                    if (PaginationSkin.this.animate) {
                        PaginationSkin.this.currentAnimatedIndex = PaginationSkin.this.currentIndex;
                        PaginationSkin.this.animateSwitchPage();
                    } else {
                        PaginationSkin.this.createPage(PaginationSkin.this.currentStackPane, PaginationSkin.this.currentIndex);
                    }
                }
            });
        }

        private void initializePageIndicators() {
            this.previousIndicatorCount = 0;
            this.controlBox.getChildren().clear();
            this.indicatorButtons.getToggles().clear();
            this.controlBox.getChildren().add(this.leftArrowButton);
            for (int i = PaginationSkin.this.fromIndex; i <= PaginationSkin.this.toIndex; ++i) {
                IndicatorButton indicatorButton = new IndicatorButton(i);
                indicatorButton.setMinSize(this.minButtonSize, this.minButtonSize);
                indicatorButton.setToggleGroup(this.indicatorButtons);
                this.controlBox.getChildren().add(indicatorButton);
            }
            this.controlBox.getChildren().add(this.rightArrowButton);
        }

        private void updatePageIndicators() {
            for (int i = 0; i < this.indicatorButtons.getToggles().size(); ++i) {
                IndicatorButton indicatorButton = (IndicatorButton)this.indicatorButtons.getToggles().get(i);
                if (indicatorButton.getPageNumber() != PaginationSkin.this.currentIndex) continue;
                indicatorButton.setSelected(true);
                this.updatePageInformation();
                break;
            }
        }

        private void updatePageIndex() {
            if (PaginationSkin.this.pageCount == PaginationSkin.this.maxPageIndicatorCount && this.changePageSet()) {
                this.initializePageIndicators();
            }
            this.updatePageIndicators();
            this.requestLayout();
        }

        private void updatePageInformation() {
            String string = Integer.toString(PaginationSkin.this.currentIndex + 1);
            String string2 = PaginationSkin.this.getPageCount() == Integer.MAX_VALUE ? "..." : Integer.toString(PaginationSkin.this.getPageCount());
            this.pageInformation.setText(string + "/" + string2);
        }

        private void layoutPageIndicators() {
            int n;
            double d = this.snapSpace(this.getInsets().getLeft());
            double d2 = this.snapSpace(this.getInsets().getRight());
            double d3 = this.snapSize(this.getWidth()) - (d + d2);
            double d4 = this.snapSpace(this.controlBox.getInsets().getLeft());
            double d5 = this.snapSpace(this.controlBox.getInsets().getRight());
            double d6 = this.snapSize(Utils.boundedSize(this.leftArrowButton.prefWidth(-1.0), this.leftArrowButton.minWidth(-1.0), this.leftArrowButton.maxWidth(-1.0)));
            double d7 = this.snapSize(Utils.boundedSize(this.rightArrowButton.prefWidth(-1.0), this.rightArrowButton.minWidth(-1.0), this.rightArrowButton.maxWidth(-1.0)));
            double d8 = this.snapSize(this.controlBox.getSpacing());
            double d9 = d3 - (d4 + d6 + d8 + d7 + d5);
            if (PaginationSkin.this.isPageInformationVisible() && (Side.LEFT.equals((Object)PaginationSkin.this.getPageInformationAlignment()) || Side.RIGHT.equals((Object)PaginationSkin.this.getPageInformationAlignment()))) {
                d9 -= this.snapSize(this.pageInformation.prefWidth(-1.0));
            }
            double d10 = 0.0;
            int n2 = 0;
            for (n = 0; n < PaginationSkin.this.getMaxPageIndicatorCount(); ++n) {
                int n3 = n < this.indicatorButtons.getToggles().size() ? n : this.indicatorButtons.getToggles().size() - 1;
                double d11 = this.minButtonSize;
                if (n3 != -1) {
                    IndicatorButton indicatorButton = (IndicatorButton)this.indicatorButtons.getToggles().get(n3);
                    d11 = this.snapSize(Utils.boundedSize(indicatorButton.prefWidth(-1.0), indicatorButton.minWidth(-1.0), indicatorButton.maxWidth(-1.0)));
                }
                if ((d10 += d11 + this.controlBox.getSpacing()) >= d9) break;
                ++n2;
            }
            if (n2 != this.previousIndicatorCount) {
                if (n2 < PaginationSkin.this.getMaxPageIndicatorCount()) {
                    PaginationSkin.this.maxPageIndicatorCount = n2;
                } else if (n2 >= PaginationSkin.this.getMaxPageIndicatorCount()) {
                    PaginationSkin.this.maxPageIndicatorCount = PaginationSkin.this.getMaxPageIndicatorCount();
                } else {
                    PaginationSkin.this.maxPageIndicatorCount = PaginationSkin.this.toIndex - PaginationSkin.this.fromIndex;
                }
                if (PaginationSkin.this.pageCount > PaginationSkin.this.maxPageIndicatorCount) {
                    PaginationSkin.this.pageCount = PaginationSkin.this.maxPageIndicatorCount;
                    n = PaginationSkin.this.maxPageIndicatorCount - 1;
                } else if (n2 > PaginationSkin.this.getPageCount()) {
                    PaginationSkin.this.pageCount = PaginationSkin.this.getPageCount();
                    n = PaginationSkin.this.getPageCount() - 1;
                } else {
                    PaginationSkin.this.pageCount = n2;
                    n = n2 - 1;
                }
                if (PaginationSkin.this.currentIndex >= PaginationSkin.this.toIndex) {
                    PaginationSkin.this.toIndex = PaginationSkin.this.currentIndex;
                    PaginationSkin.this.fromIndex = PaginationSkin.this.toIndex - n;
                } else if (PaginationSkin.this.currentIndex <= PaginationSkin.this.fromIndex) {
                    PaginationSkin.this.fromIndex = PaginationSkin.this.currentIndex;
                    PaginationSkin.this.toIndex = PaginationSkin.this.fromIndex + n;
                } else {
                    PaginationSkin.this.toIndex = PaginationSkin.this.fromIndex + n;
                }
                if (PaginationSkin.this.toIndex > PaginationSkin.this.getPageCount() - 1) {
                    PaginationSkin.this.toIndex = PaginationSkin.this.getPageCount() - 1;
                }
                if (PaginationSkin.this.fromIndex < 0) {
                    PaginationSkin.this.fromIndex = 0;
                    PaginationSkin.this.toIndex = PaginationSkin.this.fromIndex + n;
                }
                this.initializePageIndicators();
                this.updatePageIndicators();
                this.previousIndicatorCount = n2;
            }
        }

        private boolean changePageSet() {
            int n = this.indexToIndicatorButtonsIndex(PaginationSkin.this.currentIndex);
            int n2 = PaginationSkin.this.maxPageIndicatorCount - 1;
            if (PaginationSkin.this.previousIndex < PaginationSkin.this.currentIndex && n == 0 && n2 != 0 && n % n2 == 0) {
                PaginationSkin.this.fromIndex = PaginationSkin.this.currentIndex;
                PaginationSkin.this.toIndex = PaginationSkin.this.fromIndex + n2;
            } else if (PaginationSkin.this.currentIndex < PaginationSkin.this.previousIndex && n == n2 && n2 != 0 && n % n2 == 0) {
                PaginationSkin.this.toIndex = PaginationSkin.this.currentIndex;
                PaginationSkin.this.fromIndex = PaginationSkin.this.toIndex - n2;
            } else if (PaginationSkin.this.currentIndex < PaginationSkin.this.fromIndex || PaginationSkin.this.currentIndex > PaginationSkin.this.toIndex) {
                PaginationSkin.this.fromIndex = PaginationSkin.this.currentIndex - n;
                PaginationSkin.this.toIndex = PaginationSkin.this.fromIndex + n2;
            } else {
                return false;
            }
            if (PaginationSkin.this.toIndex > PaginationSkin.this.getPageCount() - 1) {
                if (PaginationSkin.this.fromIndex > PaginationSkin.this.getPageCount() - 1) {
                    return false;
                }
                PaginationSkin.this.toIndex = PaginationSkin.this.getPageCount() - 1;
            }
            if (PaginationSkin.this.fromIndex < 0) {
                PaginationSkin.this.fromIndex = 0;
                PaginationSkin.this.toIndex = PaginationSkin.this.fromIndex + n2;
            }
            return true;
        }

        private int indexToIndicatorButtonsIndex(int n) {
            if (n >= PaginationSkin.this.fromIndex && n <= PaginationSkin.this.toIndex) {
                return n - PaginationSkin.this.fromIndex;
            }
            int n2 = 0;
            int n3 = PaginationSkin.this.fromIndex;
            int n4 = PaginationSkin.this.toIndex;
            if (PaginationSkin.this.currentIndex > PaginationSkin.this.previousIndex) {
                while (n3 < PaginationSkin.this.getPageCount() && n4 < PaginationSkin.this.getPageCount()) {
                    if (n >= (n3 += n2) && n <= (n4 += n2)) {
                        if (n == n3) {
                            return 0;
                        }
                        if (n == n4) {
                            return PaginationSkin.this.maxPageIndicatorCount - 1;
                        }
                        return n - n3;
                    }
                    n2 += PaginationSkin.this.maxPageIndicatorCount;
                }
            } else {
                while (n3 > 0 && n4 > 0) {
                    if (n >= (n3 -= n2) && n <= (n4 -= n2)) {
                        if (n == n3) {
                            return 0;
                        }
                        if (n == n4) {
                            return PaginationSkin.this.maxPageIndicatorCount - 1;
                        }
                        return n - n3;
                    }
                    n2 += PaginationSkin.this.maxPageIndicatorCount;
                }
            }
            return PaginationSkin.this.maxPageIndicatorCount - 1;
        }

        private Pos sideToPos(Side side) {
            if (Side.TOP.equals((Object)side)) {
                return Pos.TOP_CENTER;
            }
            if (Side.RIGHT.equals((Object)side)) {
                return Pos.CENTER_RIGHT;
            }
            if (Side.BOTTOM.equals((Object)side)) {
                return Pos.BOTTOM_CENTER;
            }
            return Pos.CENTER_LEFT;
        }

        @Override
        protected double computeMinWidth(double d) {
            double d2 = this.snapSpace(this.getInsets().getLeft());
            double d3 = this.snapSpace(this.getInsets().getRight());
            double d4 = this.snapSize(Utils.boundedSize(this.leftArrowButton.prefWidth(-1.0), this.leftArrowButton.minWidth(-1.0), this.leftArrowButton.maxWidth(-1.0)));
            double d5 = this.snapSize(Utils.boundedSize(this.rightArrowButton.prefWidth(-1.0), this.rightArrowButton.minWidth(-1.0), this.rightArrowButton.maxWidth(-1.0)));
            double d6 = this.snapSize(this.controlBox.getSpacing());
            double d7 = 0.0;
            Side side = PaginationSkin.this.getPageInformationAlignment();
            if (Side.LEFT.equals((Object)side) || Side.RIGHT.equals((Object)side)) {
                d7 = this.snapSize(this.pageInformation.prefWidth(-1.0));
            }
            return d2 + d4 + d6 + d5 + d3 + d7;
        }

        @Override
        protected double computeMinHeight(double d) {
            return this.computePrefHeight(d);
        }

        @Override
        protected double computePrefWidth(double d) {
            double d2 = this.snapSpace(this.getInsets().getLeft());
            double d3 = this.snapSpace(this.getInsets().getRight());
            double d4 = this.snapSize(this.controlBox.prefWidth(d));
            double d5 = 0.0;
            Side side = PaginationSkin.this.getPageInformationAlignment();
            if (Side.LEFT.equals((Object)side) || Side.RIGHT.equals((Object)side)) {
                d5 = this.snapSize(this.pageInformation.prefWidth(-1.0));
            }
            return d2 + d4 + d3 + d5;
        }

        @Override
        protected double computePrefHeight(double d) {
            double d2 = this.snapSpace(this.getInsets().getTop());
            double d3 = this.snapSpace(this.getInsets().getBottom());
            double d4 = this.snapSize(this.controlBox.prefHeight(d));
            double d5 = 0.0;
            Side side = PaginationSkin.this.getPageInformationAlignment();
            if (Side.TOP.equals((Object)side) || Side.BOTTOM.equals((Object)side)) {
                d5 = this.snapSize(this.pageInformation.prefHeight(-1.0));
            }
            return d2 + d4 + d5 + d3;
        }

        @Override
        protected void layoutChildren() {
            double d = this.snapSpace(this.getInsets().getTop());
            double d2 = this.snapSpace(this.getInsets().getBottom());
            double d3 = this.snapSpace(this.getInsets().getLeft());
            double d4 = this.snapSpace(this.getInsets().getRight());
            double d5 = this.snapSize(this.getWidth()) - (d3 + d4);
            double d6 = this.snapSize(this.getHeight()) - (d + d2);
            double d7 = this.snapSize(this.controlBox.prefWidth(-1.0));
            double d8 = this.snapSize(this.controlBox.prefHeight(-1.0));
            double d9 = this.snapSize(this.pageInformation.prefWidth(-1.0));
            double d10 = this.snapSize(this.pageInformation.prefHeight(-1.0));
            this.leftArrowButton.setDisable(false);
            this.rightArrowButton.setDisable(false);
            if (PaginationSkin.this.currentIndex == 0) {
                this.leftArrowButton.setDisable(true);
            }
            if (PaginationSkin.this.currentIndex == PaginationSkin.this.getPageCount() - 1) {
                this.rightArrowButton.setDisable(true);
            }
            this.impl_reapplyCSS();
            this.leftArrowButton.setVisible(PaginationSkin.this.isArrowsVisible());
            this.rightArrowButton.setVisible(PaginationSkin.this.isArrowsVisible());
            this.pageInformation.setVisible(PaginationSkin.this.isPageInformationVisible());
            this.layoutPageIndicators();
            this.previousWidth = this.getWidth();
            HPos hPos = this.controlBox.getAlignment().getHpos();
            VPos vPos = this.controlBox.getAlignment().getVpos();
            double d11 = d3 + Utils.computeXOffset(d5, d7, hPos);
            double d12 = d + Utils.computeYOffset(d6, d8, vPos);
            if (PaginationSkin.this.isPageInformationVisible()) {
                Pos pos = this.sideToPos(PaginationSkin.this.getPageInformationAlignment());
                HPos hPos2 = pos.getHpos();
                VPos vPos2 = pos.getVpos();
                double d13 = d3 + Utils.computeXOffset(d5, d9, hPos2);
                double d14 = d + Utils.computeYOffset(d6, d10, vPos2);
                if (Side.TOP.equals((Object)PaginationSkin.this.getPageInformationAlignment())) {
                    d14 = d;
                    d12 = d + d10;
                } else if (Side.RIGHT.equals((Object)PaginationSkin.this.getPageInformationAlignment())) {
                    d13 = d5 - d4 - d9;
                } else if (Side.BOTTOM.equals((Object)PaginationSkin.this.getPageInformationAlignment())) {
                    d12 = d;
                    d14 = d + d8;
                } else if (Side.LEFT.equals((Object)PaginationSkin.this.getPageInformationAlignment())) {
                    d13 = d3;
                }
                this.layoutInArea(this.pageInformation, d13, d14, d9, d10, 0.0, hPos2, vPos2);
            }
            this.layoutInArea(this.controlBox, d11, d12, d7, d8, 0.0, hPos, vPos);
        }
    }
}

