/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import com.sun.javafx.fxml.expression.Expression;

public abstract class BinaryExpression
extends Expression {
    private Expression left;
    private Expression right;

    public BinaryExpression(Expression expression, Expression expression2) {
        if (expression == null) {
            throw new NullPointerException();
        }
        if (expression2 == null) {
            throw new NullPointerException();
        }
        this.left = expression;
        expression.setParent(this);
        this.right = expression2;
        expression2.setParent(this);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public abstract String getOperator();

    @Override
    public boolean isDefined() {
        return this.left.isDefined() && this.right.isDefined();
    }

    @Override
    protected void registerChangeListeners() {
        this.left.registerChangeListeners();
        this.right.registerChangeListeners();
    }

    @Override
    protected void unregisterChangeListeners() {
        this.left.unregisterChangeListeners();
        this.right.unregisterChangeListeners();
    }

    public String toString() {
        return "(" + this.left + " " + this.getOperator() + " " + this.right + ")";
    }
}

