/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections.transformation;

import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.collections.transformation.FilterableList;
import com.sun.javafx.collections.transformation.Matcher;
import com.sun.javafx.collections.transformation.TransformationList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.collections.ListChangeListener;

public final class FilteredList<E>
extends TransformationList<E, E>
implements FilterableList<E> {
    private FilterableList.FilterMode mode;
    private Matcher<? super E> matcher;
    private int[] filtered;
    private int size;
    private boolean matcherChanged;

    private int findPosition(int n) {
        if (this.filtered.length == 0) {
            return 0;
        }
        int n2 = Arrays.binarySearch(this.filtered, 0, this.size, n);
        if (n2 < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        return n2;
    }

    private void ensureSize(int n) {
        if (this.filtered.length < n) {
            int[] nArray = new int[n * 3 / 2 + 1];
            System.arraycopy(this.filtered, 0, nArray, 0, this.size);
            this.filtered = nArray;
        }
    }

    private void removeFilteredRange(int n, int n2, List<? extends E> list, List<E> list2) {
        int n3 = n + list.size();
        int n4 = this.findPosition(n3);
        int n5 = n4 - n2;
        if (n2 != n4) {
            for (int i = n2; i < n4; ++i) {
                list2.add(list.get(this.filtered[i] - n));
            }
            System.arraycopy(this.filtered, n4, this.filtered, n2, this.size - n4);
            this.size -= n5;
        }
    }

    private void updateIndexes(int n, int n2) {
        int n3 = n;
        while (n3 < this.size) {
            int n4 = n3++;
            this.filtered[n4] = this.filtered[n4] + n2;
        }
    }

    private void update(int n, List<? extends E> list, int[] nArray, int n2) {
        if ((n2 | list.size()) == 0) {
            return;
        }
        int n3 = this.findPosition(n);
        ArrayList arrayList = new ArrayList();
        this.removeFilteredRange(n, n3, list, arrayList);
        this.ensureSize(this.size + n2 - arrayList.size());
        System.arraycopy(this.filtered, n3, this.filtered, n3 + n2, this.size - n3);
        for (int i = 0; i < n2; ++i) {
            this.filtered[n3 + i] = nArray[i];
        }
        this.size += n2;
        this.updateIndexes(n3 + n2, n2 - list.size());
        this.fireChange(new NonIterableChange.GenericAddRemoveChange(n3, n3 + n2, Collections.unmodifiableList(arrayList), this));
    }

    public FilteredList(List<E> list, Matcher<? super E> matcher, FilterableList.FilterMode filterMode) {
        super(list);
        if (matcher == null) {
            throw new NullPointerException();
        }
        this.matcher = matcher;
        this.mode = filterMode;
        this.filtered = new int[list.size() * 3 / 2 + 1];
        if (filterMode == FilterableList.FilterMode.LIVE) {
            if (!this.observable) {
                throw new IllegalArgumentException("Cannot use LIVE mode with list that is not an ObservableList");
            }
            this.refilter();
        } else {
            this.size = list.size();
            for (int i = 0; i < this.size; ++i) {
                this.filtered[i] = i;
            }
        }
    }

    public FilteredList(List<E> list, Matcher<? super E> matcher) {
        this(list, matcher, FilterableList.FilterMode.LIVE);
    }

    @Override
    protected void onSourceChanged(ListChangeListener.Change<? extends E> change) {
        if (this.mode == FilterableList.FilterMode.BATCH) {
            int[] nArray = new int[change.getAddedSize()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = change.getFrom() + i;
            }
            this.update(change.getFrom(), change.getRemoved(), nArray, nArray.length);
        } else {
            if (change.wasPermutated()) {
                this.refilter();
            }
            int n = 0;
            int[] nArray = new int[change.getAddedSize()];
            for (int i = change.getFrom(); i < change.getTo(); ++i) {
                if (!this.matcher.matches(this.source.get(i))) continue;
                nArray[n++] = i;
            }
            this.update(change.getFrom(), change.getRemoved(), nArray, n);
        }
    }

    @Override
    public boolean addAll(E ... EArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setAll(E ... EArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(E ... EArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(E ... EArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = this.get(i);
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Object[] objectArray = TArray.length < this.size ? (Object[])Array.newInstance(TArray.getClass().getComponentType(), this.size) : TArray;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = this.get(i);
        }
        return objectArray;
    }

    @Override
    public E get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.source.get(this.filtered[n]);
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.size(); ++i) {
            if ((object != null || this.get(i) != null) && (object == null || !object.equals(this.get(i)))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if ((object != null || this.get(i) != null) && (object == null || !object.equals(this.get(i)))) continue;
            return i;
        }
        return -1;
    }

    private void refilter() {
        this.ensureSize(this.source.size());
        ArrayList arrayList = new ArrayList(this);
        this.size = 0;
        int n = 0;
        for (Object e : this.source) {
            if (this.matcher.matches(e)) {
                this.filtered[this.size++] = n;
            }
            ++n;
        }
        this.fireChange(new NonIterableChange.GenericAddRemoveChange(0, this.size, arrayList, this));
    }

    @Override
    public void filter() {
        if (this.mode == FilterableList.FilterMode.BATCH) {
            int n;
            int n2;
            int n3;
            if (this.matcherChanged) {
                this.refilter();
                this.matcherChanged = false;
                return;
            }
            for (n3 = 0; n3 < this.size; ++n3) {
                int n4 = n2 = n3 == 0 ? 0 : this.filtered[n3 - 1] + 1;
                while (n2 < this.filtered[n3]) {
                    if (this.matcher.matches(this.source.get(n2))) {
                        this.refilter();
                        return;
                    }
                    ++n2;
                }
            }
            for (n3 = this.filtered[this.size - 1] + 1; n3 < this.source.size(); ++n3) {
                if (!this.matcher.matches(this.source.get(n3))) continue;
                this.refilter();
                return;
            }
            n3 = -1;
            n2 = -1;
            ArrayList arrayList = new ArrayList();
            for (n = 0; n < this.size; ++n) {
                if (this.matcher.matches(this.source.get(this.filtered[n]))) continue;
                if (n3 == -1) {
                    n3 = n;
                }
                this.filtered[n] = ~this.filtered[n];
                n2 = n;
            }
            ++n2;
            if (n3 == -1) {
                return;
            }
            for (n = n3; n < n2; ++n) {
                arrayList.add(this.source.get(this.filtered[n] < 0 ? ~this.filtered[n] : this.filtered[n]));
            }
            for (n = n3; n < n2; ++n) {
                if (this.filtered[n] >= 0) continue;
                System.arraycopy(this.filtered, n + 1, this.filtered, n, this.size - n - 1);
                --this.size;
                --n2;
                --n;
            }
            this.fireChange(new NonIterableChange.GenericAddRemoveChange(n3, n2, Collections.unmodifiableList(arrayList), this));
        }
    }

    @Override
    public void setMode(FilterableList.FilterMode filterMode) {
        if (this.mode != filterMode) {
            this.mode = filterMode;
            if (filterMode == FilterableList.FilterMode.LIVE) {
                this.filter();
            }
        }
    }

    @Override
    public FilterableList.FilterMode getMode() {
        return this.mode;
    }

    @Override
    public void setMatcher(Matcher<? super E> matcher) {
        if (this.matcher != matcher) {
            this.matcher = matcher;
            if (this.mode == FilterableList.FilterMode.LIVE) {
                this.refilter();
            } else {
                this.matcherChanged = true;
            }
        }
    }

    @Override
    public Matcher<? super E> getMatcher() {
        return this.matcher;
    }

    @Override
    public int getSourceIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.filtered[n];
    }
}

