/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx;

import com.sun.deploy.uitoolkit.SynthesizedEventListener;
import com.sun.deploy.uitoolkit.Window;
import com.sun.deploy.uitoolkit.impl.fx.AppletStageManager;
import com.sun.deploy.uitoolkit.impl.fx.DeployPerfLogger;
import com.sun.javafx.tk.desktop.AppletWindow;
import com.sun.javafx.tk.desktop.DesktopToolkit;
import java.util.Map;
import javafx.stage.Stage;

public class FXWindow
extends Window
implements AppletStageManager,
SynthesizedEventListener {
    private AppletWindow appletWindow;
    private int width = 0;
    private int height = 0;
    private Stage appletStage;
    private Stage preloaderStage;
    private Stage errorStage;

    FXWindow(long parent, String caRenderServer) {
        DeployPerfLogger.timestamp("(start) FXWindow Constructor");
        this.appletWindow = DesktopToolkit.getDesktopToolkit().createAppletWindow(parent, caRenderServer);
        DeployPerfLogger.timestamp("  FXWindow got toolkit window");
        this.width = this.appletWindow.getWidth();
        this.height = this.appletWindow.getHeight();
        DeployPerfLogger.timestamp("(done) FXWindow Constructor");
    }

    public Object getWindowObject() {
        return this.appletWindow;
    }

    public void synthesizeEvent(Map eventData) {
        this.appletWindow.dispatchEvent(eventData);
    }

    public void requestFocus() {
    }

    public int getWindowLayerID() {
        return this.appletWindow.getRemoteLayerId();
    }

    public void setBackground(int i) {
        this.appletWindow.setBackgroundColor(i);
    }

    public void setForeground(int i) {
        this.appletWindow.setForegroundColor(i);
    }

    public void setVisible(boolean visible) {
        this.appletWindow.setVisible(visible);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.appletWindow.setSize(width, height);
        if (this.appletStage != null) {
            this.appletStage.setWidth(width);
            this.appletStage.setHeight(height);
        }
        if (this.preloaderStage != null) {
            this.preloaderStage.setWidth(width);
            this.preloaderStage.setHeight(height);
        }
        if (this.errorStage != null) {
            this.errorStage.setWidth(width);
            this.errorStage.setHeight(height);
        }
    }

    public Window.WindowSize getSize() {
        this.width = this.appletWindow.getWidth();
        this.height = this.appletWindow.getHeight();
        return new Window.WindowSize((Window)this, this.width, this.height);
    }

    public void dispose() {
        if (null != this.appletStage) {
            this.appletStage.close();
            this.appletStage = null;
        }
        if (null != this.preloaderStage) {
            this.preloaderStage.close();
            this.preloaderStage = null;
        }
        if (null != this.errorStage) {
            this.errorStage.close();
            this.errorStage = null;
        }
        this.appletWindow = null;
        DesktopToolkit.getDesktopToolkit().closeAppletWindow();
    }

    public void dispose(Window.DisposeListener dl, long l) {
        this.dispose();
    }

    public void setPosition(int x, int y) {
        this.appletWindow.setPosition(x, y);
    }

    public synchronized Stage getAppletStage() {
        if (this.appletStage == null) {
            this.appletStage = this.createNewStage();
        }
        return this.appletStage;
    }

    public Stage getPreloaderStage() {
        if (this.preloaderStage == null) {
            this.preloaderStage = this.createNewStage();
            if (null == this.errorStage) {
                this.appletWindow.setStageOnTop(this.preloaderStage);
            }
        }
        return this.preloaderStage;
    }

    public Stage getErrorStage() {
        if (this.errorStage == null) {
            this.errorStage = this.createNewStage();
            this.appletWindow.setStageOnTop(this.errorStage);
        }
        return this.errorStage;
    }

    private Stage createNewStage() {
        Stage stage = new Stage();
        stage.impl_setPrimary(true);
        stage.setWidth(this.width);
        stage.setHeight(this.height);
        stage.setResizable(false);
        return stage;
    }
}

