/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.DestructuringForm;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;
import sun.org.mozilla.javascript.internal.ast.ObjectProperty;

public class ObjectLiteral
extends AstNode
implements DestructuringForm {
    private static final List<ObjectProperty> NO_ELEMS = Collections.unmodifiableList(new ArrayList());
    private List<ObjectProperty> elements;
    boolean isDestructuring;

    public ObjectLiteral() {
        this.type = 66;
    }

    public ObjectLiteral(int n) {
        super(n);
        this.type = 66;
    }

    public ObjectLiteral(int n, int n2) {
        super(n, n2);
        this.type = 66;
    }

    public List<ObjectProperty> getElements() {
        return this.elements != null ? this.elements : NO_ELEMS;
    }

    public void setElements(List<ObjectProperty> list) {
        if (list == null) {
            this.elements = null;
        } else {
            if (this.elements != null) {
                this.elements.clear();
            }
            for (ObjectProperty objectProperty : list) {
                this.addElement(objectProperty);
            }
        }
    }

    public void addElement(ObjectProperty objectProperty) {
        this.assertNotNull(objectProperty);
        if (this.elements == null) {
            this.elements = new ArrayList<ObjectProperty>();
        }
        this.elements.add(objectProperty);
        objectProperty.setParent(this);
    }

    @Override
    public void setIsDestructuring(boolean bl) {
        this.isDestructuring = bl;
    }

    @Override
    public boolean isDestructuring() {
        return this.isDestructuring;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("{");
        if (this.elements != null) {
            this.printList(this.elements, stringBuilder);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            for (ObjectProperty objectProperty : this.getElements()) {
                objectProperty.visit(nodeVisitor);
            }
        }
    }
}

