/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import sun.org.mozilla.javascript.internal.ErrorReporter;
import sun.org.mozilla.javascript.internal.EvaluatorException;
import sun.org.mozilla.javascript.internal.ScriptRuntime;

class DefaultErrorReporter
implements ErrorReporter {
    static final DefaultErrorReporter instance = new DefaultErrorReporter();
    private boolean forEval;
    private ErrorReporter chainedReporter;

    private DefaultErrorReporter() {
    }

    static ErrorReporter forEval(ErrorReporter errorReporter) {
        DefaultErrorReporter defaultErrorReporter = new DefaultErrorReporter();
        defaultErrorReporter.forEval = true;
        defaultErrorReporter.chainedReporter = errorReporter;
        return defaultErrorReporter;
    }

    @Override
    public void warning(String string, String string2, int n, String string3, int n2) {
        if (this.chainedReporter != null) {
            this.chainedReporter.warning(string, string2, n, string3, n2);
        }
    }

    @Override
    public void error(String string, String string2, int n, String string3, int n2) {
        if (this.forEval) {
            String string4 = "SyntaxError";
            if (string.startsWith("TypeError: ")) {
                string4 = "TypeError";
                string = string.substring("TypeError: ".length());
            }
            throw ScriptRuntime.constructError(string4, string, string2, n, string3, n2);
        }
        if (this.chainedReporter == null) {
            throw this.runtimeError(string, string2, n, string3, n2);
        }
        this.chainedReporter.error(string, string2, n, string3, n2);
    }

    @Override
    public EvaluatorException runtimeError(String string, String string2, int n, String string3, int n2) {
        if (this.chainedReporter != null) {
            return this.chainedReporter.runtimeError(string, string2, n, string3, n2);
        }
        return new EvaluatorException(string, string2, n, string3, n2);
    }
}

