/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import sun.awt.AppContext;
import sun.util.logging.PlatformLogger;

public final class AWTAutoShutdown
implements Runnable {
    private static final AWTAutoShutdown theInstance = new AWTAutoShutdown();
    private final Object mainLock = new Object();
    private final Object activationLock = new Object();
    private final HashSet busyThreadSet = new HashSet(7);
    private boolean toolkitThreadBusy = false;
    private final Map peerMap = new IdentityHashMap();
    private Thread blockerThread = null;
    private boolean timeoutPassed = false;
    private static final int SAFETY_TIMEOUT = 1000;

    private AWTAutoShutdown() {
    }

    public static AWTAutoShutdown getInstance() {
        return theInstance;
    }

    public static void notifyToolkitThreadBusy() {
        AWTAutoShutdown.getInstance().setToolkitBusy(true);
    }

    public static void notifyToolkitThreadFree() {
        AWTAutoShutdown.getInstance().setToolkitBusy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyThreadBusy(Thread thread) {
        if (thread == null) {
            return;
        }
        Object object = this.activationLock;
        synchronized (object) {
            Object object2 = this.mainLock;
            synchronized (object2) {
                if (this.blockerThread == null) {
                    this.activateBlockerThread();
                } else if (this.isReadyToShutdown()) {
                    this.mainLock.notifyAll();
                    this.timeoutPassed = false;
                }
                this.busyThreadSet.add(thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyThreadFree(Thread thread) {
        if (thread == null) {
            return;
        }
        Object object = this.activationLock;
        synchronized (object) {
            Object object2 = this.mainLock;
            synchronized (object2) {
                this.busyThreadSet.remove(thread);
                if (this.isReadyToShutdown()) {
                    this.mainLock.notifyAll();
                    this.timeoutPassed = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPeerMapUpdated() {
        Object object = this.activationLock;
        synchronized (object) {
            Object object2 = this.mainLock;
            synchronized (object2) {
                if (!this.isReadyToShutdown() && this.blockerThread == null) {
                    this.activateBlockerThread();
                } else {
                    this.mainLock.notifyAll();
                    this.timeoutPassed = false;
                }
            }
        }
    }

    private boolean isReadyToShutdown() {
        return !this.toolkitThreadBusy && this.peerMap.isEmpty() && this.busyThreadSet.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setToolkitBusy(boolean bl) {
        if (bl != this.toolkitThreadBusy) {
            Object object = this.activationLock;
            synchronized (object) {
                Object object2 = this.mainLock;
                synchronized (object2) {
                    if (bl != this.toolkitThreadBusy) {
                        if (bl) {
                            if (this.blockerThread == null) {
                                this.activateBlockerThread();
                            } else if (this.isReadyToShutdown()) {
                                this.mainLock.notifyAll();
                                this.timeoutPassed = false;
                            }
                            this.toolkitThreadBusy = bl;
                        } else {
                            this.toolkitThreadBusy = bl;
                            if (this.isReadyToShutdown()) {
                                this.mainLock.notifyAll();
                                this.timeoutPassed = false;
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        boolean bl = false;
        Object object = this.mainLock;
        synchronized (object) {
            try {
                this.mainLock.notifyAll();
                block8: while (this.blockerThread == thread) {
                    this.mainLock.wait();
                    this.timeoutPassed = false;
                    while (this.isReadyToShutdown()) {
                        if (this.timeoutPassed) {
                            this.timeoutPassed = false;
                            this.blockerThread = null;
                            continue block8;
                        }
                        this.timeoutPassed = true;
                        this.mainLock.wait(1000L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
            finally {
                if (this.blockerThread == thread) {
                    this.blockerThread = null;
                }
            }
        }
        if (!bl) {
            AppContext.stopEventDispatchThreads();
        }
    }

    static AWTEvent getShutdownEvent() {
        return new AWTEvent(AWTAutoShutdown.getInstance(), 0){};
    }

    private void activateBlockerThread() {
        Thread thread = new Thread((Runnable)this, "AWT-Shutdown");
        thread.setDaemon(false);
        this.blockerThread = thread;
        thread.start();
        try {
            this.mainLock.wait();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("AWT blocker activation interrupted:");
            interruptedException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerPeer(Object object, Object object2) {
        Object object3 = this.activationLock;
        synchronized (object3) {
            Object object4 = this.mainLock;
            synchronized (object4) {
                this.peerMap.put(object, object2);
                this.notifyPeerMapUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterPeer(Object object, Object object2) {
        Object object3 = this.activationLock;
        synchronized (object3) {
            Object object4 = this.mainLock;
            synchronized (object4) {
                if (this.peerMap.get(object) == object2) {
                    this.peerMap.remove(object);
                    this.notifyPeerMapUpdated();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object getPeer(Object object) {
        Object object2 = this.activationLock;
        synchronized (object2) {
            Object object3 = this.mainLock;
            synchronized (object3) {
                return this.peerMap.get(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpPeers(PlatformLogger platformLogger) {
        Object object = this.activationLock;
        synchronized (object) {
            Object object2 = this.mainLock;
            synchronized (object2) {
                platformLogger.fine("Mapped peers:");
                for (Object k : this.peerMap.keySet()) {
                    platformLogger.fine(k + "->" + this.peerMap.get(k));
                }
            }
        }
    }
}

