/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.orbutil.fsm;

import com.sun.corba.se.spi.orbutil.fsm.FSM;
import com.sun.corba.se.spi.orbutil.fsm.GuardBase;
import com.sun.corba.se.spi.orbutil.fsm.Input;

public interface Guard {
    public Result evaluate(FSM var1, Input var2);

    public static final class Result {
        private String name;
        public static final Result ENABLED = new Result("ENABLED");
        public static final Result DISABLED = new Result("DISABLED");
        public static final Result DEFERED = new Result("DEFERED");

        private Result(String string) {
            this.name = string;
        }

        public static Result convert(boolean bl) {
            return bl ? ENABLED : DISABLED;
        }

        public Result complement() {
            if (this == ENABLED) {
                return DISABLED;
            }
            if (this == DISABLED) {
                return ENABLED;
            }
            return DEFERED;
        }

        public String toString() {
            return "Guard.Result[" + this.name + "]";
        }
    }

    public static final class Complement
    extends GuardBase {
        private Guard guard;

        public Complement(GuardBase guardBase) {
            super("not(" + guardBase.getName() + ")");
            this.guard = guardBase;
        }

        @Override
        public Result evaluate(FSM fSM, Input input) {
            return this.guard.evaluate(fSM, input).complement();
        }
    }
}

