#include <sys/types.h>
#include <asm/types.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <sys/socket.h>
#include <features.h>    /* for the glibc version number */
#include <netinet/in.h>
#if __GLIBC__ >= 2 && __GLIBC_MINOR >= 1
#include <netpacket/packet.h>
#include <net/ethernet.h>     /* the L2 protocols */
#else
#include <asm/types.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>   /* The L2 protocols */
#endif
#include <limits.h>
#include <ctype.h>





/*
 * converts all lower case letters in the the string to upper case
 */
static __inline__ void to_upper (char *s)
{
    char	*p;
    char	offset;

    offset = 'A' - 'a';
    for(p=s;*p != '\0';p++) {
        if(islower(*p)) {
            *p += offset;
        }
    }
}


/*
 * converts a string to a mac address...
 * returns 1 on success, -1 on failure...
 * failure indicates poorly formed input...
 */
int string_to_mac (char *string, __u8 *mac_buf)
{
    char			*ptr, *next;
    unsigned long	val;
    int				i;


    to_upper(string);

    ptr = next = string;
    for(i=0;i < 6;i++) {
        if((val = strtoul(next, &ptr, 16)) > 255) {
            errno = EINVAL;
            return(-1);
        }
        mac_buf[i] = (__u8)val;
        if((next == ptr) && (i != 6 - 1)) {
            errno = EINVAL;
            return(-1);
        }
        next = ptr + 1;
    }

    return(1);
}


/*
 * usage...
 */
static void usage (char *pname)
{

    fprintf(stderr, "setmac: sets the hardware address on an interface.\n");
    fprintf(stderr, "Usage\n");
    fprintf(stderr, "%s <interface name> <mac address>\n\n", pname);
    exit(1);
}


int main (int argc, char **argv)
{
    struct sockaddr_ll	addr;
    struct ifreq		req;
    __u8				mac[6];
    int					sockfd;


    if(argc != 3) {
        usage(argv[0]);
    }

    if(string_to_mac(argv[2], mac) < 0) {
        fprintf(stderr, "error: invalid or imporperly formed mac address\n");
        exit(1);
    }

    if(strlen(argv[1]) >= IFNAMSIZ) {
        fprintf(stderr, "error: interface name is too long\n");
        exit(1);
    }

    /* open the link layer socket */
    if((sockfd = socket(PF_PACKET, SOCK_RAW, htons(ETH_P_ALL))) < 0) {
        perror("socket");
        exit(1);
    }

    /* get the interface index */
    memset(&req, 0, sizeof(struct ifreq));
    strcpy(req.ifr_name, argv[1]);

    if(ioctl(sockfd, SIOCGIFINDEX, &req) < 0) {
        perror("ioctl: SIOCGIFINDEX");
        exit(1);
    }

    /* bind the socket to the interface */
    memset(&addr, 0, sizeof(struct sockaddr_ll));
    addr.sll_ifindex = req.ifr_ifindex;
    addr.sll_protocol = htons(ETH_P_ALL);
    addr.sll_family = AF_PACKET;
    if(bind(sockfd, (struct sockaddr *)&addr, sizeof(struct sockaddr_ll)) < 0) {
        perror("bind");
        exit(1);
    }
    
    strcpy(req.ifr_name, argv[1]);
    req.ifr_hwaddr.sa_family = ARPHRD_ETHER;
    memcpy(req.ifr_hwaddr.sa_data, mac, sizeof(mac));

    if(ioctl(sockfd, SIOCSIFHWADDR, &req) < 0) {
        perror("ioctl: SIOCSIFHWADDR");
        exit(1);
    }

    close(sockfd);

    exit(0);
}






