/******************************************************************************
**
** Set Channel: Changes the channel on an AirJack interface...
**
**   Author:  Abaddon, abaddon@802.11ninja.net
**
**   Other Development Stuff:  Xx25,  xx25@leper.org
**
**   Copyright (c) 2002 Abaddon, All Rights Reserved (see license info below). 
**
********************
**
** Legal:
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License
**   as published by the Free Software Foundation; either version 2
**   of the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public License
**   along with this program; if not, write to the Free Software
**   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
********************
**
** $Id$
**
******************************************************************************/
#define __SET_CHANNEL_C__
#include <sys/types.h>
#include <asm/types.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <sys/socket.h>
#include <features.h>    /* for the glibc version number */
#include <netinet/in.h>
#if __GLIBC__ >= 2 && __GLIBC_MINOR >= 1
#include <netpacket/packet.h>
#include <net/ethernet.h>     /* the L2 protocols */
#else
#include <asm/types.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>   /* The L2 protocols */
#endif
#include <limits.h>

#include "../airjack.h"


/*** Globals ***/

__u16	channel;		/* channel the bss is on */
char	ifname[IFNAMSIZ];		/* name of the interface to send this out on */

/***************/




/*
 * sets up the raw link layer socket for Aironet type cards...
 * returns a filedescriptor on success, -1 on error, errno is set
 */
static int get_socket (void)
{
    struct sockaddr_ll	addr;
    struct ifreq		req;
    struct aj_config	aj_config;
    int					sockfd;


    /* open the link layer socket */
    if((sockfd = socket(PF_PACKET, SOCK_RAW, htons(ETH_P_ALL))) < 0) {
        return(-1);
    }

    /* get the interface index */
    memset(&req, 0, sizeof(struct ifreq));
    memset(&aj_config, 0, sizeof(struct aj_config));
    strcpy(req.ifr_name, ifname);

    if(ioctl(sockfd, SIOCGIFINDEX, &req) < 0) {
        return(-2);
    }

    /* bind the socket to the interface */
    memset(&addr, 0, sizeof(struct sockaddr_ll));
    addr.sll_ifindex = req.ifr_ifindex;
    addr.sll_protocol = htons(ETH_P_ALL);
    addr.sll_family = AF_PACKET;
    if(bind(sockfd, (struct sockaddr *)&addr, sizeof(struct sockaddr_ll)) < 0) {
        return(-3);
    }

    req.ifr_data = (char *)&aj_config;

    if(ioctl(sockfd, SIOCAJGMODE, &req) < 0) {
        return(-4);
    }

    aj_config.channel = channel;

    if(ioctl(sockfd, SIOCAJSMODE, &req) < 0) {
        return(-4);
    }

    return(sockfd);
}


/*
 * um, its usage...
 */
static void usage (const char *pname)
{
    
    fprintf(stderr, "Set Channel: Sets the listen/transmit channel for the AirJack interface.\n\n");
    fprintf(stderr, "Usage: %s -c <channel> [ -i <interface name> ]\n", pname);
    fprintf(stderr, "       -c:  channel number (1-14).\n");
    fprintf(stderr, "       -i:  the name of the AirJack interface to use (defaults to aj0).\n\n");
    exit(1);
}


/*
 * parses the command line options...
 */
static void parse_opts (int argc, char **argv)
{
	char	opt;
	char	*pname = argv[0];
    __u8	opts_given = 0;		/* bitfield to make sure they enter the right stuff */


#define OPT_CHANNEL	4
	

	/* set defaults */
    strcpy(ifname, "aj0");

	opterr = 0;
	while((opt = getopt(argc, argv, "i:c:")) > 0) {
		switch(opt) {
        case 'i':
            strncpy(ifname, optarg, IFNAMSIZ);
            break;
        case 'c':
            opts_given |= OPT_CHANNEL;
            channel = atoi(optarg);
            if((channel > 14) || (channel < 1)) {
                usage(pname);
            }
            break;
        default:
            usage(pname);
            break;
		}
	}

    if(!(opts_given & OPT_CHANNEL)) {
        usage(pname);
    }
}


/*
 * this program forces a network to give up its essid...uh read above...
 */
int main (int argc, char **argv)
{
    int	sockfd;

    parse_opts(argc, argv);

    if((sockfd = get_socket()) < 0) {
        perror("get_socket");
        exit(1);
    }

    close(sockfd);
    exit(0);
}

