#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/select.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>



int main (void)
{
    struct timeval	tv;
    int				i, fd;
    ssize_t			nbytes;
    unsigned char	buf[256];



    if((fd = open("/proc/aj0_core", O_RDONLY)) < 0) {
        perror("open");
        exit(1);
    }


    for(i=0;i < 1024;i++) {
        if((nbytes = read(fd, buf, sizeof(buf))) < 0) {
            perror("read");
            exit(1);
        }

        if(write(STDOUT_FILENO, buf, nbytes) < 0) {
            perror("read");
            exit(1);
        }

        tv.tv_sec = 0;
        tv.tv_usec = 5000;
        select(0, NULL, NULL, NULL, &tv);
    }

    fprintf(stderr, "done\n");
    exit(1);
}


