/******************************************************************************
**
** AirJack: 802.11b attack drivers for use with the AirJack set of tools...
**
**   Author:  Abaddon, abaddon@802.11ninja.net
**
**   Other Development Stuff:  Xx25,  xx25@leper.org
**
**   Copyright (c) 2002 Abaddon, All Rights Reserved (see license info below). 
**
********************
**
**    80211.h:
**         802.11(b) structures and data types and all that...
**
********************
**
** Legal:
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License
**   as published by the Free Software Foundation; either version 2
**   of the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public License
**   along with this program; if not, write to the Free Software
**   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
********************
**
** $Id$
**
******************************************************************************/

#ifndef __80211H__
#define __80211H__



/*** Limits and Sizes ***/
#define FCS_LEN			4
#define WEP_IV_LEN		3


/*** Frame Control Types ***/

#define FC_TYPE_MGT			0x00	/* management type */
#define FC_TYPE_CTL			0x01	/* control type */
#define FC_TYPE_DATA		0x02	/* data type */
#define FC_TYPE_RESR		0x03	/* reserved for later use */

/*** Management SubTypes ***/
#define MGT_AS_RQ			0x00	/* association request */
#define MGT_AS_RS			0x01	/* association responce */
#define MGT_REAS_RQ			0x02	/* reassociation request */
#define MGT_REAS_RS			0x03	/* reassociation responce */
#define MGT_PB_RQ			0x04	/* probe request */
#define MGT_PB_RS			0x05	/* probe responce */
#define MGT_RESERV1			0x06
#define MGT_RESERV2			0x07
#define MGT_BEACON			0x08	/* beacon */
#define MGT_ATIM			0x09	/* announcement trafic indication message */
#define MGT_DISAS			0x0A	/* disassociation */
#define MGT_AUTH			0x0B	/* authentication */
#define MGT_DEAUTH			0x0C	/* de-authentication */
#define MGT_RESERV3			0x0D
#define MGT_RESERV4			0x0E
#define MGT_RESERV5			0x0F

/*** Control SubTypes ***/
#define CTL_RESERV1			0x00
#define CTL_RESERV2			0x01
#define CTL_RESERV3			0x02
#define CTL_RESERV4			0x03
#define CTL_RESERV5			0x04
#define CTL_RESERV6			0x05
#define CTL_RESERV7			0x06
#define CTL_RESERV8			0x07
#define CTL_RESERV9			0x08
#define CTL_RESERV10		0x09
#define CTL_PS				0x0A	/* power save poll */
#define CTL_RTS				0x0B	/* request to send */
#define CTL_CTS				0x0C	/* clear to send */
#define CTL_ACK				0x0D	/* acknowledgement... */
#define CTL_CFEND			0x0E	/* contention free end */
#define CTL_CFACK			0x0F	/* CF-end + CF-ack */

/*** Data SubTypes ***/
#define DATA_DATA			0x00	/* data */
#define DATA_DACK			0x01	/* data + CF-ack */
#define DATA_POLL			0x02	/* data + CF-poll */
#define DATA_ACK_POLL		0x03	/* data + CF-ack + CF-poll */
#define DATA_NULL			0x04	/* null, no data */
#define DATA_NULL_ACK		0x05	/* CF-ack, no data */
#define DATA_NULL_POLL		0x06	/* CF-poll, no data */
#define DATA_NULL_A_P		0x07	/* CF-poll + CF-ack, no data */
#define DATA_RESERV1		0x08
#define DATA_RESERV2		0x09
#define DATA_RESERV3		0x0A
#define DATA_RESERV4		0x0B
#define DATA_RESERV5		0x0C
#define DATA_RESERV6		0x0D
#define DATA_RESERV7		0x0E
#define DATA_RESERV8		0x0F


/*** Status Codes ***/
#define STAT_SUCCESS		0x00	/* successful */
#define STAT_FAILURE		0x01	/* failure */
#define STAT_RESERV1		0x02
#define STAT_RESERV2		0x03
#define STAT_RESERV3		0x04
#define STAT_RESERV4		0x05
#define STAT_RESERV5		0x06
#define STAT_RESERV6		0x07
#define STAT_RESERV7		0x08
#define STAT_RESERV8		0x09
#define STAT_NOSUPP			0x0A	/* cannot support capabilities in cap_info */
#define STAT_RASDENY		0x0B	/* reassociation denied */
#define STAT_ASDENY			0x0C	/* association denied */
#define STAT_NOAUTH			0x0D	/* station does not support authentication method */
#define STAT_BADSEQ			0x0E	/* auth request with sequence num out of sequence */
#define STAT_BADCHAL		0x0F	/* auth rejected do to failed challange */
#define STAT_TIMEOUT		0x10	/* auth rejected do to timeout */
#define STAT_OVLOAD			0x11	/* association failed do to overload */
#define STAT_TOSLOW			0x12	/* association denied because supported of rates */
#define STAT_RESERV9		0x13	/* the values 19-65535 are reserved */


/*** Element Id Codes ***/
#define ELEM_SSID			0x00	/* ssid */
#define ELEM_RATES			0x01	/* supported rates */
#define ELEM_FH				0x02	/* fh parameter set */
#define ELEM_DS				0x03	/* ds parameter set */
#define ELEM_CF				0x04	/* cf parameter set */
#define ELEM_TIM			0x05	/* TIM */
#define ELEM_IBSS			0x06	/* ibss parameter set */
#define ELEM_RESERV1		0x07	
#define ELEM_RESERV2		0x08	
#define ELEM_RESERV3		0x09	
#define ELEM_RESERV4		0x0A	
#define ELEM_RESERV5		0x0B	
#define ELEM_RESERV6		0x0C	
#define ELEM_RESERV7		0x0D	
#define ELEM_RESERV8		0x0E	
#define ELEM_RESERV9		0x0F	
#define ELEM_CHALL			0x10	/* challenge text */
#define ELEM_CHALRES1		0x11	/* reserved for challenge extention */
#define ELEM_CHALRES2		0x12
#define ELEM_CHALRES3		0x13
#define ELEM_CHALRES4		0x14
#define ELEM_CHALRES5		0x15
#define ELEM_CHALRES6		0x16
#define ELEM_CHALRES7		0x17
#define ELEM_CHALRES8		0x18
#define ELEM_CHALRES9		0x19
#define ELEM_CHALRES10		0x1A
#define ELEM_CHALRES11		0x1B
#define ELEM_CHALRES12		0x1C
#define ELEM_CHALRES13		0x1D
#define ELEM_CHALRES14		0x1E
#define ELEM_CHALRES15		0x1F
#define ELEM_RESERV10		0x20	/* 32-255 are reserved */

/* BSS basic rate set, supported rates */
#define RATES_1		0x82	/* 1 mb/s */
#define RATES_2		0x84	/* 2 mb/s */
#define RATES_5		0x8b	/* 5.5 mb/s */
#define RATES_11	0x96	/* 11 mb/s */

/* authentication algorithm numbers */
#define AUTH_OPEN_SYS		0
#define AUTH_SHARED_KEY		1
/* all others are reserved */

/*** 802.11 structures ***/

/*** one address Mac Header ***/
struct a1_80211 {
    union {
        __u16	fc1_frame_control;
        struct {
            __u16	fc2_version:2;
            __u16	fc2_type:2;
            __u16	fc2_subtype:4;
            __u16	fc2_to_ds:1;
            __u16	fc2_from_ds:1;
            __u16	fc2_more_frag:1;
            __u16	fc2_retry:1;
            __u16	fc2_pwr_man:1;
            __u16	fc2_more_data:1;
            __u16	fc2_wep:1;
            __u16	fc2_order:1;
        } fc2;
    } fc1;
    __u16	mh_duration_id;
    __u8	mh_mac1[6];
};


/*** two address Mac Header ***/
struct a2_80211 {
    union {
        __u16	fc1_frame_control;
        struct {
            __u16	fc2_version:2;
            __u16	fc2_type:2;
            __u16	fc2_subtype:4;
            __u16	fc2_to_ds:1;
            __u16	fc2_from_ds:1;
            __u16	fc2_more_frag:1;
            __u16	fc2_retry:1;
            __u16	fc2_pwr_man:1;
            __u16	fc2_more_data:1;
            __u16	fc2_wep:1;
            __u16	fc2_order:1;
        } fc2;
    } fc1;
    __u16	mh_duration_id;
    __u8	mh_mac1[6];
    __u8	mh_mac2[6];
};


/*** three address Mac Header ***/
struct a3_80211 {
    union {
        __u16	fc1_frame_control;
        struct {
            __u16	fc2_version:2;
            __u16	fc2_type:2;
            __u16	fc2_subtype:4;
            __u16	fc2_to_ds:1;
            __u16	fc2_from_ds:1;
            __u16	fc2_more_frag:1;
            __u16	fc2_retry:1;
            __u16	fc2_pwr_man:1;
            __u16	fc2_more_data:1;
            __u16	fc2_wep:1;
            __u16	fc2_order:1;
        } fc2;
    } fc1;
    __u16	mh_duration_id;
    __u8	mh_mac1[6];
    __u8	mh_mac2[6];
    __u8	mh_mac3[6];
    union {
        __u16	seq1_seq;
        struct {
            __u16	seq2_frag_num:4;
            __u16	seq2_seq_num:12;
        } seq2;
    } seq1;
};


/*** four address Mac Header ***/
struct a4_80211 {
    union {
        __u16	fc1_frame_control;
        struct {
            __u16	fc2_version:2;
            __u16	fc2_type:2;
            __u16	fc2_subtype:4;
            __u16	fc2_to_ds:1;
            __u16	fc2_from_ds:1;
            __u16	fc2_more_frag:1;
            __u16	fc2_retry:1;
            __u16	fc2_pwr_man:1;
            __u16	fc2_more_data:1;
            __u16	fc2_wep:1;
            __u16	fc2_order:1;
        } fc2;
    } fc1;
    __u16	mh_duration_id;
    __u8	mh_mac1[6];
    __u8	mh_mac2[6];
    __u8	mh_mac3[6];
    union {
        __u16	seq1_seq;
        struct {
            __u16	seq2_frag_num:4;
            __u16	seq2_seq_num:12;
        } seq2;
    } seq1;
    __u8	mh_mac4[6];
};

/* manefest constants to make Mac Headers more straitforward */
#define mh_fc			fc1.fc1_frame_control
#define mh_version		fc1.fc2.fc2_version
#define mh_type			fc1.fc2.fc2_type
#define mh_subtype		fc1.fc2.fc2_subtype
#define mh_to_ds		fc1.fc2.fc2_to_ds
#define mh_from_ds		fc1.fc2.fc2_from_ds
#define mh_more_frag	fc1.fc2.fc2_more_frag
#define mh_retry		fc1.fc2.fc2_retry
#define mh_pwr_man		fc1.fc2.fc2_pwr_man
#define mh_more_data	fc1.fc2.fc2_more_data
#define mh_wep			fc1.fc2.fc2_wep
#define mh_order		fc1.fc2.fc2_order
#define mh_aid			mh_duration_id
#define mh_ra			mh_mac1
#define mh_da			mh_mac1
#define mh_ps_bssid		mh_mac1
#define mh_cf_bssid		mh_mac2
#define mh_ta			mh_mac2
#define mh_sa			mh_mac2
#define mh_bssid		mh_mac3
#define mh_seq			seq1.seq1_seq
#define mh_frag_num		seq1.seq2.seq2_frag_num
#define mh_seq_num		seq1.seq2.seq2_seq_num




struct cap_info {
    __u16	ci_ess:1;
    __u16	ci_ibss:1;
    __u16	ci_cfpollable:1;
    __u16	ci_cfpollreq:1;
    __u16	ci_priv:1;
    __u16	ci_reserved:11;
};


struct element_id {
    __u8	e_element_id;
    __u8	e_length;
};


struct fh_param {
    __u16	fh_dwell;
    __u8	fh_hop_set;
    __u8	fh_hop_pat;
    __u8	fh_hop_index;
};


struct ds_param {
    __u8	ds_current_chan;
};


struct cf_param {
    __u8	cf_count;
    __u8	cf_period;
    __u16	cf_max_dur;
    __u16	cf_dur_remain;
};


struct tim_element {
    __u8	tm_count;
    __u8	tm_period;
    __u8	tm_bmcontrol;
};


struct ibss_param {
    __u16	ib_atim_win;
};


/*
* Management frame structures:
*
* due to the use of variable length field in the middle of 
* a number of 802.11 management frame payload structures
* an overlay of the structure directly is impossible, to
* remedy this i have provided two types of structures for
* each management frame type, one with staticly created
* structures and buffers, and one with pointers to structures
* and buffers ment for overlaying, denoted by the absence or
* presence of the ov_ in the front of the struct name and the
* o in front of the struct elements, respectivly...
* for overlay structures, there are manefest constants defined
* for each element to de-refference the elements so that the 
* "." operator is to be used...
* to perform and overlay each fixed length part of a structure 
* will need to be overlayed, then the structure should act just
* like the static version...
*/

struct mgt_beacon_one {
    struct a3_80211		bf1_mac_hdr;
    __u8				bf1_timestamp[8];
    __u16				bf1_beacon_interval;
    struct cap_info		bf1_cap;
    struct element_id	bf1_ssid_id;
};

struct mgt_beacon_two {
    struct element_id	bf2_rates_id;
};

struct mgt_beacon_three {
    struct element_id	bf3_fh_id;
    struct fh_param		bf3_fh;
    struct element_id	bf3_ds_id;
    struct ds_param		bf3_ds;
    struct element_id	bf3_cf_id;
    struct cf_param		bf3_cf;
    struct element_id	bf3_ibss_id;
    struct ibss_param	bf3_ibss;
    struct element_id	bf3_tim_id;
    struct tim_element	bf3_tim;
};

struct mgt_beacon {
    struct mgt_beacon_one	bf_one;
    __u8					bf_ssid[32];
    struct mgt_beacon_two	bf_two;
    __u8					bf_rates[8];
    struct mgt_beacon_three	bf_three;
    __u8					bf_pvbitmap[251];
#define bf_mac_hdr			bf_one.bf1_mac_hdr
#define bf_timestamp		bf_one.bf1_timestamp
#define bf_beacon_interval	bf_one.bf1_beacon_interval
#define bf_cap				bf_one.bf1_cap
#define bf_ssid_id			bf_one.bf1_ssid_id
#define bf_rates_id			bf_two.bf2_rates_id
#define bf_fh_id			bf_three.bf3_fh_id
#define bf_fh				bf_three.bf3_fh
#define bf_ds_id			bf_three.bf3_ds_id
#define bf_ds				bf_three.bf3_ds
#define bf_cf_id			bf_three.bf3_cf_id
#define bf_cf				bf_three.bf3_cf
#define bf_ibss_id			bf_three.bf3_ibss_id
#define bf_ibss				bf_three.bf3_ibss
#define bf_tim_id			bf_three.bf3_tim_id
#define bf_tim				bf_three.bf3_tim
};

struct ov_mgt_beacon {
    struct mgt_beacon_one	*obf_one;
    __u8					*obf_ssid;
    struct mgt_beacon_two	*obf_two;
    __u8					*obf_rates;
    struct mgt_beacon_three	*obf_three;
    __u8					*obf_pvbitmap;
#define obf_mac_hdr			obf_one->bf1_mac_hdr
#define obf_timestamp		obf_one->bf1_timestamp
#define obf_beacon_interval	obf_one->bf1_beacon_interval
#define obf_cap				obf_one->bf1_cap
#define obf_ssid_id			obf_one->bf1_ssid_id
#define obf_rates_id		obf_two->bf2_rates_id
#define obf_fh_id			obf_three->bf3_fh_id
#define obf_fh				obf_three->bf3_fh
#define obf_ds_id			obf_three->bf3_ds_id
#define obf_ds				obf_three->bf3_ds
#define obf_cf_id			obf_three->bf3_cf_id
#define obf_cf				obf_three->bf3_cf
#define obf_ibss_id			obf_three->bf3_ibss_id
#define obf_ibss			obf_three->bf3_ibss
#define obf_tim_id			obf_three->bf3_tim_id
#define obf_tim				obf_three->bf3_tim
};


struct mgt_ibss_atim {
    struct a3_80211	ia_mac_hdr;
    /* null frame body */
};

struct ov_mgt_ibss_atim {
    struct a3_80211	*oia1_mac_hdr;
    /* null frame body */
#define oai_mac_hdr	(*oai1_mac_hdr)
};


struct mgt_disassociate {
    struct a3_80211	da_mac_hdr;
    __u16			da_reason_code;
};

struct ov_mgt_disassociate {
    struct a3_80211	*oda1_mac_hdr;
    __u16			*oda1_reason_code;
#define oda_mac_hdr		(*oda1_mac_hdr)
#define oda_reason_code (*oda1_reason_code)
};


struct mgt_associate_req_one {
    struct a3_80211		ar1_mac_hdr;
    struct cap_info		ar1_cap;
    __u16				ar1_listen_interval;
    struct element_id	ar1_ssid_id;
};

struct mgt_associate_req_two {
    struct element_id	ar2_rates_id;
};

struct mgt_associate_req {
    struct mgt_associate_req_one	ar_one;
    __u8							ar_ssid[32];
    struct mgt_associate_req_two	ar_two;
    __u8							ar_rates[8];
#define ar_mac_hdr			ar_one.ar1_mac_hdr
#define ar_cap				ar_one.ar1_cap
#define ar_listen_interval	ar_one.ar1_listen_interval
#define ar_ssid_id			ar_one.ar1_ssid_id
#define ar_rates_id			ar_two.ar2_rates_id
};

struct ov_mgt_associate_req {
    struct mgt_associate_req_one	*oar_one;
    __u8							*oar_ssid;
    struct mgt_associate_req_two	*oar_two;
    __u8							*oar_rates;
#define oar_mac_hdr			oar_one->ar1_mac_hdr
#define oar_cap				oar_one->ar1_cap
#define oar_listen_interval	oar_one->ar1_listen_interval
#define oar_ssid_id			oar_one->ar1_ssid_id
#define oar_rates_id		oar_two->ar2_rates_id
};


struct mgt_association_resp_one {
    struct a3_80211		as1_mac_hdr;
    struct cap_info		as1_cap;
    __u16				as1_status_code;
    __u16				as1_aid;
    struct element_id	as1_rates_id;
};

struct mgt_association_resp {
    struct mgt_association_resp_one	as_one;
    __u8							as_rates[8];
#define as_mac_hdr		as_one.as1_mac_hdr
#define as_cap			as_one.as1_cap
#define as_status_code	as_one.as1_status_code
#define as_aid			as_one.as1_aid
#define as_rates_id		as_one.as1_rates_id
};

struct ov_mgt_association_resp {
    struct mgt_association_resp_one	*oas_one;
    __u8							*oas_rates;
#define oas_mac_hdr		oas_one->as1_mac_hdr
#define oas_cap			oas_one->as1_cap
#define oas_status_code	oas_one->as1_status_code
#define oas_aid			oas_one->as1_aid
#define oas_rates_id	oas_one->as1_rates_id
};


struct mgt_probe_req_one {
    struct a3_80211		pr1_mac_hdr;
    struct element_id	pr1_ssid_id;
};

struct mgt_probe_req_two {
    struct element_id	pr2_rates_id;
};

struct mgt_probe_req {
    struct mgt_probe_req_one	pr_one;
    __u8						pr_ssid[32];
    struct mgt_probe_req_two	pr_two;
    __u8						pr_rates[8];
#define pr_mac_hdr		pr_one.pr1_mac_hdr
#define pr_ssid_id		pr_one.pr1_ssid_id
#define pr_rates_id		pr_two.pr2_rates_id
};

struct ov_mgt_probe_req {
    struct mgt_probe_req_one	*opr_one;
    __u8						*opr_ssid;
    struct mgt_probe_req_two	*opr_two;
    __u8						*opr_rates;
#define opr_mac_hdr		opr_one->pr1_mac_hdr
#define opr_ssid_id		opr_one->pr1_ssid_id
#define opr_rates_id	opr_two->pr2_rates_id
};


struct mgt_probe_resp_one {
    struct a3_80211		pp1_mac_hdr;
    __u8				pp1_timestamp;
    __u16				pp1_beacon_interval;
    struct cap_info		pp1_cap;
    struct element_id	pp1_ssid_id;
};

struct mgt_probe_resp_two {
    struct element_id	pp2_rates_id;
};

struct mgt_probe_resp_three {
    struct element_id		pp3_fh_id;
    struct fh_param			pp3_fh;
    struct element_id		pp3_ds_id;
    struct ds_param			pp3_ds;
    struct element_id		pp3_cf_id;
    struct cf_param			pp3_cf;
    struct element_id		pp3_ibss_id;
    struct ibss_param		pp3_ibss;
};

struct mgt_probe_resp {
    struct mgt_probe_resp_one	pp_one;
    __u8						pp_ssid[32];
    struct mgt_probe_resp_two	pp_two;
    __u8						pp_rates[8];
    struct mgt_probe_resp_three	pp_three;
#define pp_mac_hdr			pp_one.pp1_mac_hdr
#define pp_timestamp		pp_one.pp1_timestamp
#define pp_beacon_interval	pp_one.pp1_beacon_interval
#define pp_cap				pp_one.pp1_cap
#define pp_ssid_id			pp_one.pp1_ssid_id
#define pp_rates_id			pp_two.pp2_rates_id
#define pp_fh_id			pp_three.pp3_fh_id
#define pp_fh				pp_three.pp3_fh
#define pp_ds_id			pp_three.pp3_ds_id
#define pp_ds				pp_three.pp3_ds
#define pp_cf_id			pp_three.pp3_cf_id
#define pp_cf				pp_three.pp3_cf
#define pp_ibss_id			pp_three.pp3_ibss_id
#define pp_ibss				pp_three.pp3_ibss
};

struct ov_mgt_probe_resp {
    struct mgt_probe_resp_one	*opp_one;
    __u8						*opp_ssid;
    struct mgt_probe_resp_two	*opp_two;
    __u8						*opp_rates;
    struct mgt_probe_resp_three	*opp_three;
#define opp_mac_hdr			opp_one->pp1_mac_hdr
#define opp_timestamp		opp_one->pp1_timestamp
#define opp_beacon_interval	opp_one->pp1_beacon_interval
#define opp_cap				opp_one->pp1_cap
#define opp_ssid_id			opp_one->pp1_ssid_id
#define opp_rates_id		opp_two->pp2_rates_id
#define opp_fh_id			opp_three->pp3_fh_id
#define opp_fh				opp_three->pp3_fh
#define opp_ds_id			opp_three->pp3_ds_id
#define opp_ds				opp_three->pp3_ds
#define opp_cf_id			opp_three->pp3_cf_id
#define opp_cf				opp_three->pp3_cf
#define opp_ibss_id			opp_three->pp3_ibss_id
#define opp_ibss			opp_three->pp3_ibss
};


struct mgt_auth_one {
    struct a3_80211		at1_mac_hdr;
    __u16				at1_algo;
    __u16				at1_seq;
    struct element_id	at1_challenge_id;
};

struct mgt_auth {
    struct mgt_auth_one		at_one;
    __u8					at_challenge[253];
#define at_mac_hdr		at_one.at1_mac_hdr
#define at_algo			at_one.at1_algo
#define at_seq			at_one.at1_seq
#define at_challenge_id	at_one.at1_challenge_id
};

struct ov_mgt_auth {
    struct mgt_auth_one		*oat_one;
    __u8					*oat1_challenge;
#define oat_mac_hdr			oat_one->at1_mac_hdr
#define oat_algo			oat_one->at1_algo
#define oat_seq				oat_one->at1_seq
#define oat_challenge_id	oat_one->at1_challenge_id
#define oat_challenge		(*oat1_challenge)
};


struct mgt_deauth {
    struct a3_80211 da_mac_hdr;
    __u16			da_reason_code;
};

struct ov_mgt_deauth {
    struct a3_80211 *oda1_mac_hdr;
    __u16			*oda1_reason_code;
#define oda_mac_hdr		(*oda1_mac_hdr)
#define oda_reason_hdr	(*oda_reason_hdr)
};



#endif	/* ifdef __80211H__ */
