/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.util;

import com.darkona.adventurebackpack.AdventureBackpack;
import com.darkona.adventurebackpack.util.LogHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Calendar;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class Utils {
    public static float degreesToRadians(float degrees) {
        return degrees / 57.29578f;
    }

    public static float radiansToDegrees(float radians) {
        return radians * 57.29578f;
    }

    public static int[] calculateEaster(int year) {
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int g = (8 * b + 13) / 25;
        int h = (19 * a + b - d - g + 15) % 30;
        int j = c / 4;
        int k = c % 4;
        int m = (a + 11 * h) / 319;
        int r = (2 * e + 2 * j - k - h + m + 32) % 7;
        int n = (h - m + r + 90) / 25;
        int p = (h - m + r + n + 19) % 32;
        return new int[]{n, p};
    }

    public static String getHoliday() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        if (AdventureBackpack.instance.chineseNewYear) {
            return "ChinaNewYear";
        }
        if (AdventureBackpack.instance.hannukah) {
            return "Hannukah";
        }
        if (month == Utils.calculateEaster(year)[0] && day == Utils.calculateEaster(year)[1]) {
            return "Easter";
        }
        String dia = "Standard";
        if (month == 1) {
            if (day == 1) {
                dia = "NewYear";
            }
            if (day == 28) {
                dia = "Shuttle";
            }
        }
        if (month == 2) {
            if (day == 1) {
                dia = "Shuttle";
            }
            if (day == 14) {
                dia = "Valentines";
            }
            if (day == 23) {
                dia = "Fatherland";
            }
        }
        if (month == 3 && day == 17) {
            dia = "Patrick";
        }
        if (month == 4) {
            if (day == 1) {
                dia = "Fools";
            }
            if (day == 25) {
                dia = "Italy";
            }
        }
        if (month == 5 && (day == 8 || day == 9 || day == 10)) {
            dia = "Liberation";
        }
        if (month == 6) {
            // empty if block
        }
        if (month == 7) {
            if (day == 4) {
                dia = "USA";
            }
            if (day == 24) {
                dia = "Bolivar";
            }
            if (day == 14) {
                dia = "Bastille";
            }
        }
        if (month == 8) {
            // empty if block
        }
        if (month == 9 && day == 19) {
            dia = "Pirate";
        }
        if (month == 10) {
            if (day == 3) {
                dia = "Germany";
            }
            if (day == 12) {
                dia = "Columbus";
            }
            if (day == 31) {
                dia = "Halloween";
            }
        }
        if (month == 11 && day == 2) {
            dia = "Muertos";
        }
        if (month == 12) {
            if (day >= 22 && day <= 26) {
                dia = "Christmas";
            }
            if (day == 31) {
                dia = "NewYear";
            }
        }
        return dia;
    }

    public static int isBlockRegisteredAsFluid(Block block) {
        int fluidID = -1;
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            fluidID = fluid.getBlock() == block ? fluid.getID() : -1;
            if (fluidID <= 0) continue;
            return fluidID;
        }
        return fluidID;
    }

    public static boolean shouldGiveEmpty(ItemStack cont) {
        boolean valid = true;
        try {
            if (Class.forName("forestry.core.items.ItemLiquidContainer").isInstance(cont.func_77973_b())) {
                valid = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valid;
    }

    public static ChunkCoordinates findBlock2D(World world, int x, int y, int z, Block block, int range) {
        for (int i = x - range; i <= x + range; ++i) {
            for (int j = z - range; j <= z + range; ++j) {
                if (world.func_147439_a(i, y, j) != block) continue;
                return new ChunkCoordinates(i, y, j);
            }
        }
        return null;
    }

    public static ChunkCoordinates findBlock3D(World world, int x, int y, int z, Block block, int hRange, int vRange) {
        for (int i = y - vRange; i <= y + vRange; ++i) {
            for (int j = x - hRange; j <= x + hRange; ++j) {
                for (int k = z - hRange; k <= z + hRange; ++k) {
                    if (world.func_147439_a(j, i, k) != block) continue;
                    return new ChunkCoordinates(j, i, k);
                }
            }
        }
        return null;
    }

    public static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase().concat(s.substring(1));
    }

    public static int getOppositeCardinalFromMeta(int meta) {
        return meta % 2 == 0 ? (meta == 0 ? 2 : 0) : (meta + 1) % 4 + 1;
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayersHat(World world, EntityPlayer player, boolean flag, double reach) {
        float f = 1.0f;
        float playerPitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float playerYaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double playerPosX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double playerPosY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - (double)player.field_70129_M;
        double playerPosZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vecPlayer = Vec3.func_72443_a((double)playerPosX, (double)playerPosY, (double)playerPosZ);
        float cosYaw = (float)Math.cos(-playerYaw * 0.01745329f - 3.141593f);
        float sinYaw = (float)Math.sin(-playerYaw * 0.01745329f - 3.141593f);
        float cosPitch = (float)(-Math.cos(-playerPitch * 0.01745329f));
        float sinPitch = (float)Math.sin(-playerPitch * 0.01745329f);
        float pointX = sinYaw * cosPitch;
        float pointY = sinPitch;
        float pointZ = cosYaw * cosPitch;
        Vec3 vecPoint = vecPlayer.func_72441_c((double)pointX * reach, (double)pointY * reach, (double)pointZ * reach);
        return world.func_147447_a(vecPlayer, vecPoint, flag, !flag, flag);
    }

    public static String printCoordinates(int x, int y, int z) {
        return "X= " + x + ", Y= " + y + ", Z= " + z;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static int secondsToTicks(float seconds) {
        return (int)seconds * 20;
    }

    public static boolean inServer() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        return side == Side.SERVER;
    }

    private static ChunkCoordinates checkCoordsForBackpack(IBlockAccess world, int origX, int origZ, int X, int Y, int Z, boolean except) {
        if (except && world.isSideSolid(X, Y - 1, Z, ForgeDirection.UP, true) && world.func_147437_c(X, Y, Z) && !Utils.areCoordinatesTheSame(origX, Y, origZ, X, Y, Z)) {
            return new ChunkCoordinates(X, Y, Z);
        }
        if (!except && world.isSideSolid(X, Y - 1, Z, ForgeDirection.UP, true) && world.func_147437_c(X, Y, Z)) {
            return new ChunkCoordinates(X, Y, Z);
        }
        return null;
    }

    private static ChunkCoordinates checkCoordsForPlayer(IBlockAccess world, int origX, int origZ, int X, int Y, int Z, boolean except) {
        LogHelper.info("Checking coordinates in X=" + X + ", Y=" + Y + ", Z=" + Z);
        if (except && world.isSideSolid(X, Y - 1, Z, ForgeDirection.UP, true) && world.func_147437_c(X, Y, Z) && world.func_147437_c(X, Y + 1, Z) && !Utils.areCoordinatesTheSame2D(origX, origZ, X, Z)) {
            LogHelper.info("Found spot with the exception of the origin point");
            return new ChunkCoordinates(X, Y, Z);
        }
        if (!except && world.isSideSolid(X, Y - 1, Z, ForgeDirection.UP, true) && world.func_147437_c(X, Y, Z) && world.func_147437_c(X, Y + 1, Z)) {
            LogHelper.info("Found spot without exceptions");
            return new ChunkCoordinates(X, Y, Z);
        }
        return null;
    }

    public static ChunkCoordinates getNearestEmptyChunkCoordinatesSpiral(IBlockAccess world, int origX, int origZ, int X, int Y, int Z, int radius, boolean except, int steps, byte pass, boolean type) {
        int j;
        int i;
        if (steps >= radius) {
            return null;
        }
        if (steps % 2 == 0) {
            if (pass == 0) {
                for (i = X; i <= X + steps; ++i) {
                    ChunkCoordinates coords;
                    ChunkCoordinates chunkCoordinates = coords = type ? Utils.checkCoordsForPlayer(world, origX, origZ, X, Y, Z, except) : Utils.checkCoordsForBackpack(world, origX, origZ, X, Y, Z, except);
                    if (coords == null) continue;
                    return coords;
                }
                pass = (byte)(pass + 1);
                return Utils.getNearestEmptyChunkCoordinatesSpiral(world, origX, origZ, i, Y, j, radius, except, steps, pass, type);
            }
            if (pass == 1) {
                for (j = Z; j >= Z - steps; --j) {
                    ChunkCoordinates coords;
                    ChunkCoordinates chunkCoordinates = coords = type ? Utils.checkCoordsForPlayer(world, origX, origZ, X, Y, Z, except) : Utils.checkCoordsForBackpack(world, origX, origZ, X, Y, Z, except);
                    if (coords == null) continue;
                    return coords;
                }
                pass = (byte)(pass - 1);
                return Utils.getNearestEmptyChunkCoordinatesSpiral(world, origX, origZ, i, Y, j, radius, except, ++steps, pass, type);
            }
        }
        if (steps % 2 == 1) {
            if (pass == 0) {
                while (i >= X - steps) {
                    ChunkCoordinates coords;
                    ChunkCoordinates chunkCoordinates = coords = type ? Utils.checkCoordsForPlayer(world, origX, origZ, X, Y, Z, except) : Utils.checkCoordsForBackpack(world, origX, origZ, X, Y, Z, except);
                    if (coords != null) {
                        return coords;
                    }
                    --i;
                }
                pass = (byte)(pass + 1);
                return Utils.getNearestEmptyChunkCoordinatesSpiral(world, origX, origZ, i, Y, j, radius, except, steps, pass, type);
            }
            if (pass == 1) {
                while (j <= Z + steps) {
                    ChunkCoordinates coords;
                    ChunkCoordinates chunkCoordinates = coords = type ? Utils.checkCoordsForPlayer(world, origX, origZ, X, Y, Z, except) : Utils.checkCoordsForBackpack(world, origX, origZ, X, Y, Z, except);
                    if (coords != null) {
                        return coords;
                    }
                    ++j;
                }
                pass = (byte)(pass - 1);
                return Utils.getNearestEmptyChunkCoordinatesSpiral(world, origX, origZ, i, Y, j, radius, except, ++steps, pass, type);
            }
        }
        return null;
    }

    private static boolean areCoordinatesTheSame(int X1, int Y1, int Z1, int X2, int Y2, int Z2) {
        return X1 == X2 && Y1 == Y2 && Z1 == Z2;
    }

    private static boolean areCoordinatesTheSame2D(int X1, int Z1, int X2, int Z2) {
        return X1 == X2 && Z1 == Z2;
    }

    public static boolean notNullAndInstanceOf(Object object, Class clazz) {
        return object != null && clazz.isInstance(object);
    }
}

